/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.plateform.jbpm.core.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.plateform.jbpm.core.task.TaskMigrationRunner;
import org.nuxeo.ecm.platform.jbpm.JbpmOperation;
import org.nuxeo.ecm.platform.jbpm.JbpmService;
import org.nuxeo.ecm.platform.jbpm.NuxeoJbpmException;
import org.nuxeo.ecm.platform.jbpm.core.helper.AbandonProcessUnrestricted;
import org.nuxeo.ecm.platform.jbpm.core.helper.EndProcessUnrestricted;
import org.nuxeo.ecm.platform.jbpm.operations.AddCommentOperation;
import org.nuxeo.ecm.platform.jbpm.operations.GetRecipientsForTaskOperation;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.task.TaskProvider;
import org.nuxeo.ecm.platform.task.TaskService;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public class JBPMDocTaskProvider
implements TaskProvider {
    private static final long serialVersionUID = 1L;
    protected static final Log log = LogFactory.getLog(JBPMDocTaskProvider.class);
    public static final String PUBLISHER_JBPMTASK_NAME = "org.nuxeo.ecm.platform.publisher.jbpm.CoreProxyWithWorkflowFactory";
    public static final String PUBLISHER_TASK_NAME = "org.nuxeo.ecm.platform.publisher.task.CoreProxyWithWorkflowFactory";
    public static final String WORKFLOW_REJECT_TRANSITION = "reject";
    private JbpmService jbpmService;
    private TaskService taskService;
    private UserManager userManager;

    public static void eagerLoadTaskInstance(TaskInstance ti) {
        if (ti.getPooledActors() != null) {
            ti.getPooledActors().size();
        }
        if (ti.getVariableInstances() != null) {
            ti.getVariableInstances().size();
        }
        if (ti.getComments() != null) {
            ti.getComments().size();
        }
        if (ti.getToken() != null) {
            ti.getToken().getId();
        }
    }

    public List<Task> getCurrentTaskInstances(final CoreSession coreSession) throws ClientException {
        List migratedTasks = (List)((Object)this.getJbpmService().executeJbpmOperation(new JbpmOperation(){
            private static final long serialVersionUID = 1L;

            public Serializable run(JbpmContext context) throws NuxeoJbpmException {
                List tis = JBPMDocTaskProvider.this.getJbpmService().getCurrentTaskInstances((NuxeoPrincipal)coreSession.getPrincipal(), null);
                TaskMigrationRunner migrationRunner = new TaskMigrationRunner(tis, context, coreSession);
                try {
                    return (Serializable)((Object)migrationRunner.migrate());
                }
                catch (ClientException e) {
                    log.error((Object)"Unable to migrate task", (Throwable)e);
                    return new ArrayList();
                }
            }
        }));
        return migratedTasks;
    }

    public List<Task> getCurrentTaskInstances(final List<String> actors, final CoreSession coreSession) throws ClientException {
        List migratedTasks = (List)((Object)this.getJbpmService().executeJbpmOperation(new JbpmOperation(){
            private static final long serialVersionUID = 1L;

            public Serializable run(JbpmContext context) throws NuxeoJbpmException {
                List tis = JBPMDocTaskProvider.this.getJbpmService().getCurrentTaskInstances(actors, null);
                TaskMigrationRunner migrationRunner = new TaskMigrationRunner(tis, context, coreSession);
                try {
                    return (Serializable)((Object)migrationRunner.migrate());
                }
                catch (ClientException e) {
                    log.error((Object)"Unable to migrate task", (Throwable)e);
                    return new ArrayList();
                }
            }
        }));
        return migratedTasks;
    }

    public List<Task> getTaskInstances(final DocumentModel dm, final NuxeoPrincipal user, final CoreSession coreSession) throws ClientException {
        List migratedTasks = (List)((Object)this.getJbpmService().executeJbpmOperation(new JbpmOperation(){
            private static final long serialVersionUID = 1L;

            public Serializable run(JbpmContext context) throws NuxeoJbpmException {
                List tis = JBPMDocTaskProvider.this.getJbpmService().getTaskInstances(dm, user, null);
                TaskMigrationRunner migrationRunner = new TaskMigrationRunner(tis, context, coreSession);
                try {
                    return (Serializable)((Object)migrationRunner.migrate());
                }
                catch (ClientException e) {
                    log.error((Object)"Unable to migrate task", (Throwable)e);
                    return new ArrayList();
                }
            }
        }));
        return migratedTasks;
    }

    public List<Task> getTaskInstances(final DocumentModel dm, final List<String> actors, final CoreSession coreSession) throws ClientException {
        List migratedTasks = (List)((Object)this.getJbpmService().executeJbpmOperation(new JbpmOperation(){
            private static final long serialVersionUID = 1L;

            public Serializable run(JbpmContext context) throws NuxeoJbpmException {
                List tis = JBPMDocTaskProvider.this.getJbpmService().getTaskInstances(dm, actors, null);
                TaskMigrationRunner migrationRunner = new TaskMigrationRunner(tis, context, coreSession);
                try {
                    return (Serializable)((Object)migrationRunner.migrate());
                }
                catch (ClientException e) {
                    log.error((Object)"Unable to migrate task", (Throwable)e);
                    return new ArrayList();
                }
            }
        }));
        return migratedTasks;
    }

    public String endTask(CoreSession coreSession, NuxeoPrincipal principal, Task task, String comment, String eventName, boolean isValidated) throws ClientException {
        String seamEventName = null;
        if (task != null) {
            long taskId = Long.valueOf(task.getId());
            DocumentModel taskDoc = task.getDocument();
            String transition = isValidated ? null : WORKFLOW_REJECT_TRANSITION;
            HashMap<String, String> taskVariables = new HashMap<String, String>();
            taskVariables.put(JbpmService.TaskVariableName.validated.name(), String.valueOf(isValidated));
            HashMap<String, Object> transientVariables = new HashMap<String, Object>();
            transientVariables.put(JbpmService.VariableName.document.name(), taskDoc);
            transientVariables.put(JbpmService.VariableName.principal.name(), principal);
            try {
                this.getJbpmService().endTask(Long.valueOf(taskId), transition, taskVariables, null, transientVariables, principal);
            }
            catch (JbpmException jbpme) {
                log.info((Object)String.format("This task cannot be ended leaving the task-node with the transition '%s' => canceling the process.", transition));
                return this.cancelCurrentProcess(coreSession, taskDoc, principal, comment);
            }
            if (comment != null && !"".equals(comment)) {
                AddCommentOperation addCommentOperation = new AddCommentOperation(taskId, "user:" + principal.getName(), comment);
                this.getJbpmService().executeJbpmOperation((JbpmOperation)addCommentOperation);
            }
            coreSession.save();
            Set<String> recipients = this.getRecipientsFromTask(taskId);
            this.notifyEventListeners(eventName, comment, recipients.toArray(new String[0]), coreSession, principal, taskDoc);
            seamEventName = isValidated ? "workflowTaskCompleted" : "workflowTaskRejected";
        }
        return seamEventName;
    }

    protected Set<String> getRecipientsFromTask(long taskId) throws NuxeoJbpmException {
        GetRecipientsForTaskOperation operation = new GetRecipientsForTaskOperation(taskId);
        return (Set)((Object)this.getJbpmService().executeJbpmOperation((JbpmOperation)operation));
    }

    protected void notifyEventListeners(String name, String comment, String[] recipients, CoreSession coreSession, NuxeoPrincipal principal, DocumentModel doc) throws ClientException {
        this.getJbpmService().notifyEventListeners(name, comment, recipients, coreSession, principal, doc);
    }

    protected String cancelCurrentProcess(CoreSession coreSession, DocumentModel doc, NuxeoPrincipal principal, String comment) throws ClientException {
        String seamEventName = null;
        ProcessInstance currentProcess = this.getCurrentProcess(doc, principal);
        if (currentProcess != null) {
            Long pid = currentProcess.getId();
            if (doc != null) {
                AbandonProcessUnrestricted runner = new AbandonProcessUnrestricted(coreSession, doc.getRef(), pid);
                runner.runUnrestricted();
            }
            List tis = this.getJbpmService().getTaskInstances(coreSession.getDocument(doc.getRef()), (NuxeoPrincipal)null, null);
            EndProcessUnrestricted endProcessRunner = new EndProcessUnrestricted(coreSession, tis);
            endProcessRunner.runUnrestricted();
            this.getJbpmService().deleteProcessInstance(principal, pid);
            this.notifyEventListeners("workflowProcessCanceled", comment, endProcessRunner.getRecipients().toArray(new String[0]), coreSession, principal, doc);
            seamEventName = "workflowProcessCanceled";
        }
        return seamEventName;
    }

    protected ProcessInstance getCurrentProcess(DocumentModel doc, NuxeoPrincipal principal) throws ClientException {
        ProcessInstance currentProcess = null;
        List processes = this.getJbpmService().getProcessInstances(doc, principal, null);
        if (processes != null && !processes.isEmpty()) {
            currentProcess = (ProcessInstance)processes.get(0);
        }
        return currentProcess;
    }

    public JbpmService getJbpmService() {
        if (this.jbpmService == null) {
            try {
                this.jbpmService = (JbpmService)Framework.getService(JbpmService.class);
            }
            catch (Exception e) {
                throw new IllegalStateException("Jbpm service is not deployed.", e);
            }
        }
        return this.jbpmService;
    }

    public TaskService getTaskService() {
        if (this.taskService == null) {
            try {
                this.taskService = (TaskService)Framework.getService(TaskService.class);
            }
            catch (Exception e) {
                throw new IllegalStateException("Task service is not deployed.", e);
            }
        }
        return this.taskService;
    }

    public UserManager getUserManager() {
        if (this.userManager == null) {
            try {
                this.userManager = (UserManager)Framework.getService(UserManager.class);
            }
            catch (Exception e) {
                throw new IllegalStateException("UserManager service is not deployed.", e);
            }
        }
        return this.userManager;
    }
}

