/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.plateform.jbpm.core.task;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.graph.exe.Comment;
import org.jbpm.taskmgmt.exe.PooledActor;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.platform.jbpm.JbpmService;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.task.TaskComment;

public class JBPMTaskWrapper
implements Task {
    private static final long serialVersionUID = 1L;
    protected static Log log = LogFactory.getLog(JBPMTaskWrapper.class);
    public static final String JBPM_TASK_PROVIDER = "jbpmTaskProvider";
    private TaskInstance ti;
    private String directive;
    private String targetDocId;
    private String initiator;
    private Boolean validated;
    private DocumentModel doc;

    public JBPMTaskWrapper(TaskInstance ti) {
        this.ti = ti;
        this.targetDocId = (String)ti.getVariable(JbpmService.VariableName.documentId.name());
        this.directive = (String)ti.getVariable(JbpmService.TaskVariableName.directive.name());
        this.validated = Boolean.valueOf((String)ti.getVariable(JbpmService.TaskVariableName.validated.name()));
        this.initiator = (String)ti.getVariable(JbpmService.VariableName.initiator.name());
    }

    public DocumentModel getDocument() {
        if (this.doc == null) {
            UnrestrictedSessionRunner runner = new UnrestrictedSessionRunner((String)this.ti.getVariable(JbpmService.VariableName.documentRepositoryName.name())){

                public void run() throws ClientException {
                    JBPMTaskWrapper.this.doc = this.session.getDocument((DocumentRef)new IdRef(JBPMTaskWrapper.this.targetDocId));
                    if (JBPMTaskWrapper.this.doc instanceof DocumentModelImpl) {
                        ((DocumentModelImpl)JBPMTaskWrapper.this.doc).detach(true);
                    }
                }
            };
            try {
                runner.runUnrestricted();
            }
            catch (ClientException e) {
                log.error((Object)"Error while fetching DocumentModel", (Throwable)e);
            }
        }
        return this.doc;
    }

    public String getId() {
        return String.valueOf(this.ti.getId());
    }

    public String getTargetDocumentId() {
        return this.targetDocId;
    }

    public List<String> getActors() throws ClientException {
        Set pooledActors = this.ti.getPooledActors();
        ArrayList<String> actors = new ArrayList<String>(pooledActors.size());
        for (PooledActor pooledActor : pooledActors) {
            String actor = pooledActor.getActorId();
            if (actor.contains(":")) {
                actors.add(actor.split(":")[1]);
                continue;
            }
            actors.add(actor);
        }
        return actors;
    }

    public String getInitiator() throws ClientException {
        return this.initiator;
    }

    public String getName() throws ClientException {
        return this.ti.getName();
    }

    public String getDescription() throws ClientException {
        return this.ti.getDescription();
    }

    public String getDirective() throws ClientException {
        return this.directive;
    }

    public List<TaskComment> getComments() throws ClientException {
        List jbpmComments = this.ti.getComments();
        ArrayList<TaskComment> comments = new ArrayList<TaskComment>(jbpmComments.size());
        for (Comment taskComment : jbpmComments) {
            comments.add(new TaskComment(taskComment.getActorId(), taskComment.getMessage(), taskComment.getTime()));
        }
        return comments;
    }

    public String getVariable(String key) throws ClientException {
        if ("taskProviderId".equals(key)) {
            return JBPM_TASK_PROVIDER;
        }
        return (String)this.ti.getVariable(key);
    }

    public Date getDueDate() throws ClientException {
        return this.ti.getDueDate();
    }

    public Date getCreated() throws ClientException {
        return this.ti.getCreate();
    }

    public Boolean isCancelled() throws ClientException {
        return this.ti.isCancelled();
    }

    public Boolean isOpened() throws ClientException {
        return this.ti.isOpen();
    }

    public Boolean hasEnded() throws ClientException {
        return this.ti.hasEnded();
    }

    public Boolean isAccepted() throws ClientException {
        return this.validated;
    }

    public Map<String, String> getVariables() throws ClientException {
        return this.ti.getVariables();
    }

    public void setActors(List<String> actors) throws ClientException {
        throw new UnsupportedOperationException();
    }

    public void setInitiator(String initiator) throws ClientException {
        throw new UnsupportedOperationException();
    }

    public void setTargetDocumentId(String targetDocumentId) {
        throw new UnsupportedOperationException();
    }

    public void setName(String name) throws ClientException {
        throw new UnsupportedOperationException();
    }

    public void setDescription(String description) throws ClientException {
        throw new UnsupportedOperationException();
    }

    public void setDirective(String directive) throws ClientException {
        throw new UnsupportedOperationException();
    }

    public void setVariable(String key, String value) throws ClientException {
        throw new UnsupportedOperationException();
    }

    public void setDueDate(Date dueDate) throws ClientException {
        throw new UnsupportedOperationException();
    }

    public void setCreated(Date created) throws ClientException {
        throw new UnsupportedOperationException();
    }

    public void setAccepted(Boolean accepted) throws ClientException {
        throw new UnsupportedOperationException();
    }

    public void setVariables(Map<String, String> variables) throws ClientException {
        throw new UnsupportedOperationException();
    }

    public void addComment(String author, String text) throws ClientException {
        throw new UnsupportedOperationException();
    }

    public void cancel(CoreSession coreSession) throws ClientException {
        throw new UnsupportedOperationException();
    }

    public void end(CoreSession coreSession) throws ClientException {
        throw new UnsupportedOperationException();
    }
}

