/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.plateform.jbpm.core.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.graph.exe.Comment;
import org.jbpm.taskmgmt.exe.PooledActor;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.nuxeo.ecm.automation.task.CreateTask;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.impl.UserPrincipal;
import org.nuxeo.ecm.plateform.jbpm.core.task.JBPMDocTaskProvider;
import org.nuxeo.ecm.plateform.jbpm.core.task.JBPMTaskWrapper;
import org.nuxeo.ecm.platform.jbpm.JbpmService;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.task.TaskService;
import org.nuxeo.ecm.platform.task.core.service.CreateTaskUnrestricted;
import org.nuxeo.runtime.api.Framework;

public class TaskMigrationRunner
extends UnrestrictedSessionRunner {
    protected final List<TaskInstance> tis;
    protected List<Task> tasks;
    protected final JbpmContext context;
    protected static final Log log = LogFactory.getLog(TaskMigrationRunner.class);
    protected static Boolean migrate = null;
    public static final String TASK_MIGRATION_PROPERTY = "org.nuxeo.ecm.platform.jbpm.task.migrate";

    protected boolean needToMigrate() {
        if (migrate == null) {
            String flag = Framework.getProperty((String)TASK_MIGRATION_PROPERTY, (String)"true");
            migrate = Boolean.parseBoolean(flag);
        }
        return migrate;
    }

    protected TaskMigrationRunner(List<TaskInstance> tis, JbpmContext context, CoreSession session) {
        super(session);
        this.tis = tis;
        this.tasks = new ArrayList<Task>(tis.size());
        this.context = context;
    }

    public List<Task> migrate() throws ClientException {
        if (this.tis.size() == 0) {
            return new ArrayList<Task>();
        }
        this.runUnrestricted();
        return this.tasks;
    }

    public void run() throws ClientException {
        for (TaskInstance taskInstance : this.tis) {
            JBPMTaskWrapper migratedTask = null;
            if (this.needToMigrate()) {
                try {
                    migratedTask = this.migrateJBPMtoDocTask(taskInstance, this.context, this.session);
                }
                catch (ClientException e) {
                    log.error((Object)"Error while migrating task", (Throwable)e);
                }
            }
            if (migratedTask == null) {
                migratedTask = new JBPMTaskWrapper(taskInstance);
            }
            this.tasks.add(migratedTask);
        }
    }

    protected Task migrateJBPMtoDocTask(TaskInstance ti, JbpmContext context, CoreSession coreSession) throws ClientException {
        ti = context.getTaskInstance(ti.getId());
        JBPMDocTaskProvider.eagerLoadTaskInstance(ti);
        String commentId = (String)ti.getVariable("commentId");
        String taskName = ti.getName();
        if (commentId != null) {
            return this.migrateCommentTask(ti, context, coreSession);
        }
        if ("org.nuxeo.ecm.platform.publisher.jbpm.CoreProxyWithWorkflowFactory".equals(taskName)) {
            return this.migratePublisherTask(ti, context, coreSession);
        }
        if (ti.getProcessInstance() != null) {
            return new JBPMTaskWrapper(ti);
        }
        return this.migrateGenericTask(ti, context, coreSession, null);
    }

    private Task migrateGenericTask(TaskInstance ti, JbpmContext context, CoreSession coreSession, Map<String, String> vars) throws ClientException {
        String taskName;
        String prefixedInitiator;
        if (vars == null) {
            vars = new HashMap<String, String>();
        }
        vars.putAll(ti.getVariables());
        vars.put(Task.TaskVariableName.needi18n.name(), "true");
        Set pooledActors = ti.getPooledActors();
        ArrayList<String> actors = new ArrayList<String>();
        for (PooledActor pooledActor : pooledActors) {
            actors.add(pooledActor.getActorId());
        }
        String docId = (String)ti.getVariable(JbpmService.VariableName.documentId.name());
        DocumentModel doc = null;
        if (docId != null) {
            IdRef idRef = new IdRef(docId);
            doc = coreSession.getDocument((DocumentRef)idRef);
        }
        String userId = prefixedInitiator = (String)ti.getVariable("initiator");
        if (prefixedInitiator.contains(":")) {
            userId = prefixedInitiator.split(":")[1];
        }
        TaskService taskService = (TaskService)Framework.getLocalService(TaskService.class);
        UserPrincipal user = new UserPrincipal(userId, null, false, false);
        String parentPath = taskService.getTaskRootParentPath(coreSession);
        String directive = (String)ti.getVariable(JbpmService.TaskVariableName.directive.name());
        String comment = "";
        if (ti.getComments().size() > 0) {
            Comment jbpmComment = (Comment)ti.getComments().get(0);
            comment = jbpmComment.getMessage();
        }
        if ("org.nuxeo.ecm.platform.publisher.jbpm.CoreProxyWithWorkflowFactory".equals(taskName = ti.getName())) {
            taskName = "org.nuxeo.ecm.platform.publisher.task.CoreProxyWithWorkflowFactory";
        }
        CreateTaskUnrestricted runner = new CreateTaskUnrestricted(coreSession, (NuxeoPrincipal)user, doc, taskName, actors, false, directive, comment, ti.getDueDate(), vars, parentPath);
        runner.runUnrestricted();
        List tasks = runner.getTasks();
        ti.suspend();
        if (tasks != null && tasks.size() > 0) {
            return (Task)tasks.get(0);
        }
        return null;
    }

    private Task migrateCommentTask(TaskInstance ti, JbpmContext context, CoreSession coreSession) throws ClientException {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put(CreateTask.OperationTaskVariableName.acceptOperationChain.name(), "acceptComment");
        vars.put(CreateTask.OperationTaskVariableName.rejectOperationChain.name(), "rejectComment");
        vars.putAll(ti.getVariables());
        return this.migrateGenericTask(ti, context, coreSession, vars);
    }

    private Task migratePublisherTask(TaskInstance ti, JbpmContext context, CoreSession coreSession) throws ClientException {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put(Task.TaskVariableName.taskType.name(), "publish_moderate");
        return this.migrateGenericTask(ti, context, coreSession, vars);
    }
}

