/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.facelets;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.el.VariableMapperWrapper;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagConfig;
import com.sun.facelets.tag.TagHandler;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.forms.layout.api.FieldDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.Widget;
import org.nuxeo.ecm.platform.forms.layout.api.impl.FieldDefinitionImpl;
import org.nuxeo.ecm.platform.forms.layout.facelets.RenderVariables;
import org.nuxeo.ecm.platform.forms.layout.facelets.WidgetTagHandler;
import org.nuxeo.ecm.platform.forms.layout.service.WebLayoutManager;
import org.nuxeo.ecm.platform.ui.web.util.ComponentTagUtils;
import org.nuxeo.runtime.api.Framework;

public class WidgetTypeTagHandler
extends TagHandler {
    private static final Log log = LogFactory.getLog(WidgetTypeTagHandler.class);
    protected final TagConfig config;
    protected final TagAttribute name;
    protected final TagAttribute mode;
    protected final TagAttribute value;
    protected final TagAttribute field;
    protected final TagAttribute fields;
    protected final TagAttribute label;
    protected final TagAttribute helpLabel;
    protected final TagAttribute translated;
    protected final TagAttribute properties;
    protected final TagAttribute[] vars;
    protected final String[] reservedVarsArray = new String[]{"id", "mode", "type", "properties"};

    public WidgetTypeTagHandler(TagConfig config) {
        super(config);
        this.config = config;
        this.name = this.getRequiredAttribute("name");
        this.mode = this.getRequiredAttribute("mode");
        this.value = this.getAttribute("value");
        this.field = this.getAttribute("field");
        this.fields = this.getAttribute("fields");
        this.label = this.getAttribute("label");
        this.helpLabel = this.getAttribute("helpLabel");
        this.translated = this.getAttribute("translated");
        this.properties = this.getAttribute("properties");
        this.vars = this.tag.getAttributes().getAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, ELException {
        Map propertiesValue;
        WebLayoutManager layoutService;
        try {
            layoutService = (WebLayoutManager)Framework.getService(WebLayoutManager.class);
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
        if (layoutService == null) {
            throw new FacesException("Layout service not found");
        }
        List<String> reservedVars = Arrays.asList(this.reservedVarsArray);
        HashMap<String, Serializable> widgetProps = new HashMap<String, Serializable>();
        if (this.properties != null && (propertiesValue = (Map)this.properties.getObject(ctx, Map.class)) != null) {
            widgetProps.putAll(propertiesValue);
        }
        for (TagAttribute var : this.vars) {
            String localName = var.getLocalName();
            if (reservedVars.contains(localName)) continue;
            widgetProps.put(localName, (Serializable)((Object)var.getValue()));
        }
        String typeValue = this.name.getValue(ctx);
        String modeValue = this.mode.getValue(ctx);
        String valueName = null;
        if (this.value != null && ComponentTagUtils.isValueReference((String)(valueName = this.value.getValue()))) {
            valueName = valueName.substring(2, valueName.length() - 1);
        }
        ArrayList<FieldDefinition> fieldsValue = new ArrayList<FieldDefinition>();
        if (this.field != null) {
            String fieldValue = this.field.getValue(ctx);
            if (fieldValue instanceof FieldDefinition) {
                fieldsValue.add((FieldDefinition)fieldValue);
            } else if (fieldValue instanceof String) {
                fieldsValue.add((FieldDefinition)new FieldDefinitionImpl(null, fieldValue));
            } else {
                log.error((Object)("Invalid field item => discard: " + fieldValue));
            }
        }
        if (this.fields != null) {
            List resolvedfields = (List)this.fields.getObject(ctx, List.class);
            for (Object item : resolvedfields) {
                if (item instanceof FieldDefinition) {
                    fieldsValue.add((FieldDefinition)item);
                    continue;
                }
                if (item instanceof String) {
                    fieldsValue.add((FieldDefinition)new FieldDefinitionImpl(null, (String)item));
                    continue;
                }
                log.error((Object)("Invalid field item => discard: " + item));
            }
        }
        String labelValue = null;
        if (this.label != null) {
            labelValue = this.label.getValue();
        }
        String helpLabelValue = null;
        if (this.helpLabel != null) {
            helpLabelValue = this.helpLabel.getValue();
        }
        Boolean translatedValue = Boolean.FALSE;
        if (this.translated != null) {
            translatedValue = this.translated.getBoolean(ctx);
        }
        Widget widget = layoutService.createWidget(ctx, typeValue, modeValue, valueName, fieldsValue, labelValue, helpLabelValue, translatedValue, widgetProps, null);
        VariableMapper orig = ctx.getVariableMapper();
        VariableMapperWrapper vm = new VariableMapperWrapper(orig);
        ctx.setVariableMapper((VariableMapper)vm);
        ValueExpression widgetVe = ctx.getExpressionFactory().createValueExpression((Object)widget, Widget.class);
        vm.setVariable(RenderVariables.widgetVariables.widget.name(), widgetVe);
        vm.setVariable(String.format("%s_%s", RenderVariables.widgetVariables.widget.name(), widget.getLevel()), widgetVe);
        try {
            WidgetTagHandler.applyWidgetHandler(ctx, parent, this.config, widget, this.value, true);
        }
        finally {
            ctx.setVariableMapper(orig);
        }
    }
}

