/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.impl.task.commands;

import java.util.HashMap;
import java.util.Map;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.ValidationStatus;
import org.nuxeo.connect.update.impl.task.commands.Command;
import org.nuxeo.connect.update.impl.task.guards.Guard;
import org.nuxeo.connect.update.task.Task;
import org.w3c.dom.Element;

public abstract class AbstractCommand
implements Command {
    protected final String id;
    protected final Map<String, Object> guardVars;
    protected String fail;
    protected String ignore;

    protected AbstractCommand(String id) {
        this.id = id;
        this.guardVars = new HashMap<String, Object>();
    }

    @Override
    public boolean isPostInstall() {
        return false;
    }

    protected abstract Command doRun(Task var1, Map<String, String> var2) throws PackageException;

    protected abstract void doValidate(Task var1, ValidationStatus var2) throws PackageException;

    @Override
    public void validate(Task task, ValidationStatus status) throws PackageException {
        if (this.fail != null) {
            try {
                if (new Guard(this.fail).evaluate(this.guardVars)) {
                    status.addError("Guard failed for command " + this.getId() + ": " + this.fail);
                }
            }
            catch (Exception e) {
                throw new PackageException("Ignore guard failed: ", (Throwable)e);
            }
        }
        this.doValidate(task, status);
    }

    @Override
    public Command run(Task task, Map<String, String> prefs) throws PackageException {
        if (this.ignore()) {
            return null;
        }
        return this.doRun(task, prefs);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setFail(String fail) {
        this.fail = fail;
    }

    public void setIgnore(String ignore) {
        this.ignore = ignore;
    }

    public boolean ignore() throws PackageException {
        if (this.ignore != null) {
            try {
                return new Guard(this.ignore).evaluate(this.guardVars);
            }
            catch (Exception e) {
                throw new PackageException("Ignore guard failed: ", (Throwable)e);
            }
        }
        return false;
    }

    @Override
    public void initialize(Element element) throws PackageException {
        String v = element.getAttribute("fail");
        if (v.length() > 0) {
            this.fail = v;
        }
        if ((v = element.getAttribute("ignore")).length() > 0) {
            this.ignore = v;
        }
        this.readFrom(element);
    }

    public abstract void readFrom(Element var1) throws PackageException;
}

