/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.transaction;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.nuxeo.runtime.transaction.Transacted;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class TransactedInstanceHandler<T>
implements InvocationHandler {
    protected final T object;

    public static <T> T newProxy(T object, Class<T> itf) {
        TransactedInstanceHandler<T> h = new TransactedInstanceHandler<T>(object);
        return itf.cast(Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{itf}, h));
    }

    protected TransactedInstanceHandler(T object) {
        this.object = object;
    }

    protected boolean requireTransaction(Method m) {
        if (!m.isAnnotationPresent(Transacted.class) && !m.getClass().isAnnotationPresent(Transacted.class)) {
            return false;
        }
        return !TransactionHelper.isTransactionActive();
    }

    protected Object doInvoke(Method m, Object[] args) throws Throwable {
        try {
            return m.invoke(this.object, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (!this.requireTransaction(method)) {
            return this.doInvoke(method, args);
        }
        TransactionHelper.startTransaction();
        try {
            Object object = this.doInvoke(method, args);
            return object;
        }
        catch (Throwable e) {
            TransactionHelper.setTransactionRollbackOnly();
            throw e;
        }
        finally {
            TransactionHelper.commitOrRollbackTransaction();
        }
    }
}

