/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.directory;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.directory.DirectoryException;

@XObject(value="directoryTree")
public class DirectoryTreeDescriptor {
    private static final Log log = LogFactory.getLog(DirectoryTreeDescriptor.class);
    public static final String VOCABULARY_SCHEMA = "vocabulary";
    public static final String XVOCABULARY_SCHEMA = "xvocabulary";
    @XNode(value="@name")
    protected String name;
    @XNode(value="@enabled")
    protected Boolean enabled = true;
    @XNode(value="@isNavigationTree")
    protected boolean isNavigationTree = true;
    @XNode(value="@label")
    protected String label;
    @Deprecated
    @XNode(value="@querymodel")
    protected String querymodel;
    @XNode(value="@contentView")
    protected String contentView;
    @XNode(value="@field")
    protected String fieldName;
    @XNode(value="@schema")
    protected String schemaName;
    @XNode(value="@outcome")
    protected String outcome;
    @XNode(value="@multiselect")
    protected Boolean multiselect;
    protected String[] directories;

    @XNodeList(value="directory", componentType=String.class, type=String[].class)
    public void setDirectories(String[] directories) throws DirectoryException {
        this.directories = directories;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getName() {
        return this.name;
    }

    public String[] getDirectories() {
        return this.directories;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isMultiselect() {
        if (this.multiselect == null) {
            return false;
        }
        return this.multiselect;
    }

    public String getOutcome() {
        return this.outcome;
    }

    @Deprecated
    public String getQuerymodel() {
        return this.querymodel;
    }

    public String getContentView() {
        return this.contentView;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public boolean isNavigationTree() {
        return this.isNavigationTree;
    }

    public boolean hasContentViewSupport() {
        return this.contentView != null;
    }

    public void merge(DirectoryTreeDescriptor other) {
        if (other.schemaName != null) {
            this.schemaName = other.schemaName;
        }
        if (other.querymodel != null) {
            this.querymodel = other.querymodel;
        }
        if (other.contentView != null) {
            this.contentView = other.contentView;
        }
        if (other.outcome != null) {
            this.outcome = other.outcome;
        }
        if (other.multiselect != null) {
            this.multiselect = other.multiselect;
        }
        if (other.label != null) {
            this.label = other.label;
        }
        if (other.directories != null) {
            this.directories = other.directories;
        }
        if (other.fieldName != null) {
            this.fieldName = other.fieldName;
        }
        this.enabled = other.enabled;
        this.isNavigationTree = other.isNavigationTree;
    }
}

