/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import org.apache.directory.server.schema.bootstrap.Schema;

public abstract class AbstractSchema
implements Schema {
    private static final String[] NONE = new String[0];
    private static final String DEFAULT_OWNER = "uid=admin,ou=system";
    private boolean disabled;
    private String[] dependencies;
    private String owner;
    private String name;

    public AbstractSchema(String name) {
        this(name, null, null, false);
    }

    public AbstractSchema(String name, String owner) {
        this(name, owner, null, false);
    }

    public AbstractSchema(String name, String owner, String[] dependencies) {
        this(name, owner, dependencies, false);
    }

    public AbstractSchema(String name, String owner, String[] dependencies, boolean disabled) {
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        this.name = name;
        this.owner = owner != null ? owner : DEFAULT_OWNER;
        this.dependencies = dependencies != null ? dependencies : NONE;
        this.disabled = disabled;
    }

    public String[] getDependencies() {
        String[] copy = new String[this.dependencies.length];
        System.arraycopy(this.dependencies, 0, copy, 0, this.dependencies.length);
        return copy;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getSchemaName() {
        return this.name;
    }

    public boolean isDisabled() {
        return this.disabled;
    }
}

