/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.trigger;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.Name;
import javax.naming.NamingException;
import org.apache.directory.server.core.authn.LdapPrincipal;
import org.apache.directory.server.core.invocation.Invocation;
import org.apache.directory.server.core.jndi.ServerContext;
import org.apache.directory.server.core.jndi.ServerLdapContext;
import org.apache.directory.server.core.trigger.StoredProcedureParameterInjector;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.trigger.StoredProcedureParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStoredProcedureParameterInjector
implements StoredProcedureParameterInjector {
    private Invocation invocation;
    private Map<Class, StoredProcedureParameterInjector.MicroInjector> injectors;
    StoredProcedureParameterInjector.MicroInjector $operationPrincipalInjector = new StoredProcedureParameterInjector.MicroInjector(){

        public Object inject(StoredProcedureParameter param) throws NamingException {
            return AbstractStoredProcedureParameterInjector.this.getOperationPrincipal();
        }
    };
    StoredProcedureParameterInjector.MicroInjector $ldapContextInjector = new StoredProcedureParameterInjector.MicroInjector(){

        public Object inject(StoredProcedureParameter param) throws NamingException {
            StoredProcedureParameter.Generic_LDAP_CONTEXT ldapCtxParam = (StoredProcedureParameter.Generic_LDAP_CONTEXT)param;
            LdapDN ldapCtxName = ldapCtxParam.getCtxName();
            return ((ServerLdapContext)((ServerLdapContext)AbstractStoredProcedureParameterInjector.this.invocation.getCaller()).getRootContext()).lookup((Name)ldapCtxName);
        }
    };

    public AbstractStoredProcedureParameterInjector(Invocation invocation) throws NamingException {
        this.invocation = invocation;
        this.injectors = new HashMap<Class, StoredProcedureParameterInjector.MicroInjector>();
        this.injectors.put(StoredProcedureParameter.Generic_OPERATION_PRINCIPAL.class, this.$operationPrincipalInjector);
        this.injectors.put(StoredProcedureParameter.Generic_LDAP_CONTEXT.class, this.$ldapContextInjector);
    }

    protected Name getOperationPrincipal() throws NamingException {
        LdapPrincipal principal = ((ServerContext)this.invocation.getCaller()).getPrincipal();
        LdapDN userName = new LdapDN(principal.getName());
        return userName;
    }

    protected Map<Class, StoredProcedureParameterInjector.MicroInjector> getInjectors() {
        return this.injectors;
    }

    public Invocation getInvocation() {
        return this.invocation;
    }

    public void setInvocation(Invocation invocation) {
        this.invocation = invocation;
    }

    @Override
    public final List<Object> getArgumentsToInject(List<StoredProcedureParameter> parameterList) throws NamingException {
        ArrayList<Object> arguments = new ArrayList<Object>();
        for (StoredProcedureParameter spParameter : parameterList) {
            StoredProcedureParameterInjector.MicroInjector injector = this.injectors.get(spParameter.getClass());
            arguments.add(injector.inject(spParameter));
        }
        return arguments;
    }
}

