/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.jbpm.core.service;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.job.executor.JobExecutor;
import org.jbpm.persistence.db.DbPersistenceServiceFactory;
import org.nuxeo.ecm.platform.jbpm.JbpmService;
import org.nuxeo.ecm.platform.jbpm.JbpmTaskService;
import org.nuxeo.ecm.platform.jbpm.ProcessDefinitionDeployer;
import org.nuxeo.ecm.platform.jbpm.core.service.ActiveConfigurationDescriptor;
import org.nuxeo.ecm.platform.jbpm.core.service.ConfigurationPathDescriptor;
import org.nuxeo.ecm.platform.jbpm.core.service.DeployerDescriptor;
import org.nuxeo.ecm.platform.jbpm.core.service.JbpmServiceImpl;
import org.nuxeo.ecm.platform.jbpm.core.service.JbpmTaskServiceImpl;
import org.nuxeo.ecm.platform.jbpm.core.service.ProcessDefinitionDescriptor;
import org.nuxeo.ecm.platform.jbpm.core.service.RuntimeConfigurationSelector;
import org.nuxeo.ecm.platform.jbpm.core.service.SecurityPolicyDescriptor;
import org.nuxeo.ecm.platform.jbpm.core.service.TypeFilterDescriptor;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;

public class JbpmComponent
extends DefaultComponent {
    private static final String START_JOB_EXECUTOR = "org.nuxeo.ecm.platform.jbpm.startJobExecutor";
    public static final ComponentName NAME = new ComponentName("org.nuxeo.ecm.platform.jbpm.core.JbpmService");
    public static final String RUNTIME_CONFIGURATION = "runtime";
    private static final Log log = LogFactory.getLog(JbpmComponent.class);
    private JbpmConfiguration jbpmConfiguration;
    private final Map<String, List<String>> typeFiltersContrib = new HashMap<String, List<String>>();
    private String activeConfigurationName;
    private final Map<String, URL> paths = new HashMap<String, URL>();
    private boolean lazyInitialized;
    private final RuntimeConfigurationSelector selector = new RuntimeConfigurationSelector();
    private final JbpmServiceImpl service = new JbpmServiceImpl();
    private final JbpmTaskServiceImpl taskService = new JbpmTaskServiceImpl();
    private final HashMap<String, ProcessDefinitionDeployer> deployerDesc = new HashMap();
    private final HashMap<ProcessDefinitionDescriptor, ComponentInstance> pdDesc = new HashMap();

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        ExtensionPoint ep = Enum.valueOf(ExtensionPoint.class, extensionPoint);
        switch (ep) {
            case deployer: {
                DeployerDescriptor desc = (DeployerDescriptor)contribution;
                this.deployerDesc.put(desc.getName(), desc.getKlass().newInstance());
                break;
            }
            case processDefinition: {
                this.pdDesc.put((ProcessDefinitionDescriptor)contribution, contributor);
                break;
            }
            case activeConfiguration: {
                ActiveConfigurationDescriptor descriptor = (ActiveConfigurationDescriptor)contribution;
                this.activeConfigurationName = descriptor.getName();
                break;
            }
            case configurationPath: {
                ConfigurationPathDescriptor configPath = (ConfigurationPathDescriptor)contribution;
                String path = configPath.getPath();
                URL url = contributor.getRuntimeContext().getLocalResource(path);
                if (url == null) {
                    throw new RuntimeException("Config not found: " + path);
                }
                if (RUNTIME_CONFIGURATION.equals(configPath.getName())) {
                    log.error((Object)"'runtime' is a reserved word for configuration. You should use another name for your configuration name");
                }
                this.paths.put(configPath.getName(), url);
                break;
            }
            case securityPolicy: {
                SecurityPolicyDescriptor pmd = (SecurityPolicyDescriptor)contribution;
                this.service.addSecurityPolicy(pmd.getProcessDefinition(), pmd.getKlass().newInstance());
                break;
            }
            case typeFilter: {
                TypeFilterDescriptor tfd = (TypeFilterDescriptor)contribution;
                this.typeFiltersContrib.put(tfd.getType(), tfd.getPDs());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applicationStarted(ComponentContext context) throws Exception {
        ClassLoader jbossCL = Thread.currentThread().getContextClassLoader();
        ClassLoader nuxeoCL = Framework.class.getClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(nuxeoCL);
            ((DbPersistenceServiceFactory)this.getConfiguration().createJbpmContext().getServiceFactory("persistence")).getSessionFactory();
        }
        finally {
            Thread.currentThread().setContextClassLoader(jbossCL);
        }
    }

    public void activate(ComponentContext context) throws Exception {
        for (Map.Entry<ProcessDefinitionDescriptor, ComponentInstance> entry : this.pdDesc.entrySet()) {
            ProcessDefinitionDescriptor pdDescriptor = entry.getKey();
            ProcessDefinitionDeployer deployer = this.deployerDesc.get(pdDescriptor.getDeployer());
            if (deployer == null) {
                log.warn((Object)("No deployer named '" + entry.getKey().getDeployer() + "' have been registered."));
                continue;
            }
            URL url = entry.getValue().getRuntimeContext().getResource(pdDescriptor.getPath());
            if (!deployer.isDeployable(url)) continue;
            log.debug((Object)("Deploying process definition: " + url.getPath()));
            deployer.deploy(url);
        }
    }

    public void deactivate(ComponentContext context) throws Exception {
        JobExecutor jobExecutor = this.getConfiguration().getJobExecutor();
        if (jobExecutor != null && jobExecutor.isStarted()) {
            jobExecutor.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getAdapter(Class<T> adapter) {
        if (JbpmService.class.isAssignableFrom(adapter)) {
            if (this.service.getConfiguration() == null) {
                JbpmServiceImpl jbpmServiceImpl = this.service;
                synchronized (jbpmServiceImpl) {
                    this.service.setConfiguration(this.getConfiguration());
                    this.initialize();
                }
            }
            return (T)this.service;
        }
        if (JbpmTaskService.class.isAssignableFrom(adapter)) {
            return (T)this.taskService;
        }
        return null;
    }

    private JbpmConfiguration getConfiguration() {
        if (this.jbpmConfiguration == null) {
            InputStream is;
            URL url;
            if (RUNTIME_CONFIGURATION.equals(this.activeConfigurationName)) {
                String configurationName = this.selector.getConfigurationName();
                url = this.paths.get(configurationName);
            } else {
                url = this.paths.get(this.activeConfigurationName);
            }
            try {
                is = url.openStream();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to open input stream for jbpm configuration " + this.activeConfigurationName, e);
            }
            this.jbpmConfiguration = JbpmConfiguration.parseInputStream((InputStream)is);
            try {
                is.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to open input stream for jbpm configuration.", e);
            }
        }
        return this.jbpmConfiguration;
    }

    private void initialize() {
        if (!this.lazyInitialized) {
            JobExecutor jobExecutor;
            for (Map.Entry<ProcessDefinitionDescriptor, ComponentInstance> entry : this.pdDesc.entrySet()) {
                ProcessDefinitionDescriptor descriptor = entry.getKey();
                ProcessDefinitionDeployer deployer = this.deployerDesc.get(descriptor.getDeployer());
                ComponentInstance cmpt = entry.getValue();
                URL url = cmpt.getContext().getResource(descriptor.getPath());
                try {
                    deployer.deploy(url);
                }
                catch (Exception e) {
                    log.error((Object)("error deploying url: " + url), (Throwable)e);
                }
            }
            this.service.setTypeFilters(this.typeFiltersContrib);
            boolean startJobExecutor = Boolean.parseBoolean(Framework.getProperty((String)START_JOB_EXECUTOR, (String)"false"));
            if (startJobExecutor && (jobExecutor = this.getConfiguration().getJobExecutor()) != null) {
                jobExecutor.start();
            }
        }
    }

    public static enum ExtensionPoint {
        deployer,
        processDefinition,
        activeConfiguration,
        configurationPath,
        securityPolicy,
        typeFilter;

    }

    public static enum ConfigurationName {
        jboss,
        jetty,
        glassfish,
        tomcat,
        tomcatTransactional,
        tomcatNontransactional;

    }
}

