/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.jbpm.core.listener;

import java.util.List;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.jbpm.JbpmService;
import org.nuxeo.runtime.api.Framework;

public class DeleteProcessForDeletedDocumentListener
implements EventListener {
    private JbpmService jbpmService;

    public JbpmService getJbpmService() {
        if (this.jbpmService == null) {
            try {
                this.jbpmService = (JbpmService)Framework.getService(JbpmService.class);
            }
            catch (Exception e) {
                throw new ClientRuntimeException("JbpmService is not deployed", (Throwable)e);
            }
        }
        return this.jbpmService;
    }

    public void handleEvent(Event event) throws ClientException {
        if ("aboutToRemove".equals(event.getName())) {
            List tasks;
            DocumentEventContext context = (DocumentEventContext)event.getContext();
            DocumentModel dm = context.getSourceDocument();
            NuxeoPrincipal principal = (NuxeoPrincipal)context.getPrincipal();
            List processes = this.getJbpmService().getProcessInstances(dm, principal, null);
            if (!processes.isEmpty()) {
                for (ProcessInstance process : processes) {
                    this.getJbpmService().deleteProcessInstance(principal, Long.valueOf(process.getId()));
                }
            }
            if (!(tasks = this.getJbpmService().getTaskInstances(dm, principal, null)).isEmpty()) {
                for (TaskInstance task : tasks) {
                    this.getJbpmService().deleteTaskInstance(principal, Long.valueOf(task.getId()));
                }
            }
        }
    }
}

