/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.admin.setup;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.validator.ValidatorException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;
import org.nuxeo.launcher.commons.DatabaseDriverException;
import org.nuxeo.launcher.config.ConfigurationException;
import org.nuxeo.launcher.config.ConfigurationGenerator;

@Scope(value=ScopeType.SESSION)
@Name(value="setupWizardAction")
public class SetupWizardActionBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Log log = LogFactory.getLog(SetupWizardActionBean.class);
    private static final String[] managedKeyParameters = new String[]{"nuxeo.bind.address", "nuxeo.url", "nuxeo.data.dir", "nuxeo.log.dir", "org.nuxeo.ecm.product.name", "org.nuxeo.ecm.product.version", "nuxeo.conf", "nuxeo.dbtemplate", "nuxeo.db.name", "nuxeo.db.user", "nuxeo.db.password", "nuxeo.db.host", "nuxeo.db.port", "nuxeo.db.min-pool-size", "nuxeo.db.min-pool-size", "nuxeo.db.max-pool-size", "nuxeo.vcs.min-pool-size", "nuxeo.vcs.max-pool-size", "nuxeo.notification.eMailSubjectPrefix", "mailservice.user", "mailservice.password", "mail.store.protocol", "mail.transport.protocol", "mail.store.host", "mail.store.port", "mail.store.user", "mail.store.password", "mail.debug", "mail.transport.host", "mail.transport.port", "mail.transport.auth", "mail.transport.user", "mail.transport.password", "mail.from", "mail.user", "mail.transport.usetls", "nuxeo.http.proxy.host", "nuxeo.http.proxy.port", "nuxeo.http.proxy.login", "nuxeo.http.proxy.password"};
    @In(create=true, required=false)
    protected FacesMessages facesMessages;
    protected Map<String, String> parameters;
    protected Map<String, String> advancedParameters;
    protected static final String PROXY_NONE = "none";
    protected static final String PROXY_ANONYMOUS = "anonymous";
    protected static final String PROXY_AUTHENTICATED = "authenticated";
    private static final String ERROR_DB_DRIVER = "error.db.driver.notfound";
    private static final String ERROR_DB_CONNECTION = "error.db.connection";
    private static final String ERROR_DB_FS = "error.db.fs";
    protected String proxyType = "none";
    protected boolean needsRestart = false;
    protected boolean configurable = false;
    @In(create=true)
    protected transient ResourcesAccessor resourcesAccessor;
    private transient ConfigurationGenerator configGenerator;
    protected Properties userConfig;

    @Factory(value="advancedParams", scope=ScopeType.EVENT)
    public Map<String, String> getAdvancedParameters() {
        if (this.advancedParameters == null) {
            this.readParameters();
        }
        return this.advancedParameters;
    }

    @Factory(value="configurable", scope=ScopeType.SESSION)
    public boolean isConfigurable() {
        if (this.configGenerator == null) {
            this.readParameters();
        }
        return this.configurable;
    }

    @Factory(value="setupRequiresRestart", scope=ScopeType.EVENT)
    public boolean isNeedsRestart() {
        return this.needsRestart;
    }

    @Factory(value="setupParams", scope=ScopeType.EVENT)
    public Map<String, String> getParameters() {
        if (this.parameters == null) {
            this.readParameters();
        }
        return this.parameters;
    }

    protected void readParameters() {
        this.configGenerator = new ConfigurationGenerator();
        this.configGenerator.init();
        this.configurable = this.configGenerator.isConfigurable();
        if (this.configurable) {
            this.setParameters();
        } else {
            log.debug((Object)"Server not configurable !");
        }
    }

    protected void setParameters() {
        this.userConfig = this.configGenerator.getUserConfig();
        this.parameters = new HashMap<String, String>();
        this.advancedParameters = new TreeMap<String, String>();
        for (String key : this.userConfig.stringPropertyNames()) {
            if (System.getProperty(key) != null && !key.matches("^(nuxeo|org\\.nuxeo|catalina|derby|h2|java\\.home|java\\.io\\.tmpdir|tomcat|sun\\.rmi\\.dgc).*")) continue;
            this.advancedParameters.put(key, this.userConfig.getProperty(key).trim());
        }
        for (String keyParam : managedKeyParameters) {
            this.setParameter(keyParam);
        }
        this.proxyType = PROXY_NONE;
        if (this.parameters.get("nuxeo.http.proxy.host") != null) {
            this.proxyType = PROXY_ANONYMOUS;
            if (this.parameters.get("nuxeo.http.proxy.login") != null) {
                this.proxyType = PROXY_AUTHENTICATED;
            }
        }
    }

    private void setParameter(String key) {
        String parameter = this.userConfig.getProperty(key);
        if (parameter != null) {
            this.parameters.put(key, parameter.trim());
            this.advancedParameters.remove(key);
        }
    }

    public void save() {
        this.saveParameters();
        this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("label.parameters.saved"), new Object[0]);
        this.needsRestart = true;
        this.resetParameters();
    }

    protected void saveParameters() {
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            if (entry.getValue() instanceof Long) {
                entry.setValue(((Long)((Object)entry.getValue())).toString());
            }
            if (!(entry.getValue() instanceof Boolean)) continue;
            entry.setValue(((Boolean)((Object)entry.getValue())).toString());
        }
        if (!PROXY_AUTHENTICATED.equals(this.proxyType)) {
            this.parameters.put("nuxeo.http.proxy.login", "");
            this.parameters.put("nuxeo.http.proxy.password", "");
        }
        if (PROXY_NONE.equals(this.proxyType)) {
            this.parameters.put("nuxeo.http.proxy.host", "");
            this.parameters.put("nuxeo.http.proxy.port", "");
        }
        for (String pwdKey : new String[]{"nuxeo.db.password", "mailservice.password", "mail.transport.password", "nuxeo.http.proxy.password"}) {
            if (!StringUtils.isEmpty((String)this.parameters.get(pwdKey))) continue;
            this.parameters.remove(pwdKey);
        }
        HashMap<String, String> customParameters = new HashMap<String, String>();
        customParameters.putAll(this.parameters);
        customParameters.putAll(this.advancedParameters);
        try {
            this.configGenerator.saveFilteredConfiguration(customParameters);
        }
        catch (ConfigurationException e) {
            log.error((Object)e);
        }
    }

    public void resetParameters() {
        this.readParameters();
        Contexts.getEventContext().remove("setupParams");
        Contexts.getEventContext().remove("advancedParams");
        Contexts.getEventContext().remove("setupRequiresRestart");
    }

    public void checkDatabaseParameters(FacesContext context, UIComponent component, Object value) {
        FacesMessage message;
        Map attributes = component.getAttributes();
        String dbNameInputId = (String)attributes.get("dbNameInputId");
        String dbUserInputId = (String)attributes.get("dbUserInputId");
        String dbPwdInputId = (String)attributes.get("dbPwdInputId");
        String dbHostInputId = (String)attributes.get("dbHostInputId");
        String dbPortInputId = (String)attributes.get("dbPortInputId");
        if (dbNameInputId == null || dbUserInputId == null || dbPwdInputId == null || dbHostInputId == null || dbPortInputId == null) {
            log.error((Object)"Cannot validate database parameters: missing inputIds");
            return;
        }
        UIInput dbNameComp = (UIInput)component.findComponent(dbNameInputId);
        UIInput dbUserComp = (UIInput)component.findComponent(dbUserInputId);
        UIInput dbPwdComp = (UIInput)component.findComponent(dbPwdInputId);
        UIInput dbHostComp = (UIInput)component.findComponent(dbHostInputId);
        UIInput dbPortComp = (UIInput)component.findComponent(dbPortInputId);
        if (dbNameComp == null || dbUserComp == null || dbPwdComp == null || dbHostComp == null || dbPortComp == null) {
            log.error((Object)"Cannot validate inputs: not found");
            return;
        }
        String dbName = (String)dbNameComp.getLocalValue();
        String dbUser = (String)dbUserComp.getLocalValue();
        String dbPwd = (String)dbPwdComp.getLocalValue();
        String dbHost = (String)dbHostComp.getLocalValue();
        Long dbPortLong = (Long)dbPortComp.getLocalValue();
        String dbPort = dbPortLong.toString();
        if (StringUtils.isEmpty((String)dbPwd)) {
            dbPwd = this.parameters.get("nuxeo.db.password");
        }
        String errorLabel = null;
        Throwable error = null;
        try {
            this.configGenerator.checkDatabaseConnection(this.parameters.get("nuxeo.dbtemplate"), dbName, dbUser, dbPwd, dbHost, dbPort);
        }
        catch (FileNotFoundException e) {
            errorLabel = ERROR_DB_FS;
            error = e;
        }
        catch (IOException e) {
            errorLabel = ERROR_DB_FS;
            error = e;
        }
        catch (DatabaseDriverException e) {
            errorLabel = ERROR_DB_DRIVER;
            error = e;
        }
        catch (SQLException e) {
            errorLabel = ERROR_DB_CONNECTION;
            error = e;
        }
        if (error != null) {
            log.error((Object)error);
            message = new FacesMessage(FacesMessage.SEVERITY_ERROR, ComponentUtils.translate((FacesContext)context, (String)errorLabel), null);
            throw new ValidatorException(message);
        }
        message = new FacesMessage(FacesMessage.SEVERITY_INFO, ComponentUtils.translate((FacesContext)context, (String)"error.db.none"), null);
        message.setSeverity(FacesMessage.SEVERITY_INFO);
        context.addMessage(component.getClientId(context), message);
    }

    public void templateChange(ActionEvent event) {
        UIComponent select = event.getComponent().getParent();
        if (!(select instanceof ValueHolder)) {
            log.error((Object)("Bad component returned " + select));
            throw new AbortProcessingException("Bad component returned " + select);
        }
        String dbTemplate = (String)((ValueHolder)select).getValue();
        this.configGenerator.changeDBTemplate(dbTemplate);
        this.setParameters();
        Contexts.getEventContext().remove("setupParams");
        Contexts.getEventContext().remove("advancedParams");
        FacesContext context = FacesContext.getCurrentInstance();
        context.renderResponse();
    }

    public void proxyChange(ActionEvent event) {
        UIComponent select = event.getComponent().getParent();
        if (!(select instanceof ValueHolder)) {
            log.error((Object)("Bad component returned " + select));
            throw new AbortProcessingException("Bad component returned " + select);
        }
        this.proxyType = (String)((ValueHolder)select).getValue();
        Contexts.getEventContext().remove("setupParams");
        FacesContext context = FacesContext.getCurrentInstance();
        context.renderResponse();
    }

    public String getProxyType() {
        return this.proxyType;
    }

    public void setProxyType(String proxyType) {
        this.proxyType = proxyType;
    }
}

