/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.rest;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.ConfigNavigationCase;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StaticNavigationHandler {
    private static final Log log = LogFactory.getLog(StaticNavigationHandler.class);
    private final HashMap<String, String> outcomeToViewId = new HashMap();
    private final HashMap<String, String> viewIdToOutcome = new HashMap();

    public StaticNavigationHandler(ServletContext context) {
        ApplicationAssociate associate = ApplicationAssociate.getCurrentInstance();
        for (List cases : associate.getNavigationCaseListMappings().values()) {
            for (ConfigNavigationCase cnc : cases) {
                String toViewId = cnc.getToViewId();
                String fromOutcome = cnc.getFromOutcome();
                this.outcomeToViewId.put(fromOutcome, toViewId);
                this.viewIdToOutcome.put(toViewId, fromOutcome);
            }
        }
    }

    public String getOutcomeFromViewId(String viewId) {
        if (viewId == null) {
            return null;
        }
        if (this.viewIdToOutcome.containsKey(viewId = viewId.replace(".faces", ".xhtml"))) {
            return this.viewIdToOutcome.get(viewId);
        }
        return viewId;
    }

    public String getViewIdFromOutcome(String outcome) {
        if (outcome == null) {
            return null;
        }
        if (this.outcomeToViewId.containsKey(outcome)) {
            return this.outcomeToViewId.get(outcome).replace(".xhtml", ".faces");
        }
        return "/" + outcome + ".faces";
    }
}

