/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.util;

import java.io.Serializable;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectItems;
import javax.faces.component.UISelectMany;
import javax.faces.component.ValueHolder;
import javax.faces.event.ActionEvent;
import javax.faces.model.SelectItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.web.RequestParameter;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.platform.ui.web.component.list.UIEditableList;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;

@Name(value="selectionActions")
@Scope(value=ScopeType.EVENT)
public class SelectionActionsBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(SelectionActionsBean.class);
    @RequestParameter
    protected String leftSelect;
    @RequestParameter
    protected String leftItems;
    @RequestParameter
    protected String rightSelect;
    @RequestParameter
    protected String rightItems;
    @RequestParameter
    protected String submittedList;
    @RequestParameter
    protected String selectorId;
    @RequestParameter
    protected String valueHolderId;
    protected String selectedValue;
    protected String selectedValueHolder;

    public String getSelectedValue() {
        return this.selectedValue;
    }

    public void setSelectedValue(String selectedValue) {
        this.selectedValue = selectedValue;
    }

    public String getSelectedValueHolder() {
        return this.selectedValueHolder;
    }

    public void setSelectedValueHolder(String selectedValueHolder) {
        this.selectedValueHolder = selectedValueHolder;
    }

    public SelectItem[] getEmptySelection() {
        return new SelectItem[0];
    }

    protected boolean checkRightComponents() {
        String logPrefix = "Check right components: ";
        if (this.rightSelect == null) {
            log.error((Object)(logPrefix + "No select component name"));
            return false;
        }
        if (this.rightItems == null) {
            log.error((Object)(logPrefix + "No items component name"));
            return false;
        }
        return true;
    }

    protected boolean checkLeftComponents() {
        String logPrefix = "Check left components: ";
        if (this.leftSelect == null) {
            log.error((Object)(logPrefix + "No select component name"));
            return false;
        }
        if (this.leftItems == null) {
            log.error((Object)(logPrefix + "No items component name"));
            return false;
        }
        return true;
    }

    protected boolean checkSubmittedList() {
        String logPrefix = "Check submitted list: ";
        if (this.submittedList == null) {
            log.error((Object)(logPrefix + "No component name"));
            return false;
        }
        return true;
    }

    public void shiftSelected(ShiftType stype, ActionEvent event) {
        if (!this.checkRightComponents() || !this.checkSubmittedList()) {
            return;
        }
        UIComponent eventComp = event.getComponent();
        UIComponent rightItemsComp = eventComp.findComponent(this.rightItems);
        UIComponent rightSelectComp = eventComp.findComponent(this.rightSelect);
        UIComponent hiddenTargetListComp = eventComp.findComponent(this.submittedList);
        if (rightSelectComp instanceof UISelectMany && rightItemsComp instanceof UISelectItems && hiddenTargetListComp instanceof UIEditableList) {
            UISelectItems targetItems = (UISelectItems)rightItemsComp;
            UISelectMany targetComp = (UISelectMany)rightSelectComp;
            UIEditableList hiddenTargetList = (UIEditableList)hiddenTargetListComp;
            switch (stype) {
                case UP: {
                    ComponentUtils.shiftItemsUp(targetComp, targetItems, hiddenTargetList);
                    break;
                }
                case DOWN: {
                    ComponentUtils.shiftItemsDown(targetComp, targetItems, hiddenTargetList);
                    break;
                }
                case FIRST: {
                    ComponentUtils.shiftItemsFirst(targetComp, targetItems, hiddenTargetList);
                    break;
                }
                case LAST: {
                    ComponentUtils.shiftItemsLast(targetComp, targetItems, hiddenTargetList);
                }
            }
        }
    }

    public void shiftSelectedUp(ActionEvent event) throws ClientException {
        this.shiftSelected(ShiftType.UP, event);
    }

    public void shiftSelectedDown(ActionEvent event) throws ClientException {
        this.shiftSelected(ShiftType.DOWN, event);
    }

    public void shiftSelectedFirst(ActionEvent event) throws ClientException {
        this.shiftSelected(ShiftType.FIRST, event);
    }

    public void shiftSelectedLast(ActionEvent event) throws ClientException {
        this.shiftSelected(ShiftType.LAST, event);
    }

    public void addToSelection(ActionEvent event) throws ClientException {
        if (!(this.checkLeftComponents() && this.checkRightComponents() && this.checkSubmittedList())) {
            return;
        }
        UIComponent eventComp = event.getComponent();
        UIComponent leftSelectComp = eventComp.findComponent(this.leftSelect);
        UIComponent leftItemsComp = eventComp.findComponent(this.leftItems);
        UIComponent rightItemsComp = eventComp.findComponent(this.rightItems);
        UIComponent hiddenTargetListComp = eventComp.findComponent(this.submittedList);
        if (leftSelectComp instanceof UISelectMany && leftItemsComp instanceof UISelectItems && rightItemsComp instanceof UISelectItems && hiddenTargetListComp instanceof UIEditableList) {
            UISelectMany sourceSelect = (UISelectMany)leftSelectComp;
            UISelectItems sourceItems = (UISelectItems)leftItemsComp;
            UISelectItems targetItems = (UISelectItems)rightItemsComp;
            UIEditableList hiddenTargetList = (UIEditableList)hiddenTargetListComp;
            ComponentUtils.moveItems(sourceSelect, sourceItems, targetItems, hiddenTargetList, true);
        }
    }

    public void removeFromSelection(ActionEvent event) throws ClientException {
        if (!(this.checkLeftComponents() && this.checkRightComponents() && this.checkSubmittedList())) {
            return;
        }
        UIComponent eventComp = event.getComponent();
        UIComponent leftItemsComp = eventComp.findComponent(this.leftItems);
        UIComponent rightSelectComp = eventComp.findComponent(this.rightSelect);
        UIComponent rightItemsComp = eventComp.findComponent(this.rightItems);
        UIComponent hiddenTargetListComp = eventComp.findComponent(this.submittedList);
        if (leftItemsComp instanceof UISelectItems && rightSelectComp instanceof UISelectMany && rightItemsComp instanceof UISelectItems && hiddenTargetListComp instanceof UIEditableList) {
            UISelectItems leftItems = (UISelectItems)leftItemsComp;
            UISelectMany rightSelect = (UISelectMany)rightSelectComp;
            UISelectItems rightItems = (UISelectItems)rightItemsComp;
            UIEditableList hiddenTargetList = (UIEditableList)hiddenTargetListComp;
            ComponentUtils.moveItems(rightSelect, rightItems, leftItems, hiddenTargetList, false);
        }
    }

    public void addAllToSelection(ActionEvent event) {
        if (!(this.checkLeftComponents() && this.checkRightComponents() && this.checkSubmittedList())) {
            return;
        }
        UIComponent eventComp = event.getComponent();
        UIComponent leftItemsComp = eventComp.findComponent(this.leftItems);
        UIComponent rightItemsComp = eventComp.findComponent(this.rightItems);
        UIComponent hiddenTargetListComp = eventComp.findComponent(this.submittedList);
        if (leftItemsComp instanceof UISelectItems && rightItemsComp instanceof UISelectItems && hiddenTargetListComp instanceof UIEditableList) {
            UISelectItems sourceItems = (UISelectItems)leftItemsComp;
            UISelectItems targetItems = (UISelectItems)rightItemsComp;
            UIEditableList hiddenTargetList = (UIEditableList)hiddenTargetListComp;
            ComponentUtils.moveAllItems(sourceItems, targetItems, hiddenTargetList, true);
        }
    }

    public UISelectMany getSourceSelectComponent(ActionEvent event) {
        if (this.leftSelect == null) {
            log.warn((Object)"Unable to find leftSelect component. Param 'leftSelect' not sent in request");
            return null;
        }
        UIComponent eventComp = event.getComponent();
        UIComponent leftSelectComp = eventComp.findComponent(this.leftSelect);
        if (leftSelectComp instanceof UISelectMany) {
            return (UISelectMany)leftSelectComp;
        }
        return null;
    }

    public UISelectItems getSourceSelectItems(ActionEvent event) {
        if (this.leftItems == null) {
            log.warn((Object)"Unable to find leftItems component. Param 'leftItems' not sent in request");
            return null;
        }
        UIComponent eventComp = event.getComponent();
        UIComponent leftItemsComp = eventComp.findComponent(this.leftItems);
        if (leftItemsComp instanceof UISelectItems) {
            return (UISelectItems)leftItemsComp;
        }
        return null;
    }

    public void removeAllFromSelection(ActionEvent event) throws ClientException {
        if (!(this.checkLeftComponents() && this.checkRightComponents() && this.checkSubmittedList())) {
            return;
        }
        UIComponent eventComp = event.getComponent();
        UIComponent leftItemsComp = eventComp.findComponent(this.leftItems);
        UIComponent rightItemsComp = eventComp.findComponent(this.rightItems);
        UIComponent hiddenTargetListComp = eventComp.findComponent(this.submittedList);
        if (leftItemsComp instanceof UISelectItems && rightItemsComp instanceof UISelectItems && hiddenTargetListComp instanceof UIEditableList) {
            UISelectItems leftItems = (UISelectItems)leftItemsComp;
            UISelectItems rightItems = (UISelectItems)rightItemsComp;
            UIEditableList hiddenTargetList = (UIEditableList)hiddenTargetListComp;
            ComponentUtils.moveAllItems(rightItems, leftItems, hiddenTargetList, false);
        }
    }

    public void onSelection(ActionEvent event) {
        UIComponent eventComp = event.getComponent();
        ValueHolder selectComp = ComponentUtils.getComponent(eventComp, this.selectorId, ValueHolder.class);
        if (selectComp != null) {
            Object value = selectComp.getValue();
            ValueHolder valueHolderComp = ComponentUtils.getComponent(eventComp, this.valueHolderId, ValueHolder.class);
            if (valueHolderComp != null) {
                if (valueHolderComp instanceof EditableValueHolder) {
                    ((EditableValueHolder)valueHolderComp).setSubmittedValue(value);
                } else {
                    valueHolderComp.setValue(value);
                }
            }
        }
    }

    public void onClick(ActionEvent event) {
        String selectedValueHolder;
        UIComponent component = event.getComponent();
        if (component == null) {
            return;
        }
        EditableValueHolder hiddenSelector = null;
        UIComponent base = null;
        if (this.valueHolderId != null) {
            base = ComponentUtils.getBase(component);
            hiddenSelector = ComponentUtils.getComponent(base, this.valueHolderId, EditableValueHolder.class);
        }
        if (hiddenSelector == null && (selectedValueHolder = this.getSelectedValueHolder()) != null) {
            if (base == null) {
                base = ComponentUtils.getBase(component);
            }
            hiddenSelector = ComponentUtils.getComponent(base, selectedValueHolder, EditableValueHolder.class);
        }
        if (hiddenSelector != null) {
            String selectedValue = this.getSelectedValue();
            if (hiddenSelector != null) {
                hiddenSelector.setSubmittedValue((Object)selectedValue);
            }
        }
    }

    public static enum ShiftType {
        FIRST,
        UP,
        DOWN,
        LAST;

    }
}

