/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j;

import org.sat4j.AbstractLauncher;
import org.sat4j.ExitCode;
import org.sat4j.core.ASolverFactory;
import org.sat4j.minisat.SolverFactory;
import org.sat4j.reader.InstanceReader;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ISolver;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicLauncher<T extends ISolver>
extends AbstractLauncher {
    private static final long serialVersionUID = 1L;
    private final ASolverFactory<T> factory;
    private boolean prime = false;

    public BasicLauncher(ASolverFactory<T> factory) {
        this.factory = factory;
    }

    public static void main(String[] args) {
        BasicLauncher<ISolver> lanceur = new BasicLauncher<ISolver>(SolverFactory.instance());
        if (args.length != 1) {
            lanceur.usage();
            return;
        }
        lanceur.run(args);
        System.exit(lanceur.getExitCode().value());
    }

    @Override
    protected ISolver configureSolver(String[] args) {
        this.prime = System.getProperty("prime") != null;
        T asolver = this.factory.defaultSolver();
        asolver.setTimeout(Integer.MAX_VALUE);
        asolver.setDBSimplificationAllowed(true);
        this.getLogWriter().println(asolver.toString("c "));
        return asolver;
    }

    @Override
    protected Reader createReader(ISolver theSolver, String problemname) {
        return new InstanceReader(theSolver);
    }

    @Override
    public void usage() {
        this.log("java -jar org.sat4j.core.jar <cnffile>");
    }

    @Override
    protected String getInstanceName(String[] args) {
        if (args.length == 0) {
            return null;
        }
        return args[0];
    }

    @Override
    protected void displayResult() {
        super.displayResult();
        if (this.prime && this.exitCode == ExitCode.SATISFIABLE) {
            this.log("For information, a prime implicant:");
            long begin = System.currentTimeMillis();
            int[] implicant = this.solver.primeImplicant();
            this.out.println("c ");
            this.reader.decode(implicant, this.out);
            this.out.println();
            this.log(new StringBuffer(" prime computation time: ").append((System.currentTimeMillis() - begin) / 1000L).append("s").toString());
        }
    }
}

