/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.coremodel;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.NXCore;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.model.DocumentPart;
import org.nuxeo.ecm.core.lifecycle.LifeCycle;
import org.nuxeo.ecm.core.lifecycle.LifeCycleException;
import org.nuxeo.ecm.core.lifecycle.LifeCycleService;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.model.DocumentIterator;
import org.nuxeo.ecm.core.model.EmptyDocumentIterator;
import org.nuxeo.ecm.core.model.Property;
import org.nuxeo.ecm.core.model.Repository;
import org.nuxeo.ecm.core.model.Session;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.CompositeType;
import org.nuxeo.ecm.core.storage.sql.Node;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLComplexProperty;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLDocument;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLDocumentListIterator;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLDocumentVersion;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLSession;

public class SQLDocumentLive
extends SQLComplexProperty
implements SQLDocument {
    private static final Log log = LogFactory.getLog(SQLDocumentLive.class);
    protected final List<CompositeType> mixinTypes;
    protected static final Map<String, String> systemPropNameMap = new HashMap<String, String>();

    protected SQLDocumentLive(Node node, ComplexType type, List<CompositeType> mixinTypes, SQLSession session, boolean readonly) {
        super(node, type, session, readonly);
        this.mixinTypes = mixinTypes;
    }

    @Override
    public Property getACLProperty() throws DocumentException {
        return this.session.makeACLProperty(this.getNode());
    }

    public DocumentType getType() {
        return (DocumentType)this.type;
    }

    public Session getSession() {
        return this.session;
    }

    public boolean isFolder() {
        return this.type == null || ((DocumentType)this.type).isFolder();
    }

    public String getUUID() {
        return this.getNode().getId().toString();
    }

    public Document getParent() throws DocumentException {
        return this.session.getParent(this.getNode());
    }

    public String getPath() throws DocumentException {
        return this.session.getPath(this.getNode());
    }

    public Calendar getLastModified() {
        throw new UnsupportedOperationException("unused");
    }

    public boolean isProxy() {
        return false;
    }

    public Repository getRepository() {
        return this.session.getRepository();
    }

    public void remove() throws DocumentException {
        this.session.remove(this.getNode());
    }

    public void save() throws DocumentException {
        this.session.save();
    }

    public void readDocumentPart(DocumentPart dp) throws Exception {
        for (org.nuxeo.ecm.core.api.model.Property property : dp) {
            property.init((Serializable)this.getPropertyValue(property.getName()));
        }
    }

    @Override
    public Property getProperty(String name) throws DocumentException {
        return this.session.makeProperty(this.getNode(), name, (ComplexType)this.type, this.mixinTypes, this.readonly);
    }

    public void writeDocumentPart(DocumentPart dp) throws Exception {
        for (org.nuxeo.ecm.core.api.model.Property property : dp) {
            String name = property.getName();
            Serializable value = property.getValueForWrite();
            try {
                this.setPropertyValue(name, value);
            }
            catch (SQLDocumentVersion.VersionNotModifiableException e) {
                if (!name.startsWith("dc:")) {
                    throw e;
                }
                Object oldValue = this.getPropertyValue(name);
                if (SQLDocumentLive.same(value, oldValue) || value != null && oldValue != null && SQLDocumentLive.sameArray(value, oldValue)) continue;
                throw e;
            }
        }
        SQLDocumentLive.clearDirtyFlags((org.nuxeo.ecm.core.api.model.Property)dp);
    }

    protected static boolean same(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    protected static boolean sameArray(Object a, Object b) {
        Class<?> acls = a.getClass();
        Class<?> bcls = b.getClass();
        if (!acls.isArray() || !bcls.isArray() || Array.getLength(a) != Array.getLength(b)) {
            return false;
        }
        for (int i = 0; i < Array.getLength(a); ++i) {
            if (SQLDocumentLive.same(Array.get(a, i), Array.get(b, i))) continue;
            return false;
        }
        return true;
    }

    protected static void clearDirtyFlags(org.nuxeo.ecm.core.api.model.Property property) {
        if (property.isContainer()) {
            for (org.nuxeo.ecm.core.api.model.Property p : property) {
                SQLDocumentLive.clearDirtyFlags(p);
            }
        }
        property.clearDirtyFlags();
    }

    public <T extends Serializable> void setSystemProp(String name, T value) throws DocumentException {
        String propertyName = systemPropNameMap.get(name);
        if (propertyName == null) {
            throw new DocumentException("Unknown system property: " + name);
        }
        this.getProperty(propertyName).setValue(value);
    }

    public <T extends Serializable> T getSystemProp(String name, Class<T> type) throws DocumentException {
        String propertyName = systemPropNameMap.get(name);
        if (propertyName == null) {
            throw new DocumentException("Unknown system property: " + name);
        }
        Object value = this.getProperty(propertyName).getValue();
        if (value == null) {
            if (type == Boolean.class) {
                value = Boolean.FALSE;
            } else if (type == Long.class) {
                value = 0L;
            }
        }
        return (T)((Serializable)value);
    }

    public String getLifeCyclePolicy() throws LifeCycleException {
        try {
            return this.getString("ecm:lifeCyclePolicy");
        }
        catch (DocumentException e) {
            throw new LifeCycleException("Failed to get policy", (Throwable)e);
        }
    }

    public void setLifeCyclePolicy(String policy) throws LifeCycleException {
        try {
            this.setString("ecm:lifeCyclePolicy", policy);
        }
        catch (DocumentException e) {
            throw new LifeCycleException("Failed to set policy", (Throwable)e);
        }
    }

    public String getLifeCycleState() throws LifeCycleException {
        try {
            return this.getString("ecm:lifeCycleState");
        }
        catch (DocumentException e) {
            throw new LifeCycleException("Failed to get state", (Throwable)e);
        }
    }

    public void setCurrentLifeCycleState(String state) throws LifeCycleException {
        try {
            this.setString("ecm:lifeCycleState", state);
        }
        catch (DocumentException e) {
            throw new LifeCycleException("Failed to set state", (Throwable)e);
        }
    }

    public boolean followTransition(String transition) throws LifeCycleException {
        LifeCycleService service = NXCore.getLifeCycleService();
        if (service == null) {
            throw new LifeCycleException("LifeCycleService not available");
        }
        service.followTransition((Document)this, transition);
        return true;
    }

    public Collection<String> getAllowedStateTransitions() throws LifeCycleException {
        LifeCycleService service = NXCore.getLifeCycleService();
        if (service == null) {
            throw new LifeCycleException("LifeCycleService not available");
        }
        LifeCycle lifeCycle = service.getLifeCycleFor((Document)this);
        if (lifeCycle == null) {
            return Collections.emptyList();
        }
        return lifeCycle.getAllowedStateTransitionsFrom(this.getLifeCycleState());
    }

    public Lock getLock() throws DocumentException {
        return this.session.getLock(this.getNode());
    }

    public Lock setLock(Lock lock) throws DocumentException {
        return this.session.setLock(this.getNode(), lock);
    }

    public Lock removeLock(String owner) throws DocumentException {
        return this.session.removeLock(this.getNode(), owner);
    }

    public boolean isVersion() {
        return false;
    }

    public Document getBaseVersion() throws DocumentException {
        if (this.isCheckedOut()) {
            return null;
        }
        String id = this.getString("ecm:baseVersion");
        if (id == null) {
            return null;
        }
        return this.session.getDocumentByUUID(id);
    }

    public String getVersionSeriesId() throws DocumentException {
        return this.getUUID();
    }

    public Document getSourceDocument() throws DocumentException {
        return this;
    }

    public Document checkIn(String label, String checkinComment) throws DocumentException {
        return this.session.checkIn(this.getNode(), label, checkinComment);
    }

    public void checkOut() throws DocumentException {
        this.session.checkOut(this.getNode());
    }

    public boolean isCheckedOut() throws DocumentException {
        return !this.getBoolean("ecm:isCheckedIn");
    }

    public boolean isMajorVersion() throws DocumentException {
        return false;
    }

    public boolean isLatestVersion() throws DocumentException {
        return false;
    }

    public boolean isLatestMajorVersion() throws DocumentException {
        return false;
    }

    public boolean isVersionSeriesCheckedOut() throws DocumentException {
        return this.isCheckedOut();
    }

    public String getVersionLabel() throws DocumentException {
        return this.getString("ecm:versionLabel");
    }

    public String getCheckinComment() throws DocumentException {
        return this.getString("ecm:versionDescription");
    }

    public Document getWorkingCopy() throws DocumentException {
        return this;
    }

    public Calendar getVersionCreationDate() throws DocumentException {
        return (Calendar)this.getProperty("ecm:versionCreated").getValue();
    }

    public void restore(Document version) throws DocumentException {
        if (!version.isVersion()) {
            throw new DocumentException("Cannot restore a non-version: " + version);
        }
        this.session.restore(this.getNode(), ((SQLDocument)version).getNode());
    }

    public List<String> getVersionsIds() throws DocumentException {
        String versionSeriesId = this.getVersionSeriesId();
        List<Document> versions = this.session.getVersions((Serializable)((Object)versionSeriesId));
        ArrayList<String> ids = new ArrayList<String>(versions.size());
        for (Document version : versions) {
            ids.add(version.getUUID());
        }
        return ids;
    }

    public Document getVersion(String label) throws DocumentException {
        String versionSeriesId = this.getVersionSeriesId();
        return this.session.getVersionByLabel((Serializable)((Object)versionSeriesId), label);
    }

    public List<Document> getVersions() throws DocumentException {
        String versionSeriesId = this.getVersionSeriesId();
        return this.session.getVersions((Serializable)((Object)versionSeriesId));
    }

    public Document getLastVersion() throws DocumentException {
        String versionSeriesId = this.getVersionSeriesId();
        return this.session.getLastVersion((Serializable)((Object)versionSeriesId));
    }

    public boolean hasVersions() throws DocumentException {
        log.error((Object)"hasVersions unimplemented, returning false");
        return false;
    }

    public Document resolvePath(String path) throws DocumentException {
        if (path == null) {
            throw new IllegalArgumentException();
        }
        if (path.length() == 0) {
            return this;
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return this.session.resolvePath(this.getNode(), path);
    }

    public Document getChild(String name) throws DocumentException {
        return this.session.getChild(this.getNode(), name);
    }

    public Iterator<Document> getChildren() throws DocumentException {
        return this.getChildren(0);
    }

    public DocumentIterator getChildren(int start) throws DocumentException {
        if (!this.isFolder()) {
            return EmptyDocumentIterator.INSTANCE;
        }
        List<Document> children = this.session.getChildren(this.getNode());
        if (start < 0) {
            throw new IllegalArgumentException(String.valueOf(start));
        }
        if (start >= children.size()) {
            return EmptyDocumentIterator.INSTANCE;
        }
        return new SQLDocumentListIterator(children.subList(start, children.size()));
    }

    public List<String> getChildrenIds() throws DocumentException {
        if (!this.isFolder()) {
            return Collections.emptyList();
        }
        List<Document> children = this.session.getChildren(this.getNode());
        ArrayList<String> ids = new ArrayList<String>(children.size());
        for (Document child : children) {
            ids.add(child.getUUID());
        }
        return ids;
    }

    public boolean hasChild(String name) throws DocumentException {
        if (!this.isFolder()) {
            return false;
        }
        return this.session.hasChild(this.getNode(), name);
    }

    public boolean hasChildren() throws DocumentException {
        if (!this.isFolder()) {
            return false;
        }
        return this.session.hasChildren(this.getNode());
    }

    public Document addChild(String name, String typeName) throws DocumentException {
        if (!this.isFolder()) {
            throw new IllegalArgumentException("Not a folder");
        }
        return this.session.addChild(this.getNode(), name, null, typeName);
    }

    public void orderBefore(String src, String dest) throws DocumentException {
        SQLDocument destDoc;
        SQLDocument srcDoc = (SQLDocument)this.getChild(src);
        if (srcDoc == null) {
            throw new DocumentException("Document " + this + " has no child: " + src);
        }
        if (dest == null) {
            destDoc = null;
        } else {
            destDoc = (SQLDocument)this.getChild(dest);
            if (destDoc == null) {
                throw new DocumentException("Document " + this + " has no child: " + dest);
            }
        }
        this.session.orderBefore(this.getNode(), srcDoc.getNode(), destDoc == null ? null : destDoc.getNode());
    }

    public void removeChild(String name) throws DocumentException {
        if (!this.isFolder()) {
            return;
        }
        Document doc = this.getChild(name);
        doc.remove();
    }

    public Set<String> getAllFacets() {
        return this.getNode().getAllMixinTypes();
    }

    public String[] getFacets() {
        return this.getNode().getMixinTypes();
    }

    public boolean hasFacet(String facet) {
        return this.getNode().hasMixinType(facet);
    }

    public boolean addFacet(String facet) throws DocumentException {
        try {
            boolean added = this.getNode().addMixinType(facet);
            if (added) {
                this.mixinTypes.add(this.session.getTypeManager().getFacet(facet));
            }
            return added;
        }
        catch (IllegalArgumentException e) {
            throw new DocumentException((Throwable)e);
        }
    }

    public boolean removeFacet(String facet) throws DocumentException {
        boolean removed = this.getNode().removeMixinType(facet);
        if (removed) {
            Iterator<CompositeType> it = this.mixinTypes.iterator();
            while (it.hasNext()) {
                if (!it.next().getName().equals(facet)) continue;
                it.remove();
                break;
            }
        }
        return removed;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.getName() + ',' + this.getUUID() + ')';
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other.getClass() == this.getClass()) {
            return this.equals((SQLDocumentLive)other);
        }
        return false;
    }

    private boolean equals(SQLDocumentLive other) {
        return this.getNode().equals((Object)other.getNode());
    }

    public int hashCode() {
        return this.getNode().hashCode();
    }

    static {
        systemPropNameMap.put("binaryText", "ecm:binaryText");
        systemPropNameMap.put("fulltextJobId", "ecm:fulltextJobId");
    }
}

