/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc.dialect;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.SocketException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Array;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.Binary;
import org.nuxeo.ecm.core.storage.sql.BinaryManager;
import org.nuxeo.ecm.core.storage.sql.ColumnType;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.jdbc.QueryMaker;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Database;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Join;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Table;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.DialectDerby;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.DialectH2;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.DialectHSQLDB;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.DialectMySQL;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.DialectOracle;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.DialectPostgreSQL;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.DialectSQLServer;
import org.nuxeo.runtime.api.Framework;

public abstract class Dialect {
    public static final String DIALECT_CLASS = "nuxeo.vcs.dialect";
    public static final Map<String, Class<? extends Dialect>> DIALECTS = new HashMap<String, Class<? extends Dialect>>();
    protected final BinaryManager binaryManager;
    protected final boolean storesUpperCaseIdentifiers;
    protected final boolean fulltextDisabled;
    protected final boolean aclOptimizationsEnabled;
    protected final int readAclMaxSize;
    public static final String ARRAY_SEP = "|";
    protected static final char[] HEX_DIGITS;

    public static JDBCInfo jdbcInfo(String string, int jdbcType) {
        return new JDBCInfo(string, jdbcType);
    }

    public static JDBCInfo jdbcInfo(String string, int length, int jdbcType) {
        return new JDBCInfo(String.format(string, length), jdbcType);
    }

    public static Dialect createDialect(Connection connection, BinaryManager binaryManager, RepositoryDescriptor repositoryDescriptor) throws StorageException {
        Dialect dialect;
        Constructor<? extends Dialect> ctor;
        Class<Dialect> dialectClass;
        String databaseName;
        DatabaseMetaData metadata;
        try {
            metadata = connection.getMetaData();
            databaseName = metadata.getDatabaseProductName();
        }
        catch (SQLException e) {
            throw new StorageException(e);
        }
        String dialectClassName = Framework.getProperty((String)DIALECT_CLASS);
        if (dialectClassName == null) {
            dialectClassName = Framework.getProperty((String)("nuxeo.vcs.dialect." + databaseName.replace(" ", "")));
        }
        if (dialectClassName == null) {
            dialectClass = DIALECTS.get(databaseName);
            if (dialectClass == null) {
                throw new StorageException("Unsupported database: " + databaseName);
            }
        } else {
            Class<?> klass;
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                klass = cl.loadClass(dialectClassName);
            }
            catch (ClassNotFoundException e) {
                throw new StorageException(e);
            }
            if (!Dialect.class.isAssignableFrom(klass)) {
                throw new StorageException("Not a Dialect: " + dialectClassName);
            }
            dialectClass = klass;
        }
        try {
            ctor = dialectClass.getConstructor(DatabaseMetaData.class, BinaryManager.class, RepositoryDescriptor.class);
        }
        catch (Exception e) {
            throw new StorageException("Bad constructor signature for: " + dialectClassName, e);
        }
        try {
            dialect = ctor.newInstance(metadata, binaryManager, repositoryDescriptor);
        }
        catch (Exception e) {
            throw new StorageException("Cannot construct dialect: " + dialectClassName, e);
        }
        return dialect;
    }

    public Dialect(DatabaseMetaData metadata, BinaryManager binaryManager, RepositoryDescriptor repositoryDescriptor) throws StorageException {
        try {
            this.storesUpperCaseIdentifiers = metadata.storesUpperCaseIdentifiers();
        }
        catch (SQLException e) {
            throw new StorageException("An error has occured.", e);
        }
        this.binaryManager = binaryManager;
        if (repositoryDescriptor == null) {
            this.fulltextDisabled = true;
            this.aclOptimizationsEnabled = false;
            this.readAclMaxSize = 0;
        } else {
            this.fulltextDisabled = repositoryDescriptor.fulltextDisabled;
            this.aclOptimizationsEnabled = repositoryDescriptor.aclOptimizationsEnabled;
            this.readAclMaxSize = repositoryDescriptor.readAclMaxSize;
        }
    }

    public BinaryManager getBinaryManager() {
        return this.binaryManager;
    }

    public String getConnectionSchema(Connection connection) throws SQLException {
        return null;
    }

    public abstract JDBCInfo getJDBCTypeAndString(ColumnType var1);

    public boolean isAllowedConversion(int expected, int actual, String actualName, int actualSize) {
        return false;
    }

    public abstract void setToPreparedStatement(PreparedStatement var1, int var2, Serializable var3, Column var4) throws SQLException;

    protected void setToPreparedStatementString(PreparedStatement ps, int index, Serializable value, Column column) throws SQLException {
        String v;
        ColumnType type = column.getType();
        if (type == ColumnType.BLOBID) {
            v = ((Binary)value).getDigest();
        } else if (type == ColumnType.SYSNAMEARRAY) {
            String[] strings = (String[])value;
            if (strings == null) {
                v = null;
            } else {
                StringBuilder buf = new StringBuilder(ARRAY_SEP);
                for (String string : strings) {
                    buf.append(string);
                    buf.append(ARRAY_SEP);
                }
                v = buf.toString();
            }
        } else {
            v = (String)((Object)value);
        }
        ps.setString(index, v);
    }

    protected void setToPreparedStatementTimestamp(PreparedStatement ps, int index, Serializable value, Column column) throws SQLException {
        Calendar cal = (Calendar)value;
        Timestamp ts = new Timestamp(cal.getTimeInMillis());
        ps.setTimestamp(index, ts, cal);
    }

    public abstract Serializable getFromResultSet(ResultSet var1, int var2, Column var3) throws SQLException;

    protected Serializable getFromResultSetString(ResultSet rs, int index, Column column) throws SQLException {
        String string = rs.getString(index);
        if (string == null) {
            return null;
        }
        ColumnType type = column.getType();
        if (type == ColumnType.BLOBID) {
            return this.getBinaryManager().getBinary(string);
        }
        if (type == ColumnType.SYSNAMEARRAY) {
            if (string.startsWith(ARRAY_SEP)) {
                string = string.substring(ARRAY_SEP.length());
            }
            return string.split(Pattern.quote(ARRAY_SEP));
        }
        return string;
    }

    protected Serializable getFromResultSetTimestamp(ResultSet rs, int index, Column column) throws SQLException {
        Timestamp ts = rs.getTimestamp(index);
        if (ts == null) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar();
        ((Calendar)cal).setTimeInMillis(ts.getTime());
        return cal;
    }

    public boolean storesUpperCaseIdentifiers() {
        return this.storesUpperCaseIdentifiers;
    }

    public char openQuote() {
        return '\"';
    }

    public char closeQuote() {
        return '\"';
    }

    public String toBooleanValueString(boolean bool) {
        return bool ? "1" : "0";
    }

    protected int getMaxNameSize() {
        return 999;
    }

    protected int getMaxIndexNameSize() {
        return this.getMaxNameSize();
    }

    protected String makeName(String name, int maxNameSize) {
        if (name.length() > maxNameSize) {
            MessageDigest digest;
            try {
                digest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e.toString(), e);
            }
            byte[] bytes = name.getBytes();
            digest.update(bytes, 0, bytes.length);
            name = name.substring(0, maxNameSize - 1 - 8);
            name = name + '_' + Dialect.toHexString(digest.digest()).substring(0, 8);
        }
        name = this.storesUpperCaseIdentifiers() ? name.toUpperCase() : name.toLowerCase();
        name = name.replace(':', '_');
        return name;
    }

    protected String makeName(String prefix, String string, String suffix, int maxNameSize) {
        String name = prefix + string + suffix;
        if (name.length() > maxNameSize) {
            MessageDigest digest;
            try {
                digest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e.toString(), e);
            }
            byte[] bytes = (prefix + string).getBytes();
            digest.update(bytes, 0, bytes.length);
            name = prefix.substring(0, 4);
            name = name + '_' + Dialect.toHexString(digest.digest()).substring(0, 8);
            name = name + suffix;
        }
        name = this.storesUpperCaseIdentifiers() ? name.toUpperCase() : name.toLowerCase();
        name = name.replace(':', '_');
        return name;
    }

    public static String toHexString(byte[] bytes) {
        StringBuilder buf = new StringBuilder(2 * bytes.length);
        for (byte b : bytes) {
            buf.append(HEX_DIGITS[(0xF0 & b) >> 4]);
            buf.append(HEX_DIGITS[0xF & b]);
        }
        return buf.toString();
    }

    public String getTableName(String name) {
        return this.makeName(name, this.getMaxNameSize());
    }

    public String getColumnName(String name) {
        return this.makeName(name, this.getMaxNameSize());
    }

    public String getPrimaryKeyConstraintName(String tableName) {
        return this.makeName(tableName, "", "_PK", this.getMaxNameSize());
    }

    public String getForeignKeyConstraintName(String tableName, String foreignColumnName, String foreignTableName) {
        return this.makeName(tableName + '_', foreignColumnName + '_' + foreignTableName, "_FK", this.getMaxNameSize());
    }

    public String getIndexName(String tableName, List<String> columnNames) {
        return this.makeName(this.qualifyIndexName() ? tableName + '_' : "", StringUtils.join(columnNames, (char)'_'), "_IDX", this.getMaxIndexNameSize());
    }

    public String getCreateIndexSql(String indexName, String tableName, List<String> columnNames) {
        return String.format("CREATE INDEX %s ON %s (%s)", indexName, tableName, StringUtils.join(columnNames, (String)", "));
    }

    public abstract int getFulltextIndexedColumns();

    public boolean supportsMultipleFulltextIndexes() {
        return true;
    }

    public abstract boolean getMaterializeFulltextSyntheticColumn();

    public abstract String getCreateFulltextIndexSql(String var1, String var2, Table var3, List<Column> var4, Model var5);

    public FulltextQuery analyzeFulltextQuery(String query) {
        return new FulltextQueryAnalyzer().analyze(query);
    }

    public static String translateFulltext(FulltextQuery ft, String or, String and, String andNot, String phraseQuote) {
        StringBuilder buf = new StringBuilder();
        FulltextQueryAnalyzer.translate(ft, buf, or, and, andNot, "", "", Collections.<Character>emptySet(), phraseQuote, phraseQuote, false);
        return buf.toString();
    }

    public static String translateFulltext(FulltextQuery ft, String or, String and, String andNot, String wordStart, String wordEnd, Set<Character> wordCharsReserved, String phraseStart, String phraseEnd, boolean quotePhraseWords) {
        StringBuilder buf = new StringBuilder();
        FulltextQueryAnalyzer.translate(ft, buf, or, and, andNot, wordStart, wordEnd, wordCharsReserved, phraseStart, phraseEnd, quotePhraseWords);
        return buf.toString();
    }

    public static boolean fulltextHasPhrase(FulltextQuery ft) {
        return FulltextQueryAnalyzer.hasPhrase(ft);
    }

    public abstract String getDialectFulltextQuery(String var1);

    public abstract FulltextMatchInfo getFulltextScoredMatchInfo(String var1, String var2, int var3, Column var4, Model var5, Database var6);

    public String getMatchMixinType(Column mixinsColumn, String mixin, boolean positive, String[] returnParam) {
        returnParam[0] = "%|" + mixin + ARRAY_SEP + "%";
        return String.format("%s %s ?", mixinsColumn.getFullQuotedName(), positive ? "LIKE" : "NOT LIKE");
    }

    public boolean supportsPaging() {
        return false;
    }

    public String getPagingClause(long limit, long offset) {
        throw new UnsupportedOperationException("paging is not supported");
    }

    public int getFulltextType() {
        return 2005;
    }

    public String getFreeVariableSetterForType(ColumnType type) {
        return "?";
    }

    public String getNoColumnsInsertString() {
        return "VALUES ( )";
    }

    public String getNullColumnString() {
        return "";
    }

    public String getTableTypeString(Table table) {
        return "";
    }

    public String getAddPrimaryKeyConstraintString(String constraintName) {
        return String.format(" ADD CONSTRAINT %s PRIMARY KEY ", constraintName);
    }

    public String getAddForeignKeyConstraintString(String constraintName, String[] foreignKeys, String referencedTable, String[] primaryKeys, boolean referencesPrimaryKey) {
        String sql = String.format(" ADD CONSTRAINT %s FOREIGN KEY (%s) REFERENCES %s", constraintName, StringUtils.join((Object[])foreignKeys, (String)", "), referencedTable);
        if (!referencesPrimaryKey) {
            sql = sql + " (" + StringUtils.join((Object[])primaryKeys, (String)", ") + ')';
        }
        return sql;
    }

    public boolean qualifyIndexName() {
        return true;
    }

    public boolean supportsIfExistsBeforeTableName() {
        return false;
    }

    public boolean supportsIfExistsAfterTableName() {
        return false;
    }

    public String getCascadeDropConstraintsString() {
        return "";
    }

    public boolean supportsCircularCascadeDeleteConstraints() {
        return true;
    }

    public String getAddColumnString() {
        return "ADD COLUMN";
    }

    public abstract boolean supportsUpdateFrom();

    public abstract boolean doesUpdateFromRepeatSelf();

    public boolean needsOrderByKeysAfterDistinct() {
        return true;
    }

    public boolean needsAliasForDerivedTable() {
        return false;
    }

    public boolean needsOriginalColumnInGroupBy() {
        return false;
    }

    public boolean needsOracleJoins() {
        return false;
    }

    public boolean needsPrepareUserReadAcls() {
        return false;
    }

    public String getClobCast(boolean inOrderBy) {
        return null;
    }

    public String getDateCast() {
        return "CAST(%s AS DATE)";
    }

    public abstract String getSecurityCheckSql(String var1);

    public boolean supportsAncestorsTable() {
        return false;
    }

    public abstract String getInTreeSql(String var1);

    public boolean supportsArrays() {
        return false;
    }

    public boolean supportsArraysReturnInsteadOfRows() {
        return false;
    }

    public boolean supportsSysNameArray() {
        return false;
    }

    public Array createArrayOf(int type, Object[] elements, Connection connection) throws SQLException {
        throw new SQLException("Not supported");
    }

    public abstract String getSQLStatementsFilename();

    public abstract String getTestSQLStatementsFilename();

    public abstract Map<String, Serializable> getSQLStatementsProperties(Model var1, Database var2);

    public boolean isClusteringSupported() {
        return false;
    }

    public boolean isClusteringDeleteNeeded() {
        return false;
    }

    public String getClusterInsertInvalidations() {
        return null;
    }

    public String getClusterGetInvalidations() {
        return null;
    }

    public String getClusterDeleteInvalidations() {
        return null;
    }

    public boolean supportsIlike() {
        return false;
    }

    public boolean supportsReadAcl() {
        return false;
    }

    public boolean supportsWith() {
        return false;
    }

    public boolean hasNullEmptyString() {
        return false;
    }

    public int getMaximumArgsForIn() {
        return 400;
    }

    public String getUpdateReadAclsSql() {
        return null;
    }

    public String getRebuildReadAclsSql() {
        return null;
    }

    public String getReadAclsCheckSql(String idColumnName) {
        return null;
    }

    public String getPrepareUserReadAclsSql() {
        return null;
    }

    public boolean preCreateTable(Connection connection, Table table, Model model, Database database) throws SQLException {
        return true;
    }

    public List<String> getPostCreateTableSqls(Table table, Model model, Database database) {
        return Collections.emptyList();
    }

    public void existingTableDetected(Connection connection, Table table, Model model, Database database) throws SQLException {
    }

    public boolean isConnectionClosedException(Throwable t) {
        while (t.getCause() != null) {
            t = t.getCause();
        }
        return t instanceof SocketException;
    }

    public void performAdditionalStatements(Connection connection) throws SQLException {
    }

    public String getValidationQuery() {
        return "SELECT 1";
    }

    public String getBlobLengthFunction() {
        return "OCTET_LENGTH";
    }

    public void performPostOpenStatements(Connection connection) throws SQLException {
    }

    public List<String> getPostCreateIdentityColumnSql(Column column) {
        return Collections.emptyList();
    }

    public boolean isIdentityAlreadyPrimary() {
        return false;
    }

    public boolean hasIdentityGeneratedKey() {
        return true;
    }

    public String getIdentityGeneratedKeySql(Column column) {
        return null;
    }

    public String getAncestorsIdsSql() {
        return null;
    }

    public String getDescending() {
        return " DESC";
    }

    static {
        DIALECTS.put("H2", DialectH2.class);
        DIALECTS.put("MySQL", DialectMySQL.class);
        DIALECTS.put("Oracle", DialectOracle.class);
        DIALECTS.put("PostgreSQL", DialectPostgreSQL.class);
        DIALECTS.put("Microsoft SQL Server", DialectSQLServer.class);
        DIALECTS.put("HSQL Database Engine", DialectHSQLDB.class);
        DIALECTS.put("Apache Derby", DialectDerby.class);
        HEX_DIGITS = "0123456789ABCDEF".toCharArray();
    }

    public static class FulltextMatchInfo {
        public List<Join> joins;
        public String whereExpr;
        public String whereExprParam;
        public String scoreExpr;
        public String scoreExprParam;
        public String scoreAlias;
        public Column scoreCol;
    }

    public static class FulltextQueryAnalyzer {
        public static final String PLUS = "+";
        public static final String MINUS = "-";
        public static final char CSPACE = ' ';
        public static final String DOUBLE_QUOTES = "\"";
        public static final String OR = "OR";
        public FulltextQuery ft = new FulltextQuery();
        public List<FulltextQuery> terms = new LinkedList<FulltextQuery>();
        protected static final Pattern SEPARATOR = Pattern.compile("[ ]");
        protected static final Pattern IGNORED = Pattern.compile("\\p{Punct}+");

        public FulltextQuery analyze(String query) {
            if ((query = query.replaceAll(" +", " ").trim()).trim().length() == 0) {
                return null;
            }
            this.ft.op = FulltextQuery.Op.OR;
            this.ft.terms = new LinkedList<FulltextQuery>();
            boolean wasOr = false;
            String[] words = this.split(query);
            Iterator<String> it = Arrays.asList(words).iterator();
            while (it.hasNext()) {
                boolean plus = false;
                boolean minus = false;
                String word = it.next();
                if (this.ignored(word)) continue;
                if (word.startsWith(PLUS)) {
                    plus = true;
                    word = word.substring(1);
                } else if (word.startsWith(MINUS)) {
                    minus = true;
                    word = word.substring(1);
                }
                if (word.startsWith(DOUBLE_QUOTES)) {
                    word = word.substring(1);
                    StringBuilder phrase = null;
                    while (true) {
                        boolean end;
                        if (end = word.endsWith(DOUBLE_QUOTES)) {
                            word = word.substring(0, word.length() - 1).trim();
                        }
                        if (word.contains(DOUBLE_QUOTES)) {
                            throw new QueryMaker.QueryMakerException("Invalid fulltext query (double quotes in word): " + query);
                        }
                        if (word.length() != 0) {
                            if (phrase == null) {
                                phrase = new StringBuilder();
                            } else {
                                phrase.append(' ');
                            }
                            phrase.append(word);
                        }
                        if (end) break;
                        if (!it.hasNext()) {
                            throw new QueryMaker.QueryMakerException("Invalid fulltext query (unterminated phrase): " + query);
                        }
                        word = it.next();
                    }
                    if (phrase == null) continue;
                    word = phrase.toString();
                } else if (word.equalsIgnoreCase(OR)) {
                    if (wasOr) {
                        throw new QueryMaker.QueryMakerException("Invalid fulltext query (OR OR): " + query);
                    }
                    if (this.terms.isEmpty()) {
                        throw new QueryMaker.QueryMakerException("Invalid fulltext query (standalone OR): " + query);
                    }
                    wasOr = true;
                    continue;
                }
                FulltextQuery w = new FulltextQuery();
                if (minus) {
                    if (word.length() == 0) {
                        throw new QueryMaker.QueryMakerException("Invalid fulltext query (standalone -): " + query);
                    }
                    w.op = FulltextQuery.Op.NOTWORD;
                } else {
                    if (plus && word.length() == 0) {
                        throw new QueryMaker.QueryMakerException("Invalid fulltext query (standalone +): " + query);
                    }
                    w.op = FulltextQuery.Op.WORD;
                }
                if (wasOr) {
                    this.endAnd();
                    wasOr = false;
                }
                w.word = word;
                this.terms.add(w);
            }
            if (wasOr) {
                throw new QueryMaker.QueryMakerException("Invalid fulltext query (final OR): " + query);
            }
            this.endAnd();
            int size = this.ft.terms.size();
            if (size == 0) {
                return null;
            }
            if (size == 1) {
                this.ft = this.ft.terms.get(0);
            }
            return this.ft;
        }

        protected String[] split(String query) {
            return SEPARATOR.split(query);
        }

        protected boolean ignored(String word) {
            if (MINUS.equals(word) || PLUS.equals(word) || word.contains(DOUBLE_QUOTES)) {
                return false;
            }
            return IGNORED.matcher(word).matches();
        }

        protected void endAnd() {
            LinkedList<FulltextQuery> pos = new LinkedList<FulltextQuery>();
            LinkedList<FulltextQuery> neg = new LinkedList<FulltextQuery>();
            for (FulltextQuery term : this.terms) {
                if (term.op == FulltextQuery.Op.NOTWORD) {
                    neg.add(term);
                    continue;
                }
                pos.add(term);
            }
            if (!pos.isEmpty()) {
                this.terms = pos;
                this.terms.addAll(neg);
                if (this.terms.size() == 1) {
                    this.ft.terms.add(this.terms.get(0));
                } else {
                    FulltextQuery a = new FulltextQuery();
                    a.op = FulltextQuery.Op.AND;
                    a.terms = this.terms;
                    this.ft.terms.add(a);
                }
            }
            this.terms = new LinkedList<FulltextQuery>();
        }

        public static void translate(FulltextQuery ft, StringBuilder buf, String or, String and, String andNot, String wordStart, String wordEnd, Set<Character> wordCharsReserved, String phraseStart, String phraseEnd, boolean quotePhraseWords) {
            if (ft.op == FulltextQuery.Op.AND || ft.op == FulltextQuery.Op.OR) {
                buf.append('(');
                for (int i = 0; i < ft.terms.size(); ++i) {
                    FulltextQuery term = ft.terms.get(i);
                    if (i > 0) {
                        buf.append(' ');
                        if (ft.op == FulltextQuery.Op.OR) {
                            buf.append(or);
                        } else if (term.op == FulltextQuery.Op.NOTWORD) {
                            buf.append(andNot);
                        } else {
                            buf.append(and);
                        }
                        buf.append(' ');
                    }
                    FulltextQueryAnalyzer.translate(term, buf, or, and, andNot, wordStart, wordEnd, wordCharsReserved, phraseStart, phraseEnd, quotePhraseWords);
                }
                buf.append(')');
                return;
            }
            String word = ft.word.toLowerCase();
            if (ft.isPhrase()) {
                if (quotePhraseWords) {
                    boolean first = true;
                    for (String w : word.split(" ")) {
                        if (!first) {
                            buf.append(" ");
                        }
                        first = false;
                        FulltextQueryAnalyzer.appendWord(w, buf, wordStart, wordEnd, wordCharsReserved);
                    }
                } else {
                    buf.append(phraseStart);
                    buf.append(word);
                    buf.append(phraseEnd);
                }
            } else {
                FulltextQueryAnalyzer.appendWord(word, buf, wordStart, wordEnd, wordCharsReserved);
            }
        }

        protected static void appendWord(String word, StringBuilder buf, String start, String end, Set<Character> reserved) {
            boolean quote = true;
            if (!reserved.isEmpty()) {
                for (char c : word.toCharArray()) {
                    if (!reserved.contains(Character.valueOf(c))) continue;
                    quote = false;
                    break;
                }
            }
            if (quote) {
                buf.append(start);
            }
            buf.append(word);
            if (quote) {
                buf.append(end);
            }
        }

        public static boolean hasPhrase(FulltextQuery ft) {
            if (ft.op == FulltextQuery.Op.AND || ft.op == FulltextQuery.Op.OR) {
                for (FulltextQuery term : ft.terms) {
                    if (!FulltextQueryAnalyzer.hasPhrase(term)) continue;
                    return true;
                }
                return false;
            }
            return ft.isPhrase();
        }
    }

    public static class FulltextQuery {
        public static final String SPACE = " ";
        public Op op;
        public List<FulltextQuery> terms;
        public String word;

        public boolean isPhrase() {
            return this.word != null && this.word.contains(SPACE);
        }

        public static enum Op {
            OR,
            AND,
            WORD,
            NOTWORD;

        }
    }

    public static final class JDBCInfo {
        public final String string;
        public final int jdbcType;

        public JDBCInfo(String string, int jdbcType) {
            this.string = string;
            this.jdbcType = jdbcType;
        }
    }
}

