/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.core.registries;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutDefinition;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public class LayoutDefinitionRegistry
extends ContributionFragmentRegistry<LayoutDefinition> {
    protected final String category;
    protected final Map<String, LayoutDefinition> layoutDefs;

    public LayoutDefinitionRegistry(String category) {
        this.category = category;
        this.layoutDefs = new HashMap<String, LayoutDefinition>();
    }

    public String getCategory() {
        return this.category;
    }

    public List<String> getLayoutNames() {
        ArrayList<String> res = new ArrayList<String>();
        res.addAll(this.layoutDefs.keySet());
        return res;
    }

    public String getContributionId(LayoutDefinition contrib) {
        return contrib.getName();
    }

    public void contributionUpdated(String id, LayoutDefinition contrib, LayoutDefinition newOrigContrib) {
        this.layoutDefs.put(id, contrib);
    }

    public void contributionRemoved(String id, LayoutDefinition origContrib) {
        this.layoutDefs.remove(id);
    }

    public boolean isSupportingMerge() {
        return false;
    }

    public LayoutDefinition clone(LayoutDefinition orig) {
        throw new UnsupportedOperationException();
    }

    public void merge(LayoutDefinition src, LayoutDefinition dst) {
        throw new UnsupportedOperationException();
    }

    public LayoutDefinition getLayoutDefinition(String id) {
        return this.layoutDefs.get(id);
    }
}

