/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.descriptors;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutRowDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.RenderingInfo;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.impl.LayoutDefinitionImpl;
import org.nuxeo.ecm.platform.forms.layout.descriptors.LayoutRowDescriptor;
import org.nuxeo.ecm.platform.forms.layout.descriptors.PropertiesDescriptor;
import org.nuxeo.ecm.platform.forms.layout.descriptors.RenderingInfoDescriptor;
import org.nuxeo.ecm.platform.forms.layout.descriptors.RenderingInfosDescriptor;
import org.nuxeo.ecm.platform.forms.layout.descriptors.WidgetDescriptor;

@XObject(value="layout")
public class LayoutDescriptor {
    @XNode(value="@name")
    String name;
    @XNodeMap(value="templates/template", key="@mode", type=HashMap.class, componentType=String.class)
    Map<String, String> templates = new HashMap<String, String>();
    @XNodeList(value="rows/row", type=LayoutRowDescriptor[].class, componentType=LayoutRowDescriptor.class)
    LayoutRowDescriptor[] rows = new LayoutRowDescriptor[0];
    @XNodeList(value="columns/column", type=LayoutRowDescriptor[].class, componentType=LayoutRowDescriptor.class)
    LayoutRowDescriptor[] rowsAsColumns = new LayoutRowDescriptor[0];
    @XNodeMap(value="widget", key="@name", type=HashMap.class, componentType=WidgetDescriptor.class)
    Map<String, WidgetDescriptor> widgets = new HashMap<String, WidgetDescriptor>();
    @XNodeMap(value="properties", key="@mode", type=HashMap.class, componentType=PropertiesDescriptor.class)
    Map<String, PropertiesDescriptor> properties = new HashMap<String, PropertiesDescriptor>();
    @XNodeMap(value="renderingInfos", key="@mode", type=HashMap.class, componentType=RenderingInfosDescriptor.class)
    Map<String, RenderingInfosDescriptor> renderingInfos = new HashMap<String, RenderingInfosDescriptor>();
    @XNodeList(value="categories/category", type=String[].class, componentType=String.class)
    String[] categories = new String[0];
    Integer columns;

    public String getName() {
        return this.name;
    }

    public String getTemplate(String mode) {
        String template = this.templates.get(mode);
        if (template == null) {
            template = this.templates.get("any");
        }
        return template;
    }

    public Map<String, String> getTemplates() {
        return this.templates;
    }

    protected LayoutRowDefinition[] getDefinitions(LayoutRowDescriptor[] rows) {
        LayoutRowDefinition[] crows = null;
        if (rows != null) {
            crows = new LayoutRowDefinition[rows.length];
            for (int i = 0; i < rows.length; ++i) {
                crows[i] = rows[i].getLayoutRowDefinition();
            }
        }
        return crows;
    }

    public LayoutRowDefinition[] getRows() {
        if (this.rowsAsColumns != null && this.rowsAsColumns.length > 0) {
            return this.getDefinitions(this.rowsAsColumns);
        }
        return this.getDefinitions(this.rows);
    }

    public int getColumns() {
        if (this.columns == null) {
            LayoutRowDefinition[] rows;
            this.columns = 0;
            for (LayoutRowDefinition def : rows = this.getRows()) {
                int current = def.getWidgetReferences().length;
                if (current <= this.columns) continue;
                this.columns = current;
            }
        }
        return this.columns;
    }

    protected WidgetDefinition getWidgetDefinition(WidgetDescriptor desc) {
        if (desc == null) {
            return null;
        }
        return desc.getWidgetDefinition();
    }

    public WidgetDefinition getWidgetDefinition(String name) {
        return this.getWidgetDefinition(this.widgets.get(name));
    }

    public Map<String, Serializable> getProperties(String layoutMode) {
        return WidgetDescriptor.getProperties(this.properties, layoutMode);
    }

    public Map<String, Map<String, Serializable>> getProperties() {
        return WidgetDescriptor.getProperties(this.properties);
    }

    public String[] getCategories() {
        return this.categories;
    }

    public LayoutDefinition getLayoutDefinition() {
        HashMap<String, String> ctemplates = null;
        if (this.templates != null) {
            ctemplates = new HashMap<String, String>();
            ctemplates.putAll(this.templates);
        }
        LayoutRowDefinition[] crows = this.getRows();
        HashMap<String, WidgetDefinition> cwidgets = null;
        if (this.widgets != null) {
            cwidgets = new HashMap<String, WidgetDefinition>();
            for (Map.Entry<String, WidgetDescriptor> entry : this.widgets.entrySet()) {
                WidgetDescriptor w = entry.getValue();
                cwidgets.put(entry.getKey(), this.getWidgetDefinition(w));
            }
        }
        HashMap crenderingInfos = null;
        if (this.renderingInfos != null) {
            crenderingInfos = new HashMap();
            for (Map.Entry<String, RenderingInfosDescriptor> item : this.renderingInfos.entrySet()) {
                RenderingInfosDescriptor infos = item.getValue();
                ArrayList<RenderingInfo> clonedInfos = null;
                if (infos != null) {
                    clonedInfos = new ArrayList<RenderingInfo>();
                    for (RenderingInfoDescriptor info : infos.getRenderingInfos()) {
                        clonedInfos.add(info.getRenderingInfo());
                    }
                }
                crenderingInfos.put(item.getKey(), clonedInfos);
            }
        }
        LayoutDefinitionImpl clone = new LayoutDefinitionImpl(this.name, this.getProperties(), ctemplates, crows, cwidgets);
        clone.setRenderingInfos(crenderingInfos);
        return clone;
    }
}

