/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;

public class SystemPrincipal
implements NuxeoPrincipal {
    private static final long serialVersionUID = -3381784063138281706L;
    private static final char[] SYS_PASSWORD = null;
    private static final List<String> SYS_GROUPS = Collections.unmodifiableList(Arrays.asList("administrators"));
    private static final List<String> SYS_ROLES = Collections.unmodifiableList(new ArrayList());
    private String origUserName;
    private int hash;

    public SystemPrincipal(String origUserName) {
        this.origUserName = origUserName == null ? "system" : origUserName;
        this.computeHash();
    }

    private void computeHash() {
        this.hash = this.origUserName != null ? ("system-" + this.origUserName).hashCode() : "system".hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof SystemPrincipal) {
            if (!"system".equals(((Principal)other).getName())) {
                return false;
            }
            if (this.origUserName == null) {
                return ((SystemPrincipal)other).origUserName == null;
            }
            return this.origUserName.equals(((SystemPrincipal)other).origUserName);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.hash;
    }

    @Override
    public String getCompany() {
        return "Nuxeo";
    }

    @Override
    public String getEmail() {
        return null;
    }

    @Override
    public void setEmail(String email) {
    }

    @Override
    public String getFirstName() {
        return "System";
    }

    @Override
    public String getLastName() {
        return "System";
    }

    @Override
    public String getName() {
        return "system";
    }

    @Override
    public List<String> getGroups() {
        return SYS_GROUPS;
    }

    @Override
    public List<String> getAllGroups() {
        return SYS_GROUPS;
    }

    @Override
    public List<String> getRoles() {
        return SYS_ROLES;
    }

    @Override
    public String getPassword() {
        if (SYS_PASSWORD == null) {
            return null;
        }
        return new String(SYS_PASSWORD);
    }

    @Override
    public String getPrincipalId() {
        return "";
    }

    @Override
    public String getOriginatingUser() {
        return this.origUserName;
    }

    @Override
    public void setOriginatingUser(String originatingUser) {
        this.origUserName = originatingUser;
        this.computeHash();
    }

    @Override
    public DocumentModel getModel() {
        return null;
    }

    @Override
    public void setCompany(String company) {
    }

    @Override
    public void setFirstName(String firstName) {
    }

    @Override
    public void setLastName(String lastName) {
    }

    @Override
    public void setName(String userName) {
    }

    @Override
    public void setGroups(List<String> groups) {
    }

    @Override
    public void setRoles(List<String> roles) {
    }

    @Override
    public void setPassword(String password) {
    }

    @Override
    public void setPrincipalId(String principalId) {
    }

    @Override
    public void setModel(DocumentModel model) {
    }

    @Override
    public boolean isMemberOf(String group) {
        return SYS_GROUPS.contains(group);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public boolean isAdministrator() {
        return true;
    }

    @Override
    public boolean isManager() {
        return this.isAdministrator();
    }

    @Override
    public String getTenantId() {
        return null;
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }
}

