/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.comment.web;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.event.ActionEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.annotations.web.RequestParameter;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.actions.Action;
import org.nuxeo.ecm.platform.comment.api.CommentableDocument;
import org.nuxeo.ecm.platform.comment.web.CommentManagerActions;
import org.nuxeo.ecm.platform.comment.web.ThreadEntry;
import org.nuxeo.ecm.platform.comment.web.UIComment;
import org.nuxeo.ecm.platform.comment.workflow.utils.FollowTransitionUnrestricted;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.api.WebActions;
import org.nuxeo.ecm.webapp.security.UserSession;

public abstract class AbstractCommentManagerActionsBean
implements CommentManagerActions {
    protected static final String COMMENTS_ACTIONS = "COMMENT_ACTIONS";
    private static final Log log = LogFactory.getLog(AbstractCommentManagerActionsBean.class);
    protected NuxeoPrincipal principal;
    protected boolean principalIsAdmin;
    protected boolean showCreateForm;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient WebActions webActions;
    protected String newContent;
    protected CommentableDocument commentableDoc;
    protected List<UIComment> uiComments;
    protected List<ThreadEntry> commentThread;
    @RequestParameter
    protected String deleteCommentId;
    @RequestParameter
    protected String replyCommentId;
    protected String savedReplyCommentId;
    protected Map<String, UIComment> commentMap;
    protected boolean commentStarted;
    protected List<UIComment> flatComments;
    @In(create=true)
    protected UserSession userSession;
    @In(create=true)
    protected NavigationContext navigationContext;

    @Override
    @Create
    public void initialize() throws Exception {
        log.debug((Object)"Initializing...");
        this.commentMap = new HashMap<String, UIComment>();
        this.showCreateForm = false;
        this.principal = this.userSession.getCurrentNuxeoPrincipal();
        this.principalIsAdmin = this.principal.isAdministrator();
    }

    @Override
    @Destroy
    public void destroy() {
        this.commentMap = null;
        log.debug((Object)"Removing Seam action listener...");
    }

    @Override
    public String getPrincipalName() {
        return this.principal.getName();
    }

    @Override
    public boolean getPrincipalIsAdmin() {
        return this.principalIsAdmin;
    }

    protected DocumentModel initializeComment(DocumentModel comment) {
        if (comment != null) {
            try {
                if (comment.getProperty("dublincore", "contributors") == null) {
                    String[] contributors = new String[]{this.getPrincipalName()};
                    comment.setProperty("dublincore", "contributors", (Object)contributors);
                }
            }
            catch (ClientException e) {
                throw new ClientRuntimeException((Throwable)e);
            }
            try {
                if (comment.getProperty("dublincore", "created") == null) {
                    comment.setProperty("dublincore", "created", (Object)Calendar.getInstance());
                }
            }
            catch (ClientException e) {
                throw new ClientRuntimeException((Throwable)e);
            }
        }
        return comment;
    }

    public DocumentModel addComment(DocumentModel comment, DocumentModel docToComment) throws ClientException {
        try {
            comment = this.initializeComment(comment);
            UIComment parentComment = null;
            if (this.savedReplyCommentId != null) {
                parentComment = this.commentMap.get(this.savedReplyCommentId);
            }
            if (docToComment != null) {
                this.commentableDoc = this.getCommentableDoc(docToComment);
            }
            if (this.commentableDoc == null) {
                this.commentableDoc = this.getCommentableDoc();
            }
            if (this.commentableDoc == null) {
                throw new ClientException("Can't comment on null document");
            }
            DocumentModel newComment = parentComment != null ? this.commentableDoc.addComment(parentComment.getComment(), comment) : this.commentableDoc.addComment(comment);
            if ("comment_moderation".equals(newComment.getLifeCyclePolicy())) {
                new FollowTransitionUnrestricted(this.documentManager, newComment.getRef(), "moderation_publish").runUnrestricted();
            }
            this.cleanContextVariable();
            return newComment;
        }
        catch (Throwable t) {
            log.error((Object)"failed to add comment", t);
            throw ClientException.wrap((Throwable)t);
        }
    }

    @Override
    public DocumentModel addComment(DocumentModel comment) throws ClientException {
        return this.addComment(comment, null);
    }

    @Override
    public String addComment() throws ClientException {
        DocumentModel myComment = this.documentManager.createDocumentModel("Comment");
        myComment.setProperty("comment", "author", (Object)this.principal.getName());
        myComment.setProperty("comment", "text", (Object)this.newContent);
        myComment.setProperty("comment", "creationDate", (Object)Calendar.getInstance());
        myComment = this.addComment(myComment);
        return null;
    }

    @Override
    public String createComment(DocumentModel docToComment) throws ClientException {
        DocumentModel myComment = this.documentManager.createDocumentModel("Comment");
        myComment.setProperty("comment", "author", (Object)this.principal.getName());
        myComment.setProperty("comment", "text", (Object)this.newContent);
        myComment.setProperty("comment", "creationDate", (Object)Calendar.getInstance());
        myComment = this.addComment(myComment, docToComment);
        return null;
    }

    @Override
    @Observer(value={"documentSelectionChanged", "contentRootSelectionChanged", "documentChanged"}, create=false)
    @BypassInterceptors
    public void documentChanged() {
        this.cleanContextVariable();
    }

    protected CommentableDocument getCommentableDoc() {
        if (this.commentableDoc == null) {
            DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
            this.commentableDoc = (CommentableDocument)currentDocument.getAdapter(CommentableDocument.class);
        }
        return this.commentableDoc;
    }

    protected CommentableDocument getCommentableDoc(DocumentModel doc) {
        if (doc == null) {
            doc = this.navigationContext.getCurrentDocument();
        }
        this.commentableDoc = (CommentableDocument)doc.getAdapter(CommentableDocument.class);
        return this.commentableDoc;
    }

    @Override
    public void initComments() throws ClientException {
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        if (currentDoc == null) {
            throw new ClientException("Unable to find current Document");
        }
        this.initComments(currentDoc);
    }

    @Override
    public void initComments(DocumentModel commentedDoc) throws ClientException {
        this.commentableDoc = this.getCommentableDoc(commentedDoc);
        if (this.uiComments == null) {
            this.uiComments = new ArrayList<UIComment>();
            if (this.commentableDoc != null) {
                List comments = this.commentableDoc.getComments();
                for (DocumentModel comment : comments) {
                    UIComment uiComment = this.createUIComment(null, comment);
                    this.uiComments.add(uiComment);
                }
            }
        }
    }

    public List<UIComment> getComments(DocumentModel doc) throws ClientException {
        ArrayList<UIComment> allComments = new ArrayList<UIComment>();
        this.commentableDoc = (CommentableDocument)doc.getAdapter(CommentableDocument.class);
        if (this.commentableDoc != null) {
            List comments = this.commentableDoc.getComments();
            for (DocumentModel comment : comments) {
                UIComment uiComment = this.createUIComment(null, comment);
                allComments.add(uiComment);
            }
        }
        return allComments;
    }

    @Override
    public List<ThreadEntry> getCommentsAsThreadOnDoc(DocumentModel doc) throws ClientException {
        ArrayList<ThreadEntry> allComments = new ArrayList<ThreadEntry>();
        List<UIComment> allUIComments = this.getComments(doc);
        for (UIComment uiComment : allUIComments) {
            allComments.add(new ThreadEntry(uiComment.getComment(), 0));
            if (uiComment.getChildren() == null) continue;
            this.flattenTree(allComments, uiComment, 0);
        }
        return allComments;
    }

    @Override
    public List<ThreadEntry> getCommentsAsThread(DocumentModel commentedDoc) throws ClientException {
        if (this.commentThread != null) {
            return this.commentThread;
        }
        this.commentThread = new ArrayList<ThreadEntry>();
        if (this.uiComments == null) {
            this.initComments(commentedDoc);
        }
        for (UIComment uiComment : this.uiComments) {
            this.commentThread.add(new ThreadEntry(uiComment.getComment(), 0));
            if (uiComment.getChildren() == null) continue;
            this.flattenTree(this.commentThread, uiComment, 0);
        }
        return this.commentThread;
    }

    public void flattenTree(List<ThreadEntry> commentThread, UIComment uiComment, int depth) {
        List<UIComment> uiChildren = uiComment.getChildren();
        for (UIComment uiChild : uiChildren) {
            commentThread.add(new ThreadEntry(uiChild.getComment(), depth + 1));
            if (uiChild.getChildren() == null) continue;
            this.flattenTree(commentThread, uiChild, depth + 1);
        }
    }

    protected UIComment createUIComment(UIComment parent, DocumentModel comment) throws ClientException {
        UIComment wrapper = new UIComment(parent, comment);
        this.commentMap.put(wrapper.getId(), wrapper);
        List children = this.commentableDoc.getComments(comment);
        for (DocumentModel child : children) {
            UIComment uiChild = this.createUIComment(wrapper, child);
            wrapper.addChild(uiChild);
        }
        return wrapper;
    }

    @Override
    public String deleteComment(String commentId) throws ClientException {
        if ("".equals(commentId)) {
            log.error((Object)"No comment id to delete");
            return null;
        }
        if (this.commentableDoc == null) {
            log.error((Object)"Can't delete comments of null document");
            return null;
        }
        try {
            UIComment selectedComment = this.commentMap.get(commentId);
            this.commentableDoc.removeComment(selectedComment.getComment());
            this.cleanContextVariable();
            return null;
        }
        catch (Throwable t) {
            log.error((Object)"failed to delete comment", t);
            throw ClientException.wrap((Throwable)t);
        }
    }

    @Override
    public String deleteComment() throws ClientException {
        return this.deleteComment(this.deleteCommentId);
    }

    @Override
    public String getNewContent() {
        return this.newContent;
    }

    @Override
    public void setNewContent(String newContent) {
        this.newContent = newContent;
    }

    @Override
    public String beginComment() {
        this.commentStarted = true;
        this.savedReplyCommentId = this.replyCommentId;
        this.showCreateForm = false;
        return null;
    }

    @Override
    public String cancelComment() {
        this.cleanContextVariable();
        return null;
    }

    @Override
    public boolean getCommentStarted() {
        return this.commentStarted;
    }

    public void getChildren(UIComment comment) {
        assert (comment != null);
        List<UIComment> children = comment.getChildren();
        if (!children.isEmpty()) {
            for (UIComment childComment : children) {
                this.getChildren(childComment);
            }
        }
        this.flatComments.add(comment);
    }

    @Override
    public List<UIComment> getLastCommentsByDate(String commentNumber, DocumentModel commentedDoc) throws ClientException {
        int number = Integer.parseInt(commentNumber);
        ArrayList<UIComment> comments = new ArrayList<UIComment>();
        this.flatComments = new ArrayList<UIComment>();
        this.initComments(commentedDoc);
        if (number < 0 || this.uiComments.isEmpty()) {
            return null;
        }
        for (UIComment comment : this.uiComments) {
            this.getChildren(comment);
        }
        if (!this.flatComments.isEmpty()) {
            Collections.sort(this.flatComments);
        }
        if (number > this.flatComments.size()) {
            number = this.flatComments.size();
        }
        for (int i = 0; i < number; ++i) {
            comments.add(this.flatComments.get(this.flatComments.size() - 1 - i));
        }
        return comments;
    }

    @Override
    public List<UIComment> getLastCommentsByDate(String commentNumber) throws ClientException {
        return this.getLastCommentsByDate(commentNumber, null);
    }

    @Override
    public String getSavedReplyCommentId() {
        return this.savedReplyCommentId;
    }

    @Override
    public void setSavedReplyCommentId(String savedReplyCommentId) {
        this.savedReplyCommentId = savedReplyCommentId;
    }

    @Override
    public List<Action> getActionsForComment() {
        return this.webActions.getActionsList(COMMENTS_ACTIONS);
    }

    @Override
    public List<Action> getActionsForComment(String category) {
        return this.webActions.getActionsList(category);
    }

    @Override
    public boolean getShowCreateForm() {
        return this.showCreateForm;
    }

    @Override
    public void setShowCreateForm(boolean flag) {
        this.showCreateForm = flag;
    }

    @Override
    public void toggleCreateForm(ActionEvent event) {
        this.showCreateForm = !this.showCreateForm;
    }

    public void cleanContextVariable() {
        this.commentableDoc = null;
        this.uiComments = null;
        this.commentThread = null;
        this.showCreateForm = false;
        this.commentStarted = false;
        this.savedReplyCommentId = null;
        this.newContent = null;
    }
}

