/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.task.update;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.common.utils.FileVersion;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.task.Task;
import org.nuxeo.connect.update.task.update.Entry;
import org.nuxeo.connect.update.task.update.JarUtils;
import org.nuxeo.connect.update.task.update.RegistrySerializer;
import org.nuxeo.connect.update.task.update.RollbackOptions;
import org.nuxeo.connect.update.task.update.UpdateOptions;
import org.nuxeo.connect.update.task.update.Version;

public class UpdateManager {
    private static final Log log = LogFactory.getLog(UpdateManager.class);
    protected Task task;
    protected Map<String, Entry> registry;
    protected File file;
    protected File backupRoot;
    protected File serverRoot;

    public UpdateManager(File serverRoot, File regFile) {
        this.file = regFile;
        this.backupRoot = new File(this.file.getParentFile(), "backup");
        this.backupRoot.mkdirs();
        this.serverRoot = serverRoot;
    }

    public UpdateOptions createUpdateOptions(String pkgId, File file, File targetDir) {
        return UpdateOptions.newInstance(pkgId, file, targetDir);
    }

    public RollbackOptions createRollbackOptions(String pkgId, String key, String version) {
        return new RollbackOptions(pkgId, key, version);
    }

    public RollbackOptions createRollbackOptions(UpdateOptions opt, String key) {
        RollbackOptions r = new RollbackOptions(opt.pkgId, key, opt.version);
        r.setDeleteOnExit(opt.deleteOnExit);
        return r;
    }

    public File getServerRoot() {
        return this.serverRoot;
    }

    public File getBackupRoot() {
        return this.backupRoot;
    }

    public Task getTask() {
        return this.task;
    }

    public Map<String, Entry> getRegistry() {
        return this.registry;
    }

    public synchronized void load() throws PackageException {
        if (!this.file.isFile()) {
            this.registry = new HashMap<String, Entry>();
            return;
        }
        try {
            this.registry = RegistrySerializer.load(this.file);
        }
        catch (PackageException e) {
            throw e;
        }
        catch (IOException e) {
            throw new PackageException("IOException while trying to load the registry", (Throwable)e);
        }
    }

    public synchronized void store() throws PackageException {
        try {
            RegistrySerializer.store(this.registry, this.file);
        }
        catch (IOException e) {
            throw new PackageException("IOException while trying to write the registry", (Throwable)e);
        }
    }

    public String getVersionPath(UpdateOptions opt) {
        return this.getServerRelativePath(opt.getTargetFile());
    }

    public String getKey(UpdateOptions opt) {
        String key = this.getServerRelativePath(opt.getTargetDir());
        key = key.endsWith(File.separator) ? key.concat(opt.nameWithoutVersion) : key.concat(File.separator).concat(opt.nameWithoutVersion);
        return key;
    }

    public RollbackOptions update(UpdateOptions opt) throws PackageException {
        Version v;
        String key = this.getKey(opt);
        Entry entry = this.registry.get(key);
        if (entry == null) {
            entry = this.createEntry(key);
        }
        if ((v = entry.getVersion(opt.version)) != null && !opt.isSnapshotVersion()) {
            v.addPackage(opt.getPackageId());
            return this.createRollbackOptions(opt, key);
        }
        if (v == null) {
            v = entry.addVersion(new Version(opt.getVersion()));
            v.setPath(this.getVersionPath(opt));
        }
        this.backupFile(opt.getFile(), v.getPath());
        v.addPackage(opt.getPackageId());
        this.doUpdate(key, v, opt);
        return this.createRollbackOptions(opt, key);
    }

    public void rollback(RollbackOptions opt) throws PackageException {
        Version versionToRollback;
        Entry entry = this.registry.get(opt.getKey());
        if (entry == null) {
            return;
        }
        Version v = entry.getVersion(opt.getVersion());
        if (v == null) {
            return;
        }
        Version lastVersion = entry.getLastVersion();
        boolean removeBackup = false;
        v.removePackage(opt.getPackageId());
        if (!v.hasPackages()) {
            entry.removeVersion(v);
            removeBackup = true;
        }
        if ((versionToRollback = entry.getLastVersion()) == null) {
            this.registry.remove(entry.getKey());
            this.rollbackBaseVersion(entry, opt);
        } else if (versionToRollback != lastVersion) {
            this.rollbackVersion(entry, versionToRollback, opt);
        } else {
            Version greatest;
            JarUtils.Match<File> m = this.findInstalledJar(opt.getKey());
            if (m != null && entry.getVersion(m.version) == null && (greatest = entry.getGreatestVersion()) != null) {
                this.rollbackVersion(entry, greatest, opt);
            }
        }
        if (removeBackup) {
            this.removeBackup(v.getPath());
        }
    }

    protected void rollbackBaseVersion(Entry entry, RollbackOptions opt) throws PackageException {
        Version base = entry.getBaseVersion();
        if (base != null) {
            this.rollbackVersion(entry, base, opt);
            this.removeBackup(base.getPath());
        } else {
            JarUtils.Match<File> m = JarUtils.findJar(this.serverRoot, entry.getKey());
            if (m != null) {
                if (opt.isDeleteOnExit()) {
                    ((File)m.object).deleteOnExit();
                } else {
                    ((File)m.object).delete();
                }
            }
        }
    }

    protected void rollbackVersion(Entry entry, Version version, RollbackOptions opt) throws PackageException {
        File versionFile = this.getBackup(version.getPath());
        if (!versionFile.isFile()) {
            log.error((Object)("Could not rollback version " + version.getPath() + " since the backup file was not found"));
            return;
        }
        JarUtils.Match<File> m = this.findInstalledJar(entry.getKey());
        File oldFile = m != null ? (File)m.object : null;
        File targetFile = this.getTargetFile(version.getPath());
        this.deleteOldFile(targetFile, oldFile, opt.deleteOnExit);
        this.copy(versionFile, targetFile);
    }

    public String getServerRelativePath(File someFile) {
        String path = someFile.getAbsolutePath();
        String serverPath = this.serverRoot.getAbsolutePath();
        if (!serverPath.endsWith(File.separator)) {
            serverPath = serverPath.concat(File.separator);
        }
        if (path.startsWith(serverPath)) {
            return path.substring(serverPath.length());
        }
        return path;
    }

    public Entry createEntry(String key) throws PackageException {
        Entry entry = new Entry(key);
        JarUtils.Match<File> m = JarUtils.findJar(this.serverRoot, key);
        if (m != null) {
            String path = this.getServerRelativePath((File)m.object);
            Version base = new Version(m.version);
            base.setPath(path);
            entry.setBaseVersion(base);
            this.backupFile((File)m.object, path);
        }
        this.registry.put(key, entry);
        return entry;
    }

    protected void backupFile(File fileToBackup, String path) throws PackageException {
        try {
            File dst = new File(this.backupRoot, path);
            this.copy(fileToBackup, dst);
        }
        catch (Exception e) {
            throw new PackageException("Failed to backup file: " + path, (Throwable)e);
        }
    }

    protected void removeBackup(String path) {
        File dst = new File(this.backupRoot, path);
        if (!dst.delete()) {
            dst.deleteOnExit();
        }
    }

    protected File getBackup(String path) {
        return new File(this.backupRoot, path);
    }

    protected File getTargetFile(String path) {
        return new File(this.serverRoot, path);
    }

    protected void copy(File src, File dst) throws PackageException {
        try {
            dst.getParentFile().mkdirs();
            File tmp = new File(dst.getPath() + ".tmp");
            FileUtils.copy((File)src, (File)tmp);
            if (!tmp.renameTo(dst)) {
                tmp.delete();
                FileUtils.copy((File)src, (File)dst);
            }
        }
        catch (IOException e) {
            throw new PackageException("Failed to copy file: " + src + " to " + dst, (Throwable)e);
        }
    }

    protected void deleteOldFile(File targetFile, File oldFile, boolean deleteOnExit) {
        if (oldFile == null || !oldFile.exists()) {
            return;
        }
        if (deleteOnExit) {
            if (targetFile.getName().equals(oldFile.getName())) {
                oldFile.delete();
            } else {
                oldFile.deleteOnExit();
            }
        } else {
            oldFile.delete();
        }
    }

    public JarUtils.Match<File> findInstalledJar(String key) {
        return JarUtils.findJar(this.serverRoot, key);
    }

    public JarUtils.Match<File> findBackupJar(String key) {
        return JarUtils.findJar(this.backupRoot, key);
    }

    public void doUpdate(String key, Version version, UpdateOptions opt) throws PackageException {
        FileVersion oldVersion;
        FileVersion newVersion;
        JarUtils.Match<File> existingJar = this.findInstalledJar(key);
        if (opt.upgradeOnly && existingJar == null) {
            return;
        }
        if (!opt.allowDowngrade && existingJar != null && (newVersion = new FileVersion(opt.version)).lessThan(oldVersion = new FileVersion(existingJar.version))) {
            return;
        }
        File oldFile = existingJar != null ? (File)existingJar.object : null;
        this.deleteOldFile(opt.targetFile, oldFile, opt.deleteOnExit);
        this.copy(opt.file, opt.targetFile);
    }
}

