/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.DocumentTypeDescriptor;
import org.nuxeo.ecm.core.schema.DocumentTypeImpl;
import org.nuxeo.ecm.core.schema.FacetDescriptor;
import org.nuxeo.ecm.core.schema.Namespace;
import org.nuxeo.ecm.core.schema.PrefetchInfo;
import org.nuxeo.ecm.core.schema.SchemaDescriptor;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.TypeProvider;
import org.nuxeo.ecm.core.schema.TypeRef;
import org.nuxeo.ecm.core.schema.XSDTypes;
import org.nuxeo.ecm.core.schema.types.AnyType;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.CompositeType;
import org.nuxeo.ecm.core.schema.types.CompositeTypeImpl;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.QName;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.SimpleType;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.runtime.api.Framework;

public class SchemaManagerImpl
implements SchemaManager {
    private static final Log log = LogFactory.getLog(SchemaManagerImpl.class);
    private final Map<String, Type> typeReg = new HashMap<String, Type>();
    private final Map<String, Schema> schemaReg = new HashMap<String, Schema>();
    private final Map<String, Schema> uri2schemaReg = new HashMap<String, Schema>();
    private final Map<String, Schema> prefix2schemaReg = new HashMap<String, Schema>();
    private final Map<String, DocumentType> docTypeReg = new HashMap<String, DocumentType>();
    private final Map<String, CompositeType> facetReg = new HashMap<String, CompositeType>();
    private final Map<String, Set<String>> inheritanceCache = new HashMap<String, Set<String>>();
    private final Map<String, List<DocumentTypeDescriptor>> pendingDocTypes;
    private final Map<String, Field> fields = new HashMap<String, Field>();
    private Map<String, Set<String>> facetsCache;
    private File schemaDir;
    private PrefetchInfo prefetchInfo;

    public SchemaManagerImpl() throws Exception {
        this.pendingDocTypes = new HashMap<String, List<DocumentTypeDescriptor>>();
        this.schemaDir = new File(Framework.getRuntime().getHome(), "schemas");
        if (!this.schemaDir.isDirectory()) {
            this.schemaDir.mkdirs();
        }
        for (SimpleType type : XSDTypes.getTypes()) {
            this.registerType(type);
        }
        this.registerBuiltinTypes();
        TypeProvider provider = (TypeProvider)Framework.getService(TypeProvider.class);
        if (provider != this && provider != null) {
            this.importTypes(provider);
        }
    }

    protected void registerBuiltinTypes() {
        this.registerDocumentType(new DocumentTypeImpl(null, "Document", null, null, 256));
        this.registerType(AnyType.INSTANCE);
    }

    public synchronized void importTypes(TypeProvider provider) {
        Type[] types;
        Schema[] schemas;
        DocumentType[] docTypes;
        for (DocumentType docType : docTypes = provider.getDocumentTypes()) {
            this.registerDocumentType(docType);
        }
        for (Schema schema : schemas = provider.getSchemas()) {
            this.registerSchema(schema);
        }
        for (Type type : types = provider.getTypes()) {
            this.registerType(type);
        }
        for (Type type : provider.getFacets()) {
            this.registerFacet((CompositeType)type);
        }
    }

    @Override
    public Type getType(String schema, String name) {
        if ("@builtin".equals(schema)) {
            return this.typeReg.get(name);
        }
        if ("@doctypes".equals(schema)) {
            return this.docTypeReg.get(name);
        }
        if ("@schemas".equals(schema)) {
            return this.schemaReg.get(name);
        }
        if ("@facets".equals(schema)) {
            return this.facetReg.get(name);
        }
        Schema ownerSchema = this.schemaReg.get(schema);
        if (ownerSchema != null) {
            return ownerSchema.getType(name);
        }
        return null;
    }

    @Override
    public void registerType(Type type) {
        String schema = type.getSchemaName();
        if ("@builtin".equals(schema)) {
            this.typeReg.put(type.getName(), type);
        } else if ("@schemas".equals(schema)) {
            this.schemaReg.put(type.getName(), (Schema)type);
        } else if ("@doctypes".equals(schema)) {
            this.docTypeReg.put(type.getName(), (DocumentType)type);
        } else if ("@facets".equals(schema)) {
            this.facetReg.put(type.getName(), (CompositeType)type);
        } else {
            Schema ownerSchema = this.schemaReg.get(schema);
            if (ownerSchema != null) {
                ownerSchema.registerType(type);
            }
        }
    }

    @Override
    public Type unregisterType(String name) {
        return this.typeReg.remove(name);
    }

    @Override
    public Type getType(String name) {
        return this.typeReg.get(name);
    }

    @Override
    public Type[] getTypes() {
        return this.typeReg.values().toArray(new Type[this.typeReg.size()]);
    }

    @Override
    public Type[] getTypes(String schema) {
        Schema ownerSchema = this.schemaReg.get(schema);
        if (schema != null) {
            return ownerSchema.getTypes();
        }
        return null;
    }

    @Override
    public int getTypesCount() {
        return this.typeReg.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerSchema(Schema schema) {
        Map<String, Schema> map = this.schemaReg;
        synchronized (map) {
            Namespace ns = schema.getNamespace();
            this.uri2schemaReg.put(ns.uri, schema);
            this.prefix2schemaReg.put(ns.prefix, schema);
            this.schemaReg.put(schema.getName(), schema);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Schema unregisterSchema(String name) {
        Schema schema = this.schemaReg.get(name);
        if (schema == null) {
            return null;
        }
        Namespace ns = schema.getNamespace();
        log.info((Object)("Unregister schema: " + name));
        Map<String, Schema> map = this.schemaReg;
        synchronized (map) {
            this.uri2schemaReg.remove(ns.uri);
            this.prefix2schemaReg.remove(ns.prefix);
            return this.schemaReg.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Schema getSchema(String name) {
        Map<String, Schema> map = this.schemaReg;
        synchronized (map) {
            return this.schemaReg.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Schema getSchemaFromPrefix(String schemaPrefix) {
        Map<String, Schema> map = this.schemaReg;
        synchronized (map) {
            return this.prefix2schemaReg.get(schemaPrefix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Schema getSchemaFromURI(String schemaURI) {
        Map<String, Schema> map = this.schemaReg;
        synchronized (map) {
            return this.uri2schemaReg.get(schemaURI);
        }
    }

    @Override
    public Field getField(String prefixedName) {
        Field field = this.fields.get(prefixedName);
        if (field == null) {
            QName qname = QName.valueOf(prefixedName);
            String prefix = qname.getPrefix();
            Schema schema = this.getSchemaFromPrefix(prefix);
            if (schema == null) {
                schema = this.getSchema(prefix);
            }
            if (schema != null && (field = schema.getField(qname.getLocalName())) != null) {
                this.fields.put(prefixedName, field);
            }
        }
        return field;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Schema[] getSchemas() {
        Map<String, Schema> map = this.schemaReg;
        synchronized (map) {
            return this.schemaReg.values().toArray(new Schema[this.schemaReg.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSchemasCount() {
        Map<String, Schema> map = this.schemaReg;
        synchronized (map) {
            return this.schemaReg.size();
        }
    }

    public void setPrefetchInfo(PrefetchInfo prefetchInfo) {
        this.prefetchInfo = prefetchInfo;
    }

    public PrefetchInfo getPrefetchInfo() {
        return this.prefetchInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerDocumentType(DocumentType docType) {
        log.info((Object)("Register document type: " + docType.getName()));
        Map<String, DocumentType> map = this.docTypeReg;
        synchronized (map) {
            this.docTypeReg.put(docType.getName(), docType);
            this.facetsCache = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDocumentType(DocumentTypeDescriptor dtd) {
        Map<String, DocumentType> map = this.docTypeReg;
        synchronized (map) {
            DocumentType superType = null;
            if (dtd.superTypeName != null && (superType = this.docTypeReg.get(dtd.superTypeName)) == null) {
                this.postponeDocTypeRegistration(dtd);
                return;
            }
            this.registerDocumentType(superType, dtd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DocumentType registerDocumentType(DocumentType superType, DocumentTypeDescriptor dtd) {
        Map<String, DocumentType> map = this.docTypeReg;
        synchronized (map) {
            try {
                Set<String> schemaNames = SchemaDescriptor.getSchemaNames(dtd.schemas);
                for (String facetName : dtd.facets) {
                    CompositeType facet = this.getFacet(facetName);
                    if (facet != null) {
                        schemaNames.addAll(Arrays.asList(facet.getSchemaNames()));
                        continue;
                    }
                    log.warn((Object)("Document type " + dtd.name + " uses undeclared facet: " + facetName));
                    CompositeTypeImpl ct = new CompositeTypeImpl((TypeRef<? extends CompositeType>)null, "@facets", facetName, null);
                    this.registerFacet(ct);
                }
                DocumentTypeImpl docType = new DocumentTypeImpl(superType, dtd.name, schemaNames.toArray(new String[0]), dtd.facets);
                docType.setChildrenTypes(dtd.childrenTypes);
                docType.setPrefetchInfo(dtd.prefetch != null ? new PrefetchInfo(dtd.prefetch) : this.prefetchInfo);
                this.docTypeReg.put(dtd.name, docType);
                this.facetsCache = null;
                log.info((Object)("Registered document type: " + dtd.name));
                this.registerPendingDocTypes(docType);
                return docType;
            }
            catch (Exception e) {
                log.error((Object)("Error registering document type: " + dtd.name), (Throwable)e);
                return null;
            }
        }
    }

    private void registerPendingDocTypes(DocumentType superType) {
        List<DocumentTypeDescriptor> list = this.pendingDocTypes.remove(superType.getName());
        if (list == null) {
            return;
        }
        for (DocumentTypeDescriptor dtd : list) {
            this.registerDocumentType(superType, dtd);
        }
    }

    private void removeFromFacetsCache(DocumentType docType) {
        if (this.facetsCache == null) {
            return;
        }
        String name = docType.getName();
        for (String facet : docType.getFacets()) {
            Set<String> types = this.facetsCache.get(facet);
            types.remove(name);
            if (!types.isEmpty()) continue;
            this.facetsCache.remove(facet);
        }
    }

    private void removeFromInheritanceCache(DocumentType docType) {
        String name = docType.getName();
        for (String type : this.inheritanceCache.keySet()) {
            Set<String> types = this.inheritanceCache.get(type);
            types.remove(name);
        }
        this.inheritanceCache.remove(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocumentType unregisterDocumentType(String name) {
        log.info((Object)("Unregister document type: " + name));
        Map<String, DocumentType> map = this.docTypeReg;
        synchronized (map) {
            DocumentType docType = this.docTypeReg.remove(name);
            if (docType != null) {
                this.removeFromFacetsCache(docType);
                this.removeFromInheritanceCache(docType);
            }
            return docType;
        }
    }

    private void postponeDocTypeRegistration(DocumentTypeDescriptor dtd) {
        List<DocumentTypeDescriptor> list = this.pendingDocTypes.get(dtd.superTypeName);
        if (list == null) {
            list = new ArrayList<DocumentTypeDescriptor>();
            this.pendingDocTypes.put(dtd.superTypeName, list);
        }
        list.add(dtd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocumentType getDocumentType(String name) {
        Map<String, DocumentType> map = this.docTypeReg;
        synchronized (map) {
            return this.docTypeReg.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocumentType[] getDocumentTypes() {
        Map<String, DocumentType> map = this.docTypeReg;
        synchronized (map) {
            return this.docTypeReg.values().toArray(new DocumentType[this.docTypeReg.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDocumentTypesCount() {
        Map<String, DocumentType> map = this.docTypeReg;
        synchronized (map) {
            return this.docTypeReg.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerFacet(CompositeType facet) {
        Map<String, CompositeType> map = this.facetReg;
        synchronized (map) {
            this.facetReg.put(facet.getName(), facet);
            log.info((Object)("Registered facet: " + facet.getName()));
        }
    }

    public void registerFacet(FacetDescriptor fd) {
        Set<String> schemas = SchemaDescriptor.getSchemaNames(fd.schemas);
        CompositeTypeImpl ct = new CompositeTypeImpl((TypeRef<? extends CompositeType>)null, "@facets", fd.name, schemas.toArray(new String[0]));
        this.registerFacet(ct);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompositeType unregisterFacet(String name) {
        Map<String, CompositeType> map = this.facetReg;
        synchronized (map) {
            log.info((Object)("Unregistered facet: " + name));
            return this.facetReg.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompositeType getFacet(String name) {
        Map<String, CompositeType> map = this.facetReg;
        synchronized (map) {
            return this.facetReg.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompositeType[] getFacets() {
        Map<String, CompositeType> map = this.facetReg;
        synchronized (map) {
            return this.facetReg.values().toArray(new CompositeType[this.facetReg.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Map<String, ComplexType> map = this.docTypeReg;
        synchronized (map) {
            this.docTypeReg.clear();
            if (this.facetsCache != null) {
                this.facetsCache.clear();
            }
        }
        map = this.schemaReg;
        synchronized (map) {
            this.schemaReg.clear();
        }
        this.typeReg.clear();
        this.facetReg.clear();
    }

    public void setSchemaDirectory(File dir) {
        this.schemaDir = dir;
    }

    public File getSchemaDirectory() {
        return this.schemaDir;
    }

    public File getSchemaFile(String name) {
        return new File(this.schemaDir, name + ".xsd");
    }

    public URL resolveSchemaLocation(String location) {
        if (location.startsWith("schema://")) {
            try {
                return new File(this.schemaDir, location).toURI().toURL();
            }
            catch (MalformedURLException e) {
                log.error((Object)("failed to resolve schema location: " + location), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public Set<String> getDocumentTypeNamesForFacet(String facet) {
        if (this.facetsCache == null) {
            this.initFacetsCache();
        }
        return this.facetsCache.get(facet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initFacetsCache() {
        if (this.facetsCache != null) {
            return;
        }
        SchemaManagerImpl schemaManagerImpl = this;
        synchronized (schemaManagerImpl) {
            this.facetsCache = new HashMap<String, Set<String>>();
            for (DocumentType dt : this.getDocumentTypes()) {
                for (String facet : dt.getFacets()) {
                    Set<String> dts = this.facetsCache.get(facet);
                    if (dts == null) {
                        dts = new HashSet<String>();
                        this.facetsCache.put(facet, dts);
                    }
                    dts.add(dt.getName());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getDocumentTypeNamesExtending(String docTypeName) {
        Set<String> res = this.inheritanceCache.get(docTypeName);
        if (res != null) {
            return res;
        }
        Map<String, Set<String>> map = this.inheritanceCache;
        synchronized (map) {
            res = this.inheritanceCache.get(docTypeName);
            if (res != null) {
                return res;
            }
            if (this.getDocumentType(docTypeName) == null) {
                return null;
            }
            res = new HashSet<String>();
            res.add(docTypeName);
            for (DocumentType dt : this.getDocumentTypes()) {
                Type parent = dt.getSuperType();
                if (parent == null || !docTypeName.equals(parent.getName())) continue;
                res.addAll(this.getDocumentTypeNamesExtending(dt.getName()));
            }
            this.inheritanceCache.put(docTypeName, res);
            return res;
        }
    }

    @Override
    public String getXmlSchemaDefinition(String name) {
        File file = this.getSchemaFile(name);
        if (file != null) {
            try {
                return FileUtils.readFile((File)file);
            }
            catch (IOException e) {
                log.error((Object)String.format("Could not read xsd file for '%s'", name), (Throwable)e);
                return null;
            }
        }
        return null;
    }
}

