/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.events;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.events.EventHandler;
import org.nuxeo.ecm.automation.core.events.OperationEventListener;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;

public class EventHandlerRegistry {
    private static final Log log = LogFactory.getLog(OperationEventListener.class);
    protected final AutomationService svc;
    protected Map<String, List<EventHandler>> handlers;
    protected Map<String, List<EventHandler>> pchandlers;
    protected volatile Map<String, List<EventHandler>> lookup;
    protected volatile Map<String, List<EventHandler>> pclookup;

    public EventHandlerRegistry(AutomationService svc) {
        this.svc = svc;
        this.handlers = new HashMap<String, List<EventHandler>>();
        this.pchandlers = new HashMap<String, List<EventHandler>>();
    }

    public List<EventHandler> getEventHandlers(String eventId) {
        return this.lookup().get(eventId);
    }

    public List<EventHandler> getPostCommitEventHandlers(String eventId) {
        return this.pclookup().get(eventId);
    }

    public void putEventHandler(EventHandler handler) {
        for (String eventId : handler.getEvents()) {
            this.putEventHandler(eventId, handler);
        }
    }

    public synchronized void putEventHandler(String eventId, EventHandler handler) {
        List<EventHandler> handlers = this.handlers.get(eventId);
        if (handlers == null) {
            handlers = new ArrayList<EventHandler>();
            this.handlers.put(eventId, handlers);
        }
        handlers.add(handler);
        this.lookup = null;
    }

    public void putPostCommitEventHandler(EventHandler handler) {
        for (String eventId : handler.getEvents()) {
            this.putPostCommitEventHandler(eventId, handler);
        }
    }

    public synchronized void putPostCommitEventHandler(String eventId, EventHandler handler) {
        List<EventHandler> handlers = this.pchandlers.get(eventId);
        if (handlers == null) {
            handlers = new ArrayList<EventHandler>();
            this.pchandlers.put(eventId, handlers);
        }
        handlers.add(handler);
        this.pclookup = null;
    }

    public synchronized void removePostCommitEventHandler(EventHandler handler) {
        block0: for (String eventId : handler.getEvents()) {
            List<EventHandler> handlers = this.pchandlers.get(eventId);
            if (handlers == null) continue;
            Iterator<EventHandler> it = handlers.iterator();
            while (it.hasNext()) {
                EventHandler h = it.next();
                if (!h.chainId.equals(handler.chainId)) continue;
                it.remove();
                continue block0;
            }
        }
        this.pclookup = null;
    }

    public synchronized void removeEventHandler(EventHandler handler) {
        block0: for (String eventId : handler.getEvents()) {
            List<EventHandler> handlers = this.handlers.get(eventId);
            if (handlers == null) continue;
            Iterator<EventHandler> it = handlers.iterator();
            while (it.hasNext()) {
                EventHandler h = it.next();
                if (!h.chainId.equals(handler.chainId)) continue;
                it.remove();
                continue block0;
            }
        }
        this.lookup = null;
    }

    public synchronized void clear() {
        this.handlers = new HashMap<String, List<EventHandler>>();
        this.pchandlers = new HashMap<String, List<EventHandler>>();
        this.lookup = null;
        this.pclookup = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<EventHandler>> lookup() {
        Map<String, List<EventHandler>> _lookup = this.lookup;
        if (_lookup == null) {
            EventHandlerRegistry eventHandlerRegistry = this;
            synchronized (eventHandlerRegistry) {
                if (this.lookup == null) {
                    this.lookup = new HashMap<String, List<EventHandler>>(this.handlers);
                }
                _lookup = this.lookup;
            }
        }
        return _lookup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<EventHandler>> pclookup() {
        Map<String, List<EventHandler>> _lookup = this.pclookup;
        if (_lookup == null) {
            EventHandlerRegistry eventHandlerRegistry = this;
            synchronized (eventHandlerRegistry) {
                if (this.pclookup == null) {
                    this.pclookup = new HashMap<String, List<EventHandler>>(this.pchandlers);
                }
                _lookup = this.pclookup;
            }
        }
        return _lookup;
    }

    public Set<String> getPostCommitEventNames() {
        return this.pclookup().keySet();
    }

    public boolean acceptEvent(Event event, List<EventHandler> handlers) {
        OperationContext ctx;
        if (handlers == null || handlers.isEmpty()) {
            return false;
        }
        EventContext ectx = event.getContext();
        if (ectx instanceof DocumentEventContext) {
            ctx = new OperationContext(ectx.getCoreSession());
            ctx.setInput(((DocumentEventContext)ectx).getSourceDocument());
        } else {
            ctx = new OperationContext();
        }
        ctx.put("Event", (Object)event);
        for (EventHandler handler : handlers) {
            try {
                if (!handler.isEnabled(ctx, ectx)) continue;
                return true;
            }
            catch (Exception e) {
                log.error((Object)("Failed to check event " + event.getName() + " using chain: " + handler.getChainId()), (Throwable)e);
            }
        }
        return false;
    }

    public void handleEvent(Event event, List<EventHandler> handlers, boolean saveSession) {
        if (handlers == null || handlers.isEmpty()) {
            return;
        }
        EventContext ectx = event.getContext();
        OperationContext ctx = null;
        for (EventHandler handler : handlers) {
            if (ectx instanceof DocumentEventContext) {
                ctx = new OperationContext(ectx.getCoreSession());
                ctx.setInput(((DocumentEventContext)ectx).getSourceDocument());
            } else {
                ctx = new OperationContext();
            }
            ctx.put("Event", (Object)event);
            ctx.setCommit(saveSession);
            try {
                if (!handler.isEnabled(ctx, ectx)) continue;
                this.svc.run(ctx, handler.getChainId());
            }
            catch (Exception e) {
                log.error((Object)("Failed to handle event " + event.getName() + " using chain: " + handler.getChainId()), (Throwable)e);
            }
        }
    }
}

