/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon;

import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.javasimon.Callback;
import org.javasimon.CompositeCallback;
import org.javasimon.CompositeFilterCallback;
import org.javasimon.FilterCallback;
import org.javasimon.Manager;
import org.javasimon.SimonConfiguration;
import org.javasimon.SimonException;
import org.javasimon.SimonPattern;
import org.javasimon.SimonState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ManagerConfiguration {
    private Map<SimonPattern, SimonConfiguration> configs;
    private final Manager manager;

    ManagerConfiguration(Manager manager) {
        this.manager = manager;
        this.clear();
    }

    public void clear() {
        this.configs = new LinkedHashMap<SimonPattern, SimonConfiguration>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readConfig(Reader reader) throws IOException {
        try {
            XMLStreamReader xr = XMLInputFactory.newInstance().createXMLStreamReader(reader);
            try {
                while (!xr.isStartElement()) {
                    xr.next();
                }
                this.processStartElement(xr, "simon-configuration", new String[0]);
                while (true) {
                    if (this.isStartTag(xr, "callback")) {
                        this.manager.callback().addCallback(this.processCallback(xr));
                        continue;
                    }
                    if (this.isStartTag(xr, "filter-callback")) {
                        this.manager.callback().addCallback(this.processFilterCallback(xr));
                        continue;
                    }
                    if (!this.isStartTag(xr, "simon")) break;
                    this.processSimon(xr);
                }
                this.assertEndTag(xr, "simon-configuration");
            }
            finally {
                xr.close();
            }
        }
        catch (XMLStreamException e) {
            this.manager.callback().warning(null, e);
        }
        catch (SimonException e) {
            this.manager.callback().warning(e.getMessage(), e);
        }
    }

    private Callback processCallback(XMLStreamReader xr) throws XMLStreamException {
        Callback callback;
        Map<String, String> attrs = this.processStartElement(xr, "callback", new String[0]);
        String klass = attrs.get("class");
        if (klass == null) {
            klass = CompositeCallback.class.getName();
        }
        try {
            callback = (Callback)Class.forName(klass).newInstance();
        }
        catch (InstantiationException e) {
            throw new SimonException(e);
        }
        catch (IllegalAccessException e) {
            throw new SimonException(e);
        }
        catch (ClassNotFoundException e) {
            throw new SimonException(e);
        }
        catch (ClassCastException e) {
            throw new SimonException(e);
        }
        this.processSetAndCallbacks(xr, callback);
        this.processEndElement(xr, "callback");
        return callback;
    }

    private Callback processFilterCallback(XMLStreamReader xr) throws XMLStreamException {
        FilterCallback callback;
        Map<String, String> attrs = this.processStartElement(xr, "filter-callback", new String[0]);
        String klass = attrs.get("class");
        if (klass == null) {
            klass = CompositeFilterCallback.class.getName();
        }
        try {
            callback = (FilterCallback)Class.forName(klass).newInstance();
        }
        catch (InstantiationException e) {
            throw new SimonException(e);
        }
        catch (IllegalAccessException e) {
            throw new SimonException(e);
        }
        catch (ClassNotFoundException e) {
            throw new SimonException(e);
        }
        catch (ClassCastException e) {
            throw new SimonException(e);
        }
        while (this.isStartTag(xr, "rule")) {
            this.processRule(xr, callback);
        }
        this.processSetAndCallbacks(xr, callback);
        this.processEndElement(xr, "filter-callback");
        return callback;
    }

    private void processSetAndCallbacks(XMLStreamReader xr, Callback callback) throws XMLStreamException {
        while (this.isStartTag(xr, "set")) {
            this.processSet(xr, callback);
        }
        while (true) {
            if (this.isStartTag(xr, "callback")) {
                callback.addCallback(this.processCallback(xr));
                continue;
            }
            if (!this.isStartTag(xr, "filter-callback")) break;
            callback.addCallback(this.processFilterCallback(xr));
        }
    }

    private void processRule(XMLStreamReader xr, FilterCallback callback) throws XMLStreamException {
        String pattern = null;
        FilterCallback.Rule.Type type = FilterCallback.Rule.Type.SUFFICE;
        String condition = null;
        ArrayList<Callback.Event> events = new ArrayList<Callback.Event>();
        Map<String, String> attrs = this.processStartElement(xr, "rule", new String[0]);
        if (attrs.get("condition") != null) {
            condition = attrs.get("condition");
        }
        if (attrs.get("type") != null) {
            type = FilterCallback.Rule.Type.valueOf(this.toEnum(attrs.get("type")));
        }
        if (attrs.get("pattern") != null) {
            pattern = attrs.get("pattern");
        }
        if (attrs.get("events") != null) {
            String[] sa;
            for (String eventName : sa = attrs.get("events").trim().split(" *, *")) {
                events.add(Callback.Event.valueOf(this.toEnum(eventName)));
            }
        }
        if (this.isStartTag(xr, "condition")) {
            xr.next();
            condition = this.getText(xr);
            this.processEndElement(xr, "condition");
        }
        this.processEndElement(xr, "rule");
        callback.addRule(type, condition, pattern, events.toArray(new Callback.Event[events.size()]));
    }

    private void processSet(XMLStreamReader xr, Callback callback) throws XMLStreamException {
        Map<String, String> attrs = this.processStartElement(xr, "set", "property");
        this.setProperty(callback, attrs.get("property"), attrs.get("value"));
        this.processEndElement(xr, "set");
    }

    private void setProperty(Callback callback, String property, String value) {
        try {
            if (value != null) {
                Method setter = callback.getClass().getMethod(this.setterName(property), String.class);
                setter.invoke((Object)callback, value);
            } else {
                callback.getClass().getMethod(this.setterName(property), new Class[0]).invoke((Object)callback, new Object[0]);
            }
        }
        catch (NoSuchMethodException e) {
            throw new SimonException(e);
        }
        catch (IllegalAccessException e) {
            throw new SimonException(e);
        }
        catch (InvocationTargetException e) {
            throw new SimonException(e);
        }
    }

    private String setterName(String name) {
        return "set" + name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    private void processSimon(XMLStreamReader xr) throws XMLStreamException {
        Map<String, String> attrs = this.processStartElement(xr, "simon", "pattern");
        String pattern = attrs.get("pattern");
        SimonState state = attrs.get("state") != null ? SimonState.valueOf(this.toEnum(attrs.get("state"))) : null;
        this.configs.put(new SimonPattern(pattern), new SimonConfiguration(state));
        this.processEndElement(xr, "simon");
    }

    SimonConfiguration getConfig(String name) {
        SimonState state = null;
        for (SimonPattern pattern : this.configs.keySet()) {
            SimonConfiguration config;
            if (!pattern.matches(name) || (config = this.configs.get(pattern)).getState() == null) continue;
            state = config.getState();
        }
        return new SimonConfiguration(state);
    }

    private String toEnum(String enumVal) {
        return enumVal.trim().toUpperCase().replace('-', '_');
    }

    private Map<String, String> processStartElement(XMLStreamReader reader, String elementName, String ... requiredAttributes) throws XMLStreamException {
        Map<String, String> attrs = this.processStartElementPrivate(reader, elementName, requiredAttributes);
        reader.nextTag();
        return attrs;
    }

    private Map<String, String> processStartElementPrivate(XMLStreamReader reader, String elementName, String ... requiredAttributes) throws XMLStreamException {
        this.assertStartTag(reader, elementName);
        Map<String, String> attrs = this.readAttributes(reader);
        for (String attr : requiredAttributes) {
            if (attrs.containsKey(attr)) continue;
            throw new XMLStreamException("Attribute '" + attr + "' MUST be present (element: " + elementName + "). " + this.readerPosition(reader));
        }
        return attrs;
    }

    private void assertStartTag(XMLStreamReader reader, String name) throws XMLStreamException {
        if (!reader.isStartElement()) {
            throw new XMLStreamException("Assert start tag - wrong event type " + reader.getEventType() + " (expected name: " + name + ") " + this.readerPosition(reader));
        }
        this.assertName(reader, "start tag", name);
    }

    private Map<String, String> readAttributes(XMLStreamReader reader) {
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        int attrCount = reader.getAttributeCount();
        for (int i = 0; i < attrCount; ++i) {
            attributes.put(reader.getAttributeName(i).toString(), reader.getAttributeValue(i));
        }
        return attributes;
    }

    private void assertName(XMLStreamReader reader, String operation, String name) throws XMLStreamException {
        if (!reader.getLocalName().equals(name)) {
            throw new XMLStreamException("Assert " + operation + " - wrong element name " + reader.getName().toString() + " (expected name: " + name + ") " + this.readerPosition(reader));
        }
    }

    private String readerPosition(XMLStreamReader reader) {
        return "[line: " + reader.getLocation().getLineNumber() + ", column: " + reader.getLocation().getColumnNumber() + "]";
    }

    private void assertEndTag(XMLStreamReader reader, String name) throws XMLStreamException {
        if (!reader.isEndElement()) {
            throw new XMLStreamException("Assert end tag - wrong event type " + reader.getEventType() + " (expected name: " + name + ") " + this.readerPosition(reader));
        }
        this.assertName(reader, "end tag", name);
    }

    private boolean isStartTag(XMLStreamReader reader, String name) {
        return reader.isStartElement() && reader.getLocalName().equals(name);
    }

    private void processEndElement(XMLStreamReader reader, String name) throws XMLStreamException {
        this.assertEndTag(reader, name);
        reader.nextTag();
    }

    private String getText(XMLStreamReader reader) throws XMLStreamException {
        StringBuilder sb = new StringBuilder();
        while (reader.isCharacters()) {
            sb.append(reader.getText());
            reader.next();
        }
        return sb.toString().trim();
    }
}

