/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.packages.dependencies;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.packages.InternalPackageManager;
import org.nuxeo.connect.packages.dependencies.DependencyException;
import org.nuxeo.connect.update.Version;

public class DependencyResolution {
    private static final Log log = LogFactory.getLog(DependencyResolution.class);
    protected Boolean resolution = null;
    protected boolean sorted = false;
    protected String failedMessage;
    protected Map<String, Version> allPackages = new HashMap<String, Version>();
    protected Map<String, Version> newPackagesToDownload = new HashMap<String, Version>();
    protected Map<String, Version> localPackagesToInstall = new HashMap<String, Version>();
    protected Map<String, Version> localPackagesToUpgrade = new HashMap<String, Version>();
    protected Map<String, Version> localPackagesToRemove = new HashMap<String, Version>();
    protected Map<String, Version> localUnchangedPackages = new HashMap<String, Version>();
    protected List<String> orderedInstallablePackages = new ArrayList<String>();
    protected List<String> allPackagesToDownload = new ArrayList<String>();

    public DependencyResolution() {
    }

    public DependencyResolution(DependencyException ex) {
        this.markAsFailed(ex.getMessage());
    }

    @Deprecated
    public void markAsFailed() {
        this.resolution = false;
    }

    public void markAsFailed(String message) {
        this.resolution = false;
        this.failedMessage = message;
        log.warn((Object)this.failedMessage);
    }

    public void markAsSuccess() {
        this.resolution = true;
    }

    public boolean isValidated() {
        if (this.resolution == null) {
            return false;
        }
        return this.resolution;
    }

    public boolean isFailed() {
        if (this.resolution == null) {
            return false;
        }
        return this.resolution == false;
    }

    public boolean addPackage(String pkgName, Version v) {
        if (!this.allPackages.containsKey(pkgName)) {
            log.debug((Object)("addPackage " + pkgName + " " + v));
            this.allPackages.put(pkgName, v);
            this.orderedInstallablePackages.add(0, pkgName);
        } else if (!this.allPackages.get(pkgName).equals(v)) {
            this.markAsFailed("addPackage conflict " + pkgName + " " + v + " with " + this.allPackages.get(pkgName));
        } else {
            log.debug((Object)("addPackage ignored " + pkgName + " " + v));
        }
        return !this.isFailed();
    }

    public void markPackageForRemoval(String pkgName, Version v) {
        log.debug((Object)("markPackageForRemoval " + pkgName + " " + v));
        this.localPackagesToRemove.put(pkgName, v);
    }

    public void sort(InternalPackageManager pm) {
        this.localPackagesToUpgrade.clear();
        this.newPackagesToDownload.clear();
        this.localPackagesToInstall.clear();
        this.localUnchangedPackages.clear();
        this.allPackagesToDownload.clear();
        for (String pkgName : this.allPackages.keySet()) {
            String id = pkgName + "-" + this.allPackages.get(pkgName).toString();
            DownloadablePackage pkg = pm.findPackageById(id);
            List<Version> existingVersions = pm.findLocalPackageInstalledVersions(pkg.getName());
            if (existingVersions.size() > 0 && !existingVersions.contains(pkg.getVersion())) {
                this.localPackagesToUpgrade.put(pkg.getName(), pkg.getVersion());
                if (pkg.getState() != 0) continue;
                this.allPackagesToDownload.add(id);
                continue;
            }
            if (pkg.getState() == 0) {
                this.newPackagesToDownload.put(pkg.getName(), pkg.getVersion());
                this.allPackagesToDownload.add(id);
                continue;
            }
            if (pkg.getState() > 0 && pkg.getState() < 3) {
                this.localPackagesToInstall.put(pkg.getName(), pkg.getVersion());
                continue;
            }
            if (pkg.getState() <= 3) continue;
            this.localUnchangedPackages.put(pkg.getName(), pkg.getVersion());
        }
        this.sorted = true;
    }

    public Map<String, Version> getNewPackagesToDownload() {
        return this.newPackagesToDownload;
    }

    public Map<String, Version> getLocalPackagesToInstall() {
        return this.localPackagesToInstall;
    }

    public Map<String, Version> getLocalPackagesToUpgrade() {
        return this.localPackagesToUpgrade;
    }

    public Map<String, Version> getLocalPackagesToRemove() {
        return this.localPackagesToRemove;
    }

    public Map<String, Version> getLocalUnchangedPackages() {
        return this.localUnchangedPackages;
    }

    public boolean requireChanges() {
        return !this.localPackagesToRemove.isEmpty() || !this.localPackagesToUpgrade.isEmpty() || !this.localPackagesToInstall.isEmpty() || !this.newPackagesToDownload.isEmpty();
    }

    public List<String> getInstallationOrder() {
        return this.orderedInstallablePackages;
    }

    public List<String> getUnchangedPackageIds() {
        ArrayList<String> res = new ArrayList<String>();
        for (Map.Entry<String, Version> entry : this.getLocalUnchangedPackages().entrySet()) {
            res.add(entry.getKey() + "-" + entry.getValue().toString());
        }
        Collections.sort(res);
        return res;
    }

    public List<String> getUpgradePackageIds() {
        ArrayList<String> res = new ArrayList<String>();
        for (Map.Entry<String, Version> entry : this.getLocalPackagesToUpgrade().entrySet()) {
            res.add(entry.getKey() + "-" + entry.getValue().toString());
        }
        Collections.sort(res);
        return res;
    }

    public List<String> getInstallPackageIds() {
        ArrayList<String> res = new ArrayList<String>();
        for (Map.Entry<String, Version> entry : this.getLocalPackagesToInstall().entrySet()) {
            res.add(entry.getKey() + "-" + entry.getValue().toString());
        }
        Collections.sort(res);
        return res;
    }

    public List<String> getDownloadPackageIds() {
        ArrayList<String> res = new ArrayList<String>();
        for (Map.Entry<String, Version> entry : this.getNewPackagesToDownload().entrySet()) {
            res.add(entry.getKey() + "-" + entry.getValue().toString());
        }
        Collections.sort(res);
        return res;
    }

    public List<String> getRemovePackageIds() {
        ArrayList<String> res = new ArrayList<String>();
        for (Map.Entry<String, Version> entry : this.getLocalPackagesToRemove().entrySet()) {
            res.add(entry.getKey() + "-" + entry.getValue().toString());
        }
        Collections.sort(res);
        return res;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.isFailed()) {
            sb.append("Failed to resolve dependencies: ");
            sb.append(this.failedMessage);
        } else if (!this.sorted) {
            this.append(sb, this.allPackages, "Unsorted packages: ");
        } else {
            sb.append("Dependency resolution:\n");
            this.append(sb, this.orderedInstallablePackages, "Installation order: ");
            this.append(sb, this.localUnchangedPackages, "Unchanged packages: ");
            this.append(sb, this.localPackagesToRemove, "Packages to uninstall: ");
            this.append(sb, this.newPackagesToDownload, "Remote packages to install: ");
            this.append(sb, this.localPackagesToInstall, "Local packages to install: ");
            this.append(sb, this.localPackagesToUpgrade, "Packages to upgrade: ");
        }
        return sb.toString();
    }

    private StringBuffer append(StringBuffer sb, Map<String, Version> pkgMap, String title) {
        if (!pkgMap.isEmpty()) {
            sb.append(title);
            for (String pkgName : pkgMap.keySet()) {
                sb.append(pkgName);
                sb.append(":");
                sb.append(pkgMap.get(pkgName).toString());
                sb.append(", ");
            }
            sb.replace(sb.length() - 2, sb.length(), "\n");
        }
        return sb;
    }

    private StringBuffer append(StringBuffer sb, List<String> pkgList, String title) {
        if (!pkgList.isEmpty()) {
            sb.append(title);
            for (String pkg : pkgList) {
                sb.append(pkg + "/");
            }
            sb.replace(sb.length() - 1, sb.length(), "\n");
        }
        return sb;
    }

    public String getInstallationOrderAsString() {
        return this.removeLineReturn(this.append(new StringBuffer(), this.orderedInstallablePackages, ""));
    }

    private String removeLineReturn(StringBuffer sb) {
        if (sb.length() > 0) {
            return sb.substring(0, sb.length() - 1);
        }
        return "";
    }

    public List<String> getOrderedPackageIdsToInstall() {
        ArrayList<String> pkgIds = new ArrayList<String>();
        for (String pkgName : this.orderedInstallablePackages) {
            String pkgId = pkgName + "-" + this.allPackages.get(pkgName).toString();
            pkgIds.add(pkgId);
        }
        return pkgIds;
    }

    public String getAllPackagesToDownloadAsString() {
        return this.removeLineReturn(this.append(new StringBuffer(), this.allPackagesToDownload, ""));
    }

    public int getNbPackagesToDownload() {
        return this.allPackagesToDownload.size();
    }
}

