/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.packages.dependencies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.equinox.p2.cudf.Parser;
import org.eclipse.equinox.p2.cudf.solver.ProfileChangeRequest;
import org.eclipse.equinox.p2.cudf.solver.SimplePlanner;
import org.eclipse.equinox.p2.cudf.solver.SolverConfiguration;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.packages.InternalPackageManager;
import org.nuxeo.connect.packages.dependencies.CUDFHelper;
import org.nuxeo.connect.packages.dependencies.DependencyException;
import org.nuxeo.connect.packages.dependencies.DependencyResolution;
import org.nuxeo.connect.packages.dependencies.DependencyResolver;
import org.nuxeo.connect.update.PackageDependency;
import org.nuxeo.connect.update.VersionRange;

public class P2CUDFDependencyResolver
implements DependencyResolver {
    protected static Log log = LogFactory.getLog(P2CUDFDependencyResolver.class);
    protected InternalPackageManager pm;
    protected CUDFHelper cudfHelper;

    protected P2CUDFDependencyResolver() {
    }

    public P2CUDFDependencyResolver(InternalPackageManager pm) {
        this.pm = pm;
    }

    @Override
    public DependencyResolution resolve(List<String> pkgInstall, List<String> pkgRemove, List<String> pkgUpgrade, String targetPlatform) throws DependencyException {
        this.cudfHelper = new CUDFHelper(this.pm);
        this.cudfHelper.setTargetPlatform(targetPlatform);
        String cudf = this.cudfHelper.getCUDFFile(this.str2PkgDep(pkgInstall), this.str2PkgDep(pkgRemove), this.str2PkgDep(pkgUpgrade));
        log.debug((Object)("CUDF request:\n" + cudf));
        ProfileChangeRequest req = new Parser().parse(IOUtils.toInputStream((String)cudf));
        SolverConfiguration configuration = new SolverConfiguration("-removed,-notuptodate,-unsat_recommends,-new,-changed,-versionchanged");
        if (log.isTraceEnabled()) {
            configuration.verbose = true;
            configuration.explain = true;
        }
        SimplePlanner planner = new SimplePlanner();
        planner.getSolutionFor(req, configuration);
        planner.stopSolver();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Collection solution = planner.getBestSolutionFoundSoFar();
        if (log.isTraceEnabled()) {
            log.trace((Object)planner.getExplanation());
        }
        if (!planner.isSolutionOptimal()) {
            log.warn((Object)"The solution found might not be optimal");
        }
        DependencyResolution resolution = this.cudfHelper.buildResolution(solution, planner.getSolutionDetails());
        return resolution;
    }

    private PackageDependency[] str2PkgDep(List<String> pkgList) {
        ArrayList<PackageDependency> list = new ArrayList<PackageDependency>();
        if (pkgList == null || pkgList.size() == 0) {
            return list.toArray(new PackageDependency[0]);
        }
        for (String pkgStr : pkgList) {
            list.add(new PackageDependency(pkgStr));
        }
        return list.toArray(new PackageDependency[list.size()]);
    }

    @Override
    public DependencyResolution resolve(String pkgId, String targetPlatform) throws DependencyException {
        ArrayList<String> pkgInstall = new ArrayList<String>();
        if (pkgId.contains(":")) {
            pkgInstall.add(pkgId);
        } else {
            DownloadablePackage pkg = this.pm.getPackage(pkgId);
            if (pkg == null) {
                throw new DependencyException("Couldn't find " + pkgId);
            }
            pkgInstall.add(new PackageDependency(pkg.getName(), new VersionRange(pkg.getVersion())).toString());
        }
        return this.resolve(pkgInstall, null, null, targetPlatform);
    }
}

