/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.facelets;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.FaceletHandler;
import com.sun.facelets.tag.MetaTagHandler;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagConfig;
import com.sun.facelets.tag.TagException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.forms.layout.api.Widget;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetDefinition;
import org.nuxeo.ecm.platform.forms.layout.facelets.FaceletHandlerHelper;
import org.nuxeo.ecm.platform.forms.layout.facelets.RenderVariables;
import org.nuxeo.ecm.platform.forms.layout.service.WebLayoutManager;
import org.nuxeo.ecm.platform.ui.web.util.ComponentTagUtils;
import org.nuxeo.runtime.api.Framework;

public class WidgetTagHandler
extends MetaTagHandler {
    private static final Log log = LogFactory.getLog(WidgetTagHandler.class);
    protected final TagConfig config;
    protected final TagAttribute widget;
    protected final TagAttribute name;
    protected final TagAttribute category;
    protected final TagAttribute definition;
    protected final TagAttribute mode;
    protected final TagAttribute layoutName;
    protected final TagAttribute value;
    protected final TagAttribute[] vars;
    protected final String[] reservedVarsArray = new String[]{"id", "widget", "value"};

    public WidgetTagHandler(TagConfig config) {
        super(config);
        this.config = config;
        this.widget = this.getAttribute("widget");
        this.name = this.getAttribute("name");
        this.definition = this.getAttribute("definition");
        this.category = this.getAttribute("category");
        this.mode = this.getAttribute("mode");
        this.layoutName = this.getAttribute("layoutName");
        this.value = this.getRequiredAttribute("value");
        this.vars = this.tag.getAttributes().getAll();
        if (this.name == null && this.widget == null && this.definition == null) {
            throw new TagException(this.tag, "At least one of attributes 'name', 'widget' or 'definition' is required");
        }
        if (this.widget == null && (this.name != null || this.definition != null) && this.mode == null) {
            throw new TagException(this.tag, "Attribute 'mode' is required when using attribute 'name' or 'definition' so that the widget instance can be resolved");
        }
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, ELException {
        String valueName = this.value.getValue();
        if (ComponentTagUtils.isStrictValueReference((String)valueName)) {
            valueName = ComponentTagUtils.getBareValueName((String)valueName);
        }
        Widget widgetInstance = null;
        if (this.widget != null) {
            widgetInstance = (Widget)this.widget.getObject(ctx, Widget.class);
            if (widgetInstance != null) {
                widgetInstance.setValueName(valueName);
            }
        } else {
            WidgetDefinition widgetDef;
            WebLayoutManager layoutService;
            try {
                layoutService = (WebLayoutManager)Framework.getService(WebLayoutManager.class);
            }
            catch (Exception e) {
                throw new FacesException((Throwable)e);
            }
            if (layoutService == null) {
                throw new FacesException("Layout service not found");
            }
            String modeValue = this.mode.getValue(ctx);
            String layoutNameValue = null;
            if (this.layoutName != null) {
                layoutNameValue = this.layoutName.getValue(ctx);
            }
            if (this.name != null) {
                String nameValue = this.name.getValue(ctx);
                String catValue = null;
                if (this.category != null) {
                    catValue = this.category.getValue(ctx);
                }
                widgetInstance = layoutService.getWidget(ctx, nameValue, catValue, modeValue, valueName, layoutNameValue);
            } else if (this.definition != null && (widgetDef = (WidgetDefinition)this.definition.getObject(ctx, WidgetDefinition.class)) != null) {
                widgetInstance = layoutService.getWidget(ctx, widgetDef, modeValue, valueName, layoutNameValue);
            }
        }
        if (widgetInstance != null) {
            List<String> reservedVars = Arrays.asList(this.reservedVarsArray);
            for (TagAttribute var : this.vars) {
                String localName = var.getLocalName();
                if (reservedVars.contains(localName)) continue;
                widgetInstance.setProperty(localName, (Serializable)((Object)var.getValue()));
            }
            WidgetTagHandler.applyWidgetHandler(ctx, parent, this.config, widgetInstance, this.value, true, this.nextHandler);
        }
    }

    public static void generateWidgetIdsRecursive(FaceletHandlerHelper helper, Widget widget) {
        if (widget == null) {
            return;
        }
        widget.setId(helper.generateWidgetId(widget.getName()));
        Widget[] subWidgets = widget.getSubWidgets();
        if (subWidgets != null) {
            for (Widget subWidget : subWidgets) {
                WidgetTagHandler.generateWidgetIdsRecursive(helper, subWidget);
            }
        }
    }

    public static void applyWidgetHandler(FaceletContext ctx, UIComponent parent, TagConfig config, Widget widget, TagAttribute value, boolean fillVariables, FaceletHandler nextHandler) throws IOException {
        WebLayoutManager layoutService;
        if (widget == null) {
            return;
        }
        try {
            layoutService = (WebLayoutManager)Framework.getService(WebLayoutManager.class);
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
        FaceletHandlerHelper helper = new FaceletHandlerHelper(ctx, config);
        WidgetTagHandler.generateWidgetIdsRecursive(helper, widget);
        FaceletHandler handler = layoutService.getFaceletHandler(ctx, config, widget, nextHandler);
        if (handler == null) {
            return;
        }
        if (fillVariables) {
            HashMap<String, ValueExpression> variables = new HashMap<String, ValueExpression>();
            ValueExpression valueExpr = value.getValueExpression(ctx, Object.class);
            variables.put(RenderVariables.globalVariables.value.name(), valueExpr);
            variables.put(String.format("%s_%s", RenderVariables.globalVariables.value.name(), widget.getLevel()), valueExpr);
            variables.put(RenderVariables.globalVariables.document.name(), valueExpr);
            FaceletHandler handlerWithVars = helper.getAliasTagHandler(widget.getTagConfigId(), variables, null, handler);
            handlerWithVars.apply(ctx, parent);
        } else {
            handler.apply(ctx, parent);
        }
    }
}

