/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.commons.text;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TextTemplate {
    private static final Log log = LogFactory.getLog(TextTemplate.class);
    private static final Pattern PATTERN = Pattern.compile("\\$\\{([a-zA-Z_0-9\\-\\.]+)\\}");
    private static final int MAX_RECURSION_LEVEL = 10;
    private final Properties vars;
    private Properties processedVars;
    private boolean trim = false;
    private List<String> plainTextExtensions;
    private List<String> freemarkerExtensions = new ArrayList<String>();
    private Configuration freemarkerConfiguration = null;
    private Map<String, Object> freemarkerVars = null;
    private boolean extensionsContainsDot = false;

    public boolean isTrim() {
        return this.trim;
    }

    public void setTrim(boolean trim) {
        this.trim = trim;
    }

    public TextTemplate() {
        this.vars = new Properties();
        this.processedVars = new Properties();
    }

    @Deprecated
    public TextTemplate(Map<String, String> vars) {
        this.vars = new Properties();
        this.vars.putAll(vars);
        this.processedVars = this.preprocessVars(this.vars);
    }

    public TextTemplate(Properties vars) {
        this.vars = vars;
        this.processedVars = this.preprocessVars(this.vars);
    }

    @Deprecated
    public void setVariables(Map<String, String> vars) {
        this.vars.putAll(vars);
        this.processedVars = this.preprocessVars(this.vars);
    }

    public void setVariable(String name, String value) {
        this.vars.setProperty(name, value);
        this.processedVars = this.preprocessVars(this.vars);
    }

    public String getVariable(String name) {
        return this.vars.getProperty(name);
    }

    public Properties getVariables() {
        return this.vars;
    }

    public Properties preprocessVars(Properties unprocessedVars) {
        Properties newVars = new Properties(unprocessedVars);
        boolean doneProcessing = false;
        int recursionLevel = 0;
        while (!doneProcessing) {
            doneProcessing = true;
            Enumeration<?> newVarsEnum = newVars.propertyNames();
            while (newVarsEnum.hasMoreElements()) {
                String newVarsKey = (String)newVarsEnum.nextElement();
                String newVarsValue = newVars.getProperty(newVarsKey);
                Matcher m = PATTERN.matcher(newVarsValue);
                StringBuffer sb = new StringBuffer();
                while (m.find()) {
                    String embeddedVar = m.group(1);
                    String value = newVars.getProperty(embeddedVar);
                    if (value == null) continue;
                    if (this.trim) {
                        value = value.trim();
                    }
                    String escapedValue = Matcher.quoteReplacement(value);
                    m.appendReplacement(sb, escapedValue);
                }
                m.appendTail(sb);
                String replacementValue = sb.toString();
                if (replacementValue.equals(newVarsValue)) continue;
                doneProcessing = false;
                newVars.put(newVarsKey, replacementValue);
            }
            if (doneProcessing || ++recursionLevel <= 10) continue;
            break;
        }
        return newVars;
    }

    public String processText(CharSequence text) {
        Matcher m = PATTERN.matcher(text);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String var = m.group(1);
            String value = this.getVariable(var);
            if (value == null) continue;
            if (this.trim) {
                value = value.trim();
            }
            String oldValue = value;
            int recursionLevel = 0;
            while (!(value = this.processText(oldValue)).equals(oldValue)) {
                oldValue = value;
                if (++recursionLevel <= 10) continue;
            }
            String valueL = Matcher.quoteReplacement(value);
            m.appendReplacement(sb, valueL);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public String processText(InputStream in) throws IOException {
        String text = IOUtils.toString((InputStream)in, (String)"UTF-8");
        return this.processText(text);
    }

    public void processText(InputStream is, OutputStream os) throws IOException {
        String text = IOUtils.toString((InputStream)is, (String)"UTF-8");
        text = this.processText(text);
        os.write(text.getBytes("UTF-8"));
    }

    public void initFreeMarker() {
        this.freemarkerConfiguration = new Configuration();
        this.freemarkerConfiguration.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        this.freemarkerVars = new HashMap<String, Object>();
        Enumeration<?> processedEnum = this.processedVars.propertyNames();
        while (processedEnum.hasMoreElements()) {
            String key = (String)processedEnum.nextElement();
            String value = this.processedVars.getProperty(key);
            String[] keyparts = key.split("\\.");
            Map currentMap = this.freemarkerVars;
            String currentString = "";
            boolean setKeyVal = true;
            for (int i = 0; i < keyparts.length - 1; ++i) {
                currentString = currentString + (currentString.equals("") ? "" : ".") + keyparts[i];
                if (!currentMap.containsKey(keyparts[i])) {
                    HashMap<String, Object> nextMap = new HashMap<String, Object>();
                    currentMap.put((String)keyparts[i], nextMap);
                    currentMap = nextMap;
                    continue;
                }
                if (currentMap.get(keyparts[i]) instanceof Map) {
                    currentMap = (Map)currentMap.get(keyparts[i]);
                    continue;
                }
                if (!key.startsWith("java.vendor")) {
                    log.warn((Object)("Freemarker templates: " + currentString + " is already defined - " + key + " will not be available in the data model."));
                }
                setKeyVal = false;
                break;
            }
            if (!setKeyVal) continue;
            currentMap.put((String)keyparts[keyparts.length - 1], (Object)value);
        }
    }

    public void processFreemarker(File in, File out) throws IOException, TemplateException {
        if (this.freemarkerConfiguration == null) {
            this.initFreeMarker();
        }
        this.freemarkerConfiguration.setDirectoryForTemplateLoading(in.getParentFile());
        Template nxtpl = this.freemarkerConfiguration.getTemplate(in.getName());
        FileWriter outWriter = new FileWriter(out);
        nxtpl.process(this.freemarkerVars, (Writer)outWriter);
        ((Writer)outWriter).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDirectory(File in, File out) throws FileNotFoundException, IOException, TemplateException {
        block16: {
            String freemarkerExtension;
            boolean processAsFreemarker;
            boolean processAsText;
            block18: {
                block17: {
                    if (!in.isFile()) break block16;
                    if (out.isDirectory()) {
                        out = new File(out, in.getName());
                    }
                    if (!out.getParentFile().exists()) {
                        out.getParentFile().mkdirs();
                    }
                    processAsText = false;
                    processAsFreemarker = false;
                    freemarkerExtension = null;
                    if (this.extensionsContainsDot) break block17;
                    int extIndex = in.getName().lastIndexOf(46);
                    String extension = extIndex == -1 ? "" : in.getName().substring(extIndex + 1).toLowerCase();
                    boolean bl = processAsText = this.plainTextExtensions == null || this.plainTextExtensions.contains(extension);
                    if (!this.freemarkerExtensions.contains(extension)) break block18;
                    processAsFreemarker = true;
                    freemarkerExtension = extension;
                    break block18;
                }
                String filename = in.getName().toLowerCase();
                for (String ext : this.plainTextExtensions) {
                    if (!filename.endsWith(ext)) continue;
                    processAsText = true;
                    processAsFreemarker = false;
                    freemarkerExtension = ext;
                    break;
                }
                for (String ext : this.freemarkerExtensions) {
                    if (!filename.endsWith(ext)) continue;
                    processAsText = false;
                    processAsFreemarker = true;
                    break;
                }
            }
            FileInputStream is = null;
            FileOutputStream os = null;
            try {
                if (processAsText) {
                    os = new FileOutputStream(out);
                    is = new FileInputStream(in);
                    this.processText(is, os);
                }
                if (processAsFreemarker) {
                    out = new File(out.getCanonicalPath().replaceAll("\\.*" + Pattern.quote(freemarkerExtension) + "$", ""));
                    this.processFreemarker(in, out);
                }
                os = new FileOutputStream(out);
                is = new FileInputStream(in);
                IOUtils.copy((InputStream)is, (OutputStream)os);
            }
            finally {
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
            }
        }
        if (in.isDirectory()) {
            if (!out.exists()) {
                out.mkdirs();
            } else if (!out.getName().equals(in.getName())) {
                out = new File(out, in.getName());
                out.mkdir();
            }
            for (File file : in.listFiles()) {
                this.processDirectory(file, out);
            }
        }
    }

    public void setTextParsingExtensions(String extensionsList) {
        StringTokenizer st = new StringTokenizer(extensionsList, ",");
        this.plainTextExtensions = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String extension = st.nextToken();
            this.plainTextExtensions.add(extension);
            if (this.extensionsContainsDot || !extension.contains(".")) continue;
            this.extensionsContainsDot = true;
        }
    }

    public void setFreemarkerParsingExtensions(String extensionsList) {
        StringTokenizer st = new StringTokenizer(extensionsList, ",");
        this.freemarkerExtensions = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String extension = st.nextToken();
            this.freemarkerExtensions.add(extension);
            if (this.extensionsContainsDot || !extension.contains(".")) continue;
            this.extensionsContainsDot = true;
        }
    }
}

