/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.cudf.metadata;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class Version
implements Comparable {
    private final int major;
    private static final String SEPARATOR = ".";
    public static final Version emptyVersion = new Version(0, 0, 0);
    public static final Version maxVersion = new Version(Integer.MAX_VALUE);

    public Version(int major) {
        this.major = major;
    }

    public Version(int major, int minor, int micro) {
        this(major, minor, micro, null);
    }

    public Version(int major, int minor, int micro, String qualifier) {
        if (qualifier == null) {
            qualifier = "";
        }
        this.major = major;
    }

    public Version(String version) {
        int maj = 0;
        int min = 0;
        int mic = 0;
        String qual = "";
        try {
            StringTokenizer st = new StringTokenizer(version, SEPARATOR, true);
            maj = Integer.parseInt(st.nextToken());
            if (st.hasMoreTokens()) {
                st.nextToken();
                min = Integer.parseInt(st.nextToken());
                if (st.hasMoreTokens()) {
                    st.nextToken();
                    mic = Integer.parseInt(st.nextToken());
                    if (st.hasMoreTokens()) {
                        st.nextToken();
                        qual = st.nextToken();
                        if (st.hasMoreTokens()) {
                            throw new IllegalArgumentException("invalid format");
                        }
                    }
                }
            }
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("invalid format");
        }
        this.major = maj;
    }

    public static Version parseVersion(String version) {
        if (version == null) {
            return emptyVersion;
        }
        if ((version = version.trim()).length() == 0) {
            return emptyVersion;
        }
        return new Version(version);
    }

    public int getMajor() {
        return this.major;
    }

    public String toString() {
        return Integer.toString(this.major);
    }

    public int hashCode() {
        return this.major << 24;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Version)) {
            return false;
        }
        Version other = (Version)object;
        return this.major == other.major;
    }

    public int compareTo(Object object) {
        if (object == this) {
            return 0;
        }
        Version other = (Version)object;
        return this.major - other.major;
    }
}

