/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.cudf.solver;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.cudf.Log;
import org.eclipse.equinox.p2.cudf.metadata.IRequiredCapability;
import org.eclipse.equinox.p2.cudf.metadata.InstallableUnit;
import org.eclipse.equinox.p2.cudf.metadata.RequiredCapability;
import org.eclipse.equinox.p2.cudf.metadata.VersionRange;
import org.eclipse.equinox.p2.cudf.query.CapabilityQuery;
import org.eclipse.equinox.p2.cudf.query.Collector;
import org.eclipse.equinox.p2.cudf.query.QueryableArray;
import org.eclipse.equinox.p2.cudf.solver.Messages;
import org.eclipse.equinox.p2.cudf.solver.TwoTierMap;
import org.eclipse.osgi.util.NLS;

public class Slicer {
    private static boolean TIMING = false;
    private QueryableArray possibilites;
    private LinkedList toProcess;
    private Set considered;
    private TwoTierMap slice;
    private MultiStatus result;

    public Slicer(QueryableArray input) {
        this.possibilites = input;
        this.slice = new TwoTierMap();
        this.result = new MultiStatus("org.eclipse.equinox.p2.cudf", 0, Messages.Planner_Problems_resolving_plan, null);
    }

    private void handleExtraRequirements(List extraRequirements) {
        if (extraRequirements != null) {
            Iterator iterator = extraRequirements.iterator();
            while (iterator.hasNext()) {
                this.expandRequirement(null, (IRequiredCapability)iterator.next());
            }
        }
    }

    public QueryableArray slice(InstallableUnit ius, List extraRequirements) {
        try {
            NullProgressMonitor monitor = new NullProgressMonitor();
            long start = 0L;
            if (TIMING) {
                start = System.currentTimeMillis();
            }
            this.considered = new HashSet(this.possibilites.getSize());
            this.considered.add(ius);
            this.toProcess = new LinkedList(this.considered);
            this.handleExtraRequirements(extraRequirements);
            while (!this.toProcess.isEmpty()) {
                if (monitor.isCanceled()) {
                    this.result.merge(Status.CANCEL_STATUS);
                    throw new OperationCanceledException();
                }
                this.processIU((InstallableUnit)this.toProcess.removeFirst());
            }
            if (TIMING) {
                long stop = System.currentTimeMillis();
                Log.println("# Slicing complete: " + (stop - start));
            }
        }
        catch (IllegalStateException e) {
            this.result.add((IStatus)new Status(4, "org.eclipse.equinox.p2.cudf", e.getMessage(), (Throwable)e));
        }
        if (this.result.getSeverity() == 4) {
            return null;
        }
        return new QueryableArray(this.considered.toArray(new InstallableUnit[this.considered.size()]));
    }

    public MultiStatus getStatus() {
        return this.result;
    }

    protected void processIU(InstallableUnit iu) {
        this.slice.put(iu.getId(), iu.getVersion(), iu);
        this.addHighestVersion(iu);
        IRequiredCapability[] reqs = this.getRequiredCapabilities(iu);
        if (reqs.length == 0) {
            return;
        }
        for (int i = 0; i < reqs.length; ++i) {
            this.expandRequirement(iu, reqs[i]);
        }
    }

    private void addHighestVersion(InstallableUnit iu) {
        Collector matches = this.possibilites.query(new CapabilityQuery(new RequiredCapability(iu.getId(), VersionRange.emptyRange, 1)), new Collector(), null);
        if (matches.size() == 1 || matches.size() == 0) {
            return;
        }
        InstallableUnit highestVersion = iu;
        Iterator iterator = matches.iterator();
        while (iterator.hasNext()) {
            InstallableUnit candidate = (InstallableUnit)iterator.next();
            if (!candidate.getId().equals(iu.getId()) || candidate.getVersion().getMajor() <= highestVersion.getVersion().getMajor()) continue;
            highestVersion = candidate;
        }
        if (highestVersion != iu) {
            this.considered.add(highestVersion);
        }
    }

    private IRequiredCapability[] getRequiredCapabilities(InstallableUnit iu) {
        return iu.getRequiredCapabilities();
    }

    private void expandRequirement(InstallableUnit iu, IRequiredCapability req) {
        if (req.isNegation()) {
            return;
        }
        Collector matches = this.possibilites.query(new CapabilityQuery(req), new Collector(), null);
        int validMatches = 0;
        Iterator iterator = matches.iterator();
        while (iterator.hasNext()) {
            InstallableUnit match = (InstallableUnit)iterator.next();
            ++validMatches;
            if (this.slice.containsKey(match.getId(), match.getVersion())) continue;
            this.consider(match);
        }
        if (validMatches == 0) {
            if (req.isOptional()) {
                if (TIMING) {
                    Log.println("No IU found to satisfy optional dependency of " + iu + " on req " + req);
                }
            } else {
                this.result.add((IStatus)new Status(2, "org.eclipse.equinox.p2.cudf", NLS.bind(Messages.Planner_Unsatisfied_dependency, iu, req)));
            }
        }
    }

    private void consider(InstallableUnit match) {
        if (this.considered.add(match)) {
            this.toProcess.addLast(match);
        }
    }
}

