/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.cudf.solver;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.equinox.p2.cudf.metadata.InstallableUnit;
import org.eclipse.equinox.p2.cudf.solver.OptimizationFunction;

public class TrendyOptimizationFunction
extends OptimizationFunction {
    private static final Log log = LogFactory.getLog(TrendyOptimizationFunction.class);

    @Override
    public List createOptimizationFunction(InstallableUnit metaIu) {
        ArrayList weightedObjects = new ArrayList();
        BigInteger weight = BigInteger.valueOf(this.slice.size() + 1);
        this.removed(weightedObjects, weight.multiply(weight).multiply(weight), metaIu);
        this.notuptodate(weightedObjects, weight.multiply(weight), metaIu);
        this.optional(weightedObjects, weight, metaIu);
        this.niou(weightedObjects, BigInteger.ONE, metaIu);
        if (!weightedObjects.isEmpty()) {
            return weightedObjects;
        }
        return null;
    }

    @Override
    public String getName() {
        return "misc 2010, trendy";
    }

    @Override
    public void printSolutionValue() {
        Object var2;
        int i;
        int removed = 0;
        int notUpToDate = 0;
        int recommends = 0;
        int niou = 0;
        ArrayList<String> proof = new ArrayList<String>();
        for (i = 0; i < this.removalVariables.size(); ++i) {
            var2 = this.removalVariables.get(i);
            if (!this.dependencyHelper.getBooleanValueFor(var2)) continue;
            ++removed;
            proof.add(var2.toString().substring(18));
        }
        log.info((Object)("# Removed packages: " + proof));
        proof.clear();
        for (i = 0; i < this.nouptodateVariables.size(); ++i) {
            var2 = this.nouptodateVariables.get(i);
            if (!this.dependencyHelper.getBooleanValueFor(var2)) continue;
            ++notUpToDate;
            proof.add(var2.toString().substring(18));
        }
        log.info((Object)("# Not up-to-date packages: " + proof));
        proof.clear();
        for (Object var2 : this.unmetVariables) {
            if (!this.dependencyHelper.getBooleanValueFor(var2)) continue;
            ++recommends;
            proof.add(var2.toString().substring(18));
        }
        log.info((Object)("# Not installed recommended packages: " + proof));
        proof.clear();
        for (int i2 = 0; i2 < this.newVariables.size(); ++i2) {
            var2 = this.newVariables.get(i2);
            if (!this.dependencyHelper.getBooleanValueFor(var2)) continue;
            ++niou;
            proof.add(var2.toString().substring(18));
        }
        log.info((Object)("# Newly installed packages: " + proof));
        proof.clear();
        log.info((Object)("# Trendy criteria value: -" + removed + ", -" + notUpToDate + ", -" + recommends + ", -" + niou));
    }
}

