/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.cudf.solver;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.equinox.p2.cudf.Options;
import org.eclipse.equinox.p2.cudf.metadata.InstallableUnit;
import org.eclipse.equinox.p2.cudf.solver.OptimizationFunction;
import org.sat4j.pb.tools.WeightedObject;
import org.sat4j.specs.IVec;

public class UserDefinedOptimizationFunction
extends OptimizationFunction {
    private static final Log log = LogFactory.getLog(UserDefinedOptimizationFunction.class);
    private String optfunction;

    public UserDefinedOptimizationFunction(String optfunction) {
        this.optfunction = optfunction;
    }

    @Override
    public List createOptimizationFunction(InstallableUnit metaIu) {
        ArrayList weightedObjects = new ArrayList();
        ArrayList<Object> objects = new ArrayList<Object>();
        BigInteger weight = BigInteger.valueOf(this.slice.size() + 1);
        String[] criteria = this.optfunction.split(",");
        BigInteger currentWeight = weight.pow(criteria.length - 1);
        int formermaxvarid = this.dependencyHelper.getSolver().nextFreeVarId(false);
        for (int i = 0; i < criteria.length; ++i) {
            if (criteria[i].endsWith("new")) {
                weightedObjects.clear();
                this.niou(weightedObjects, criteria[i].startsWith("+") ? currentWeight.negate() : currentWeight, metaIu);
                currentWeight = currentWeight.divide(weight);
            } else if (criteria[i].endsWith("removed")) {
                weightedObjects.clear();
                this.removed(weightedObjects, criteria[i].startsWith("+") ? currentWeight.negate() : currentWeight, metaIu);
                currentWeight = currentWeight.divide(weight);
            } else if (criteria[i].endsWith("notuptodate")) {
                weightedObjects.clear();
                this.notuptodate(weightedObjects, criteria[i].startsWith("+") ? currentWeight.negate() : currentWeight, metaIu);
                currentWeight = currentWeight.divide(weight);
            } else if (criteria[i].endsWith("unsat_recommends")) {
                weightedObjects.clear();
                this.optional(weightedObjects, criteria[i].startsWith("+") ? currentWeight.negate() : currentWeight, metaIu);
                currentWeight = currentWeight.divide(weight);
            } else if (criteria[i].endsWith("versionchanged")) {
                weightedObjects.clear();
                this.versionChanged(weightedObjects, criteria[i].startsWith("+") ? currentWeight.negate() : currentWeight, metaIu);
            } else if (criteria[i].endsWith("changed")) {
                weightedObjects.clear();
                this.changed(weightedObjects, criteria[i].startsWith("+") ? currentWeight.negate() : currentWeight, metaIu);
                currentWeight = currentWeight.divide(weight);
            } else {
                if (criteria[i].contains("sum")) {
                    weightedObjects.clear();
                    this.sum(weightedObjects, criteria[i].charAt(0) == '-', metaIu, Options.extractSumProperty(criteria[i]));
                    this.dependencyHelper.addWeightedCriterion(weightedObjects);
                    log.info((Object)("# criteria " + criteria[i].substring(1) + " size is " + weightedObjects.size()));
                    continue;
                }
                log.info((Object)("Skipping unknown criteria:" + criteria[i]));
            }
            objects.clear();
            boolean maximizes = criteria[i].startsWith("+");
            Iterator it = weightedObjects.iterator();
            while (it.hasNext()) {
                Object thing = ((WeightedObject)it.next()).thing;
                if (maximizes) {
                    thing = this.dependencyHelper.not(thing);
                }
                objects.add(thing);
            }
            this.dependencyHelper.addCriterion(objects);
            int newmaxvarid = this.dependencyHelper.getSolver().nextFreeVarId(false);
            log.info((Object)("# criteria " + criteria[i].substring(1) + " size is " + objects.size() + " using new vars " + formermaxvarid + " to " + newmaxvarid));
            formermaxvarid = newmaxvarid;
        }
        weightedObjects.clear();
        return null;
    }

    @Override
    public String getName() {
        return "User defined:" + this.optfunction;
    }

    @Override
    public void printSolutionValue() {
        ArrayList<String> proof = new ArrayList<String>();
        String[] criteria = this.optfunction.split(",");
        for (int i = 0; i < criteria.length; ++i) {
            int counter;
            if (criteria[i].endsWith("new")) {
                proof.clear();
                counter = 0;
                for (int j = 0; j < this.newVariables.size(); ++j) {
                    Object var = this.newVariables.get(j);
                    if (!this.dependencyHelper.getBooleanValueFor(var)) continue;
                    ++counter;
                    proof.add(var.toString().substring(18));
                }
                log.info((Object)("# " + criteria[i] + " criteria value: " + counter));
                log.info((Object)("# Newly installed packages: " + proof));
                continue;
            }
            if (criteria[i].endsWith("removed")) {
                proof.clear();
                counter = 0;
                for (int j = 0; j < this.removalVariables.size(); ++j) {
                    Object var = this.removalVariables.get(j);
                    if (!this.dependencyHelper.getBooleanValueFor(var)) continue;
                    ++counter;
                    proof.add(var.toString().substring(18));
                }
                log.info((Object)("# " + criteria[i] + " criteria value: " + counter));
                log.info((Object)("# Removed packages: " + proof));
                continue;
            }
            if (criteria[i].endsWith("notuptodate")) {
                proof.clear();
                counter = 0;
                for (int j = 0; j < this.nouptodateVariables.size(); ++j) {
                    Object var = this.nouptodateVariables.get(j);
                    if (!this.dependencyHelper.getBooleanValueFor(var)) continue;
                    ++counter;
                    proof.add(var.toString().substring(18));
                }
                log.info((Object)("# " + criteria[i] + " criteria value: " + counter));
                log.info((Object)("# Not up-to-date packages: " + proof));
                continue;
            }
            if (criteria[i].endsWith("recommended") || criteria[i].endsWith("unsat_recommends")) {
                proof.clear();
                counter = 0;
                for (Object var : this.unmetVariables) {
                    if (!this.dependencyHelper.getBooleanValueFor(var)) continue;
                    ++counter;
                    proof.add(var.toString().substring(18));
                }
                log.info((Object)("# " + criteria[i] + " criteria value: " + counter));
                log.info((Object)("# Not installed recommended packages: " + proof));
                continue;
            }
            if (criteria[i].endsWith("versionchanged")) {
                proof.clear();
                counter = 0;
                for (int j = 0; j < this.versionChangeVariables.size(); ++j) {
                    Object var = this.versionChangeVariables.get(j);
                    if (!this.dependencyHelper.getBooleanValueFor(var)) continue;
                    ++counter;
                    proof.add(var.toString().substring(18));
                }
                log.info((Object)("# " + criteria[i] + " criteria value: " + counter));
                log.info((Object)("# Packages with version change: " + proof));
                continue;
            }
            if (criteria[i].endsWith("changed")) {
                proof.clear();
                counter = 0;
                for (int j = 0; j < this.changeVariables.size(); ++j) {
                    Object var = this.changeVariables.get(j);
                    if (!this.dependencyHelper.getBooleanValueFor(var)) continue;
                    ++counter;
                    proof.add(var.toString().substring(18));
                }
                log.info((Object)("# " + criteria[i] + " criteria value: " + counter));
                log.info((Object)("# Changed packages: " + proof));
                continue;
            }
            if (!criteria[i].contains("sum")) continue;
            String sumpProperty = Options.extractSumProperty(criteria[i]);
            long sum = 0L;
            IVec sol = this.dependencyHelper.getSolution();
            for (Object element : sol) {
                if (!(element instanceof InstallableUnit)) continue;
                InstallableUnit iu = (InstallableUnit)element;
                sum += iu.getSumProperty();
            }
            log.info((Object)("# " + criteria[i] + " criteria value: " + sum));
        }
    }
}

