/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authn;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.commons.collections.map.LRUMap;
import org.apache.directory.server.core.authn.AbstractAuthenticator;
import org.apache.directory.server.core.authn.LdapPrincipal;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.invocation.Invocation;
import org.apache.directory.server.core.invocation.InvocationStack;
import org.apache.directory.server.core.jndi.ServerContext;
import org.apache.directory.server.core.partition.PartitionNexusProxy;
import org.apache.directory.shared.ldap.aci.AuthenticationLevel;
import org.apache.directory.shared.ldap.exception.LdapAuthenticationException;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.ArrayUtils;
import org.apache.directory.shared.ldap.util.Base64;
import org.apache.directory.shared.ldap.util.StringTools;
import org.apache.directory.shared.ldap.util.UnixCrypt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleAuthenticator
extends AbstractAuthenticator {
    private static final Logger log = LoggerFactory.getLogger(SimpleAuthenticator.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();
    private LRUMap credentialCache;
    private static final int DEFAULT_CACHE_SIZE = 100;
    private static final Collection<String> USERLOOKUP_BYPASS;

    public SimpleAuthenticator() {
        super("simple");
        this.credentialCache = new LRUMap(100);
    }

    public SimpleAuthenticator(int cacheSize) {
        super("simple");
        this.credentialCache = new LRUMap(cacheSize > 0 ? cacheSize : 100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LdapPrincipal getStoredPassword(LdapDN principalDN) throws NamingException {
        LdapPrincipal principal = null;
        String principalNorm = principalDN.getNormName();
        LRUMap lRUMap = this.credentialCache;
        synchronized (lRUMap) {
            principal = (LdapPrincipal)this.credentialCache.get((Object)principalNorm);
        }
        byte[] storedPassword = null;
        if (principal == null) {
            storedPassword = this.lookupUserPassword(principalDN);
            if (storedPassword == null) {
                storedPassword = ArrayUtils.EMPTY_BYTE_ARRAY;
            }
            principal = new LdapPrincipal(principalDN, AuthenticationLevel.SIMPLE, storedPassword);
            LRUMap lRUMap2 = this.credentialCache;
            synchronized (lRUMap2) {
                this.credentialCache.put((Object)principalDN.getNormName(), (Object)principal);
            }
        } else {
            storedPassword = principal.getUserPassword();
        }
        return principal;
    }

    private byte[] getCredentials(ServerContext ctx, LdapDN principalDn) throws LdapAuthenticationException {
        Object creds = ctx.getEnvironment().get("java.naming.security.credentials");
        byte[] credentials = null;
        if (creds == null) {
            credentials = ArrayUtils.EMPTY_BYTE_ARRAY;
        } else if (creds instanceof String) {
            credentials = StringTools.getBytesUtf8((String)((String)creds));
        } else if (creds instanceof byte[]) {
            credentials = (byte[])creds;
        } else {
            log.info("Incorrect credentials stored in {}", (Object)"java.naming.security.credentials");
            throw new LdapAuthenticationException();
        }
        return credentials;
    }

    public LdapPrincipal authenticate(LdapDN principalDn, ServerContext ctx) throws NamingException {
        LdapPrincipal principal;
        byte[] storedPassword;
        byte[] credentials;
        if (IS_DEBUG) {
            log.debug("Authenticating {}", (Object)principalDn);
        }
        if (Arrays.equals(credentials = this.getCredentials(ctx, principalDn), storedPassword = (principal = this.getStoredPassword(principalDn)).getUserPassword())) {
            if (IS_DEBUG) {
                log.debug("{} Authenticated", (Object)principalDn);
            }
            return principal;
        }
        String algorithm = this.findAlgorithm(storedPassword);
        if (algorithm != null) {
            EncryptionMethod encryptionMethod = new EncryptionMethod(algorithm, null);
            byte[] encryptedStored = this.splitCredentials(storedPassword, encryptionMethod);
            byte[] userPassword = this.encryptPassword(credentials, encryptionMethod);
            if (Arrays.equals(userPassword, encryptedStored)) {
                if (IS_DEBUG) {
                    log.debug("{} Authenticated", (Object)principalDn);
                }
                return principal;
            }
            String message = "Password not correct for user '" + principalDn.getUpName() + "'";
            log.info(message);
            throw new LdapAuthenticationException(message);
        }
        String message = "Password not correct for user '" + principalDn.getUpName() + "'";
        log.info(message);
        throw new LdapAuthenticationException(message);
    }

    private static void split(byte[] all, int offset, byte[] left, byte[] right) {
        System.arraycopy(all, offset, left, 0, left.length);
        System.arraycopy(all, offset + left.length, right, 0, right.length);
    }

    private byte[] splitCredentials(byte[] credentials, EncryptionMethod encryptionMethod) {
        String algorithm = encryptionMethod.algorithm;
        int pos = algorithm.length() + 2;
        if ("md5".equals(algorithm) || "sha".equals(algorithm)) {
            try {
                return Base64.decode((char[])new String(credentials, pos, credentials.length - pos, "UTF-8").toCharArray());
            }
            catch (UnsupportedEncodingException uee) {
                return credentials;
            }
        }
        if ("smd5".equals(algorithm) || "ssha".equals(algorithm)) {
            try {
                byte[] passwordAndSalt = Base64.decode((char[])new String(credentials, pos, credentials.length - pos, "UTF-8").toCharArray());
                EncryptionMethod.access$202(encryptionMethod, new byte[8]);
                byte[] password = new byte[passwordAndSalt.length - encryptionMethod.salt.length];
                SimpleAuthenticator.split(passwordAndSalt, 0, password, encryptionMethod.salt);
                return password;
            }
            catch (UnsupportedEncodingException uee) {
                return credentials;
            }
        }
        if ("crypt".equals(algorithm)) {
            EncryptionMethod.access$202(encryptionMethod, new byte[2]);
            byte[] password = new byte[credentials.length - encryptionMethod.salt.length - pos];
            SimpleAuthenticator.split(credentials, pos, encryptionMethod.salt, password);
            return password;
        }
        return credentials;
    }

    private String findAlgorithm(byte[] credentials) {
        if (credentials == null || credentials.length == 0) {
            return null;
        }
        if (credentials[0] == 123) {
            int pos;
            for (pos = 1; pos < credentials.length && credentials[pos] != 125; ++pos) {
            }
            if (pos < credentials.length) {
                if (pos == 1) {
                    return null;
                }
                String algorithm = new String(credentials, 1, pos - 1).toLowerCase();
                if ("md5".equals(algorithm) || "sha".equals(algorithm) || "smd5".equals(algorithm) || "ssha".equals(algorithm) || "crypt".equals(algorithm)) {
                    return algorithm;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    private static byte[] digest(String algorithm, byte[] password, byte[] salt) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e1) {
            return null;
        }
        if (salt != null) {
            digest.update(password);
            digest.update(salt);
            return digest.digest();
        }
        return digest.digest(password);
    }

    private byte[] encryptPassword(byte[] credentials, EncryptionMethod encryptionMethod) {
        String algorithm = encryptionMethod.algorithm;
        byte[] salt = encryptionMethod.salt;
        if ("sha".equals(algorithm) || "ssha".equals(algorithm)) {
            return SimpleAuthenticator.digest("sha", credentials, salt);
        }
        if ("md5".equals(algorithm) || "smd5".equals(algorithm)) {
            return SimpleAuthenticator.digest("md5", credentials, salt);
        }
        if ("crypt".equals(algorithm)) {
            if (salt == null) {
                salt = new byte[2];
                SecureRandom sr = new SecureRandom();
                int i1 = sr.nextInt(64);
                int i2 = sr.nextInt(64);
                salt[0] = (byte)(i1 < 12 ? i1 + 46 : (i1 < 38 ? i1 + 65 - 12 : i1 + 97 - 38));
                salt[1] = (byte)(i2 < 12 ? i2 + 46 : (i2 < 38 ? i2 + 65 - 12 : i2 + 97 - 38));
            }
            String saltWithCrypted = UnixCrypt.crypt((String)StringTools.utf8ToString((byte[])credentials), (String)StringTools.utf8ToString((byte[])salt));
            String crypted = saltWithCrypted.substring(2);
            return StringTools.getBytesUtf8((String)crypted);
        }
        return credentials;
    }

    private byte[] lookupUserPassword(LdapDN principalDn) throws NamingException {
        Object userPassword;
        Attributes userEntry;
        Invocation invocation = InvocationStack.getInstance().peek();
        PartitionNexusProxy proxy = invocation.getProxy();
        try {
            LookupOperationContext lookupContex = new LookupOperationContext(new String[]{"userPassword"});
            lookupContex.setDn(principalDn);
            userEntry = proxy.lookup(lookupContex, USERLOOKUP_BYPASS);
            if (userEntry == null) {
                throw new LdapAuthenticationException("Failed to lookup user for authentication: " + principalDn);
            }
        }
        catch (Exception cause) {
            log.error("Authentication error : " + cause.getMessage());
            LdapAuthenticationException e = new LdapAuthenticationException();
            e.setRootCause((Throwable)e);
            throw e;
        }
        Attribute userPasswordAttr = userEntry.get("userPassword");
        if (userPasswordAttr == null) {
            userPassword = ArrayUtils.EMPTY_BYTE_ARRAY;
        } else {
            userPassword = userPasswordAttr.get();
            if (userPassword instanceof String) {
                userPassword = StringTools.getBytesUtf8((String)((String)userPassword));
            }
        }
        return userPassword;
    }

    protected String getAlgorithmForHashedPassword(byte[] password) throws IllegalArgumentException {
        String result = null;
        String sPassword = StringTools.utf8ToString((byte[])password);
        int rightParen = sPassword.indexOf(125);
        if (sPassword != null && sPassword.length() > 2 && sPassword.charAt(0) == '{' && rightParen > -1) {
            String algorithm = sPassword.substring(1, rightParen);
            if ("crypt".equals(algorithm)) {
                return algorithm;
            }
            try {
                MessageDigest.getInstance(algorithm);
                result = algorithm;
            }
            catch (NoSuchAlgorithmException e) {
                log.warn("Unknown message digest algorithm in password: " + algorithm, (Throwable)e);
            }
        }
        return result;
    }

    protected String createDigestedPassword(String algorithm, byte[] password) throws IllegalArgumentException {
        try {
            if ("crypt".equalsIgnoreCase(algorithm)) {
                String saltWithCrypted = UnixCrypt.crypt((String)StringTools.utf8ToString((byte[])password), (String)"");
                String crypted = saltWithCrypted.substring(2);
                return '{' + algorithm + '}' + StringTools.getBytesUtf8((String)crypted);
            }
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            byte[] fingerPrint = digest.digest(password);
            char[] encoded = Base64.encode((byte[])fingerPrint);
            return '{' + algorithm + '}' + new String(encoded);
        }
        catch (NoSuchAlgorithmException nsae) {
            log.error("Cannot create a digested password for algorithm '{}'", (Object)algorithm);
            throw new IllegalArgumentException(nsae.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateCache(LdapDN bindDn) {
        LRUMap lRUMap = this.credentialCache;
        synchronized (lRUMap) {
            this.credentialCache.remove((Object)bindDn.getNormName());
        }
    }

    static {
        HashSet<String> c = new HashSet<String>();
        c.add("normalizationService");
        c.add("authenticationService");
        c.add("referralService");
        c.add("authorizationService");
        c.add("defaultAuthorizationService");
        c.add("exceptionService");
        c.add("operationalAttributeService");
        c.add("schemaService");
        c.add("subentryService");
        c.add("collectiveAttributeService");
        c.add("eventService");
        c.add("triggerService");
        USERLOOKUP_BYPASS = Collections.unmodifiableCollection(c);
    }

    private class EncryptionMethod {
        private byte[] salt;
        private String algorithm;

        private EncryptionMethod(String algorithm, byte[] salt) {
            this.algorithm = algorithm;
            this.salt = salt;
        }

        static /* synthetic */ byte[] access$202(EncryptionMethod x0, byte[] x1) {
            x0.salt = x1;
            return x1;
        }
    }
}

