/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.Serializable;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.SimpleTypeImpl;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.primitives.BinaryType;
import org.nuxeo.ecm.core.schema.types.primitives.BooleanType;
import org.nuxeo.ecm.core.schema.types.primitives.DateType;
import org.nuxeo.ecm.core.schema.types.primitives.DoubleType;
import org.nuxeo.ecm.core.schema.types.primitives.IntegerType;
import org.nuxeo.ecm.core.schema.types.primitives.LongType;
import org.nuxeo.ecm.core.schema.types.primitives.StringType;
import org.nuxeo.ecm.core.storage.sql.ColumnSpec;

public class ColumnType
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int CLOB_LENGTH = 999999999;
    public static final ColumnType STRING = new ColumnType(ColumnSpec.STRING);
    public static final ColumnType CLOB = new ColumnType(ColumnSpec.STRING, 999999999);
    public static final ColumnType BOOLEAN = new ColumnType(ColumnSpec.BOOLEAN);
    public static final ColumnType LONG = new ColumnType(ColumnSpec.LONG);
    public static final ColumnType DOUBLE = new ColumnType(ColumnSpec.DOUBLE);
    public static final ColumnType TIMESTAMP = new ColumnType(ColumnSpec.TIMESTAMP);
    public static final ColumnType BLOBID = new ColumnType(ColumnSpec.BLOBID);
    public static final ColumnType NODEID = new ColumnType(ColumnSpec.NODEID);
    public static final ColumnType NODEIDFK = new ColumnType(ColumnSpec.NODEIDFK);
    public static final ColumnType NODEIDFKNP = new ColumnType(ColumnSpec.NODEIDFKNP);
    public static final ColumnType NODEIDFKMUL = new ColumnType(ColumnSpec.NODEIDFKMUL);
    public static final ColumnType NODEIDFKNULL = new ColumnType(ColumnSpec.NODEIDFKNULL);
    public static final ColumnType NODEIDPK = new ColumnType(ColumnSpec.NODEIDPK);
    public static final ColumnType NODEVAL = new ColumnType(ColumnSpec.NODEVAL);
    public static final ColumnType NODEARRAY = new ColumnType(ColumnSpec.NODEARRAY);
    public static final ColumnType SYSNAME = new ColumnType(ColumnSpec.SYSNAME);
    public static final ColumnType SYSNAMEARRAY = new ColumnType(ColumnSpec.SYSNAMEARRAY);
    public static final ColumnType TINYINT = new ColumnType(ColumnSpec.TINYINT);
    public static final ColumnType INTEGER = new ColumnType(ColumnSpec.INTEGER);
    public static final ColumnType AUTOINC = new ColumnType(ColumnSpec.AUTOINC);
    public static final ColumnType FTINDEXED = new ColumnType(ColumnSpec.FTINDEXED);
    public static final ColumnType FTSTORED = new ColumnType(ColumnSpec.FTSTORED);
    public static final ColumnType CLUSTERNODE = new ColumnType(ColumnSpec.CLUSTERNODE);
    public static final ColumnType CLUSTERFRAGS = new ColumnType(ColumnSpec.CLUSTERFRAGS);
    public final ColumnSpec spec;
    public final int length;

    public ColumnType(ColumnSpec spec, int length) {
        this.spec = spec;
        this.length = length;
    }

    public ColumnType(ColumnSpec spec) {
        this(spec, -1);
    }

    public boolean isUnconstrained() {
        return this.length == -1;
    }

    public boolean isClob() {
        return this.length == 999999999;
    }

    public String toString() {
        if (this.isUnconstrained()) {
            return this.spec.toString();
        }
        if (this.isClob()) {
            return "CLOB";
        }
        return this.spec.toString() + '(' + this.length + ')';
    }

    public static ColumnType fromField(Field field) {
        return ColumnType.fromFieldType(field.getType(), field.getMaxLength());
    }

    public static ColumnType fromFieldType(Type type) {
        return ColumnType.fromFieldType(type, -1);
    }

    protected static ColumnType fromFieldType(Type type, int maxLength) {
        if (type instanceof StringType) {
            if (maxLength == -1) {
                return STRING;
            }
            return new ColumnType(ColumnSpec.STRING, maxLength);
        }
        if (type instanceof BooleanType) {
            return BOOLEAN;
        }
        if (type instanceof LongType) {
            return LONG;
        }
        if (type instanceof DoubleType) {
            return DOUBLE;
        }
        if (type instanceof DateType) {
            return TIMESTAMP;
        }
        if (type instanceof BinaryType) {
            return BLOBID;
        }
        if (type instanceof IntegerType) {
            return INTEGER;
        }
        if (type instanceof SimpleTypeImpl) {
            return ColumnType.fromFieldType(type.getSuperType(), maxLength);
        }
        throw new RuntimeException("Invalid primitive type: " + type.getClass().getName());
    }
}

