/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wss.handlers.fprpc;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.wss.WSSException;
import org.nuxeo.wss.fprpc.FPRPCCall;
import org.nuxeo.wss.fprpc.FPRPCRequest;
import org.nuxeo.wss.fprpc.FPRPCResponse;
import org.nuxeo.wss.handlers.fprpc.AbstractFPRPCHandler;
import org.nuxeo.wss.handlers.fprpc.FPRPCHandler;
import org.nuxeo.wss.spi.WSSBackend;
import org.nuxeo.wss.url.WSSUrlMapper;
import org.nuxeo.wss.url.WSSUrlMapping;

public class SHtmlHandler
extends AbstractFPRPCHandler
implements FPRPCHandler {
    private static final Log log = LogFactory.getLog(SHtmlHandler.class);

    @Override
    protected void processCall(FPRPCRequest request, FPRPCResponse fpResponse, int callIndex, WSSBackend backend) throws WSSException {
        FPRPCCall call = request.getCalls().get(callIndex);
        log.debug((Object)("Handling FP SHtml call on method " + call.getMethodName()));
        if ("server version".equals(call.getMethodName())) {
            fpResponse.addRenderingParameter("request", request);
            fpResponse.setRenderingTemplateName("server-version.ftl");
        } else if ("url to web url".equals(call.getMethodName())) {
            String askedUrl = call.getParameters().get("url");
            WSSUrlMapping mapping = WSSUrlMapper.getWebMapping(request, askedUrl);
            String webUrl = mapping.getSiteUrl();
            String fileUrl = mapping.getResourceUrl();
            fpResponse.addRenderingParameter("request", request);
            fpResponse.addRenderingParameter("webUrl", webUrl);
            fpResponse.addRenderingParameter("fileUrl", fileUrl);
            fpResponse.setRenderingTemplateName("url-to-web-url.ftl");
        }
    }
}

