/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.directory;

import java.io.Serializable;
import java.util.Comparator;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.platform.ui.web.directory.DirectorySelectItem;

public class DirectorySelectItemComparator
implements Comparator<DirectorySelectItem>,
Serializable {
    private static final long serialVersionUID = 1869118968287728886L;
    private final String[] ordering;
    private Boolean caseSentitive;

    public DirectorySelectItemComparator(String ordering, Boolean caseSentitive) {
        this.caseSentitive = caseSentitive;
        this.ordering = StringUtils.split((String)ordering, (String)",");
    }

    public DirectorySelectItemComparator(String ordering) {
        this(ordering, false);
    }

    protected int compareField(String field, DirectorySelectItem item1, DirectorySelectItem item2) {
        String v2;
        String v1 = (String)item1.getValue();
        if (!v1.equals(v2 = (String)item2.getValue())) {
            if (v1.length() == 0) {
                return -1;
            }
            if (v2.length() == 0) {
                return 1;
            }
        }
        if (field.equals("label")) {
            String str2;
            String str1 = StringUtils.isBlank((String)item1.getLocalizedLabel()) ? item1.getLabel() : item1.getLocalizedLabel();
            String string = str2 = StringUtils.isBlank((String)item1.getLocalizedLabel()) ? item2.getLabel() : item2.getLocalizedLabel();
            if (this.caseSentitive.booleanValue()) {
                return str1.compareTo(str2);
            }
            return str1.toLowerCase().compareTo(str2.toLowerCase());
        }
        if (field.equals("id")) {
            return ((String)item1.getValue()).compareTo((String)item2.getValue());
        }
        if (field.equals("ordering")) {
            long orderItem1 = item1.getOrdering();
            long orderItem2 = item2.getOrdering();
            return Long.valueOf(orderItem1).compareTo(orderItem2);
        }
        throw new RuntimeException("invalid sort criteria");
    }

    @Override
    public int compare(DirectorySelectItem item1, DirectorySelectItem item2) {
        for (String field : this.ordering) {
            int compare = this.compareField(field, item1, item2);
            if (compare == 0) continue;
            return compare;
        }
        return 0;
    }
}

