/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.ldap;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.DirectoryFactory;
import org.nuxeo.ecm.directory.DirectoryServiceImpl;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.directory.ldap.LDAPDirectoryDescriptor;
import org.nuxeo.ecm.directory.ldap.LDAPServerDescriptor;
import org.nuxeo.ecm.directory.ldap.registry.LDAPDirectoryRegistry;
import org.nuxeo.ecm.directory.ldap.registry.LDAPServerRegistry;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.Extension;

public class LDAPDirectoryFactory
extends DefaultComponent
implements DirectoryFactory {
    public static final String NAME = "org.nuxeo.ecm.directory.ldap.LDAPDirectoryFactory";
    private static final Log log = LogFactory.getLog(LDAPDirectoryFactory.class);
    protected LDAPDirectoryRegistry proxies;
    protected LDAPServerRegistry servers;

    public Directory getDirectory(String name) {
        return this.proxies.getDirectory(name);
    }

    public List<Directory> getDirectories() {
        ArrayList<Directory> directories = new ArrayList<Directory>();
        directories.addAll(this.proxies.getDirectories());
        return directories;
    }

    public LDAPServerDescriptor getServer(String name) {
        return this.servers.getServer(name);
    }

    public String getName() {
        return NAME;
    }

    public void activate(ComponentContext context) {
        log.info((Object)"component activated");
        this.proxies = new LDAPDirectoryRegistry();
        this.servers = new LDAPServerRegistry();
    }

    public void deactivate(ComponentContext context) {
        log.info((Object)"component deactivated");
        this.proxies = null;
        this.servers = null;
    }

    protected static DirectoryServiceImpl getDirectoryService() {
        return (DirectoryServiceImpl)Framework.getLocalService(DirectoryService.class);
    }

    public void registerExtension(Extension extension) {
        String xp = extension.getExtensionPoint();
        if (xp.equals("directories")) {
            this.registerDirectoryExtension(extension);
        } else if (xp.equals("servers")) {
            this.registerServerExtension(extension);
        }
    }

    public void unregisterExtension(Extension extension) throws DirectoryException {
        String xp = extension.getExtensionPoint();
        if (xp.equals("directories")) {
            this.unregisterDirectoryExtension(extension);
        } else if (xp.equals("servers")) {
            this.unregisterServerExtension(extension);
        }
    }

    public void registerServerExtension(Extension extension) {
        Object[] contribs;
        for (Object contrib : contribs = extension.getContributions()) {
            LDAPServerDescriptor descriptor = (LDAPServerDescriptor)contrib;
            this.servers.addContribution(descriptor);
        }
    }

    public void unregisterServerExtension(Extension extension) {
        Object[] contribs;
        for (Object contrib : contribs = extension.getContributions()) {
            LDAPServerDescriptor descriptor = (LDAPServerDescriptor)contrib;
            this.servers.removeContribution(descriptor);
        }
    }

    public void registerDirectoryExtension(Extension extension) {
        Object[] contribs = extension.getContributions();
        DirectoryServiceImpl dirService = LDAPDirectoryFactory.getDirectoryService();
        for (Object contrib : contribs) {
            LDAPDirectoryDescriptor descriptor = (LDAPDirectoryDescriptor)contrib;
            this.proxies.addContribution(descriptor);
            dirService.registerDirectory(descriptor.getName(), (DirectoryFactory)this);
        }
    }

    public void unregisterDirectoryExtension(Extension extension) throws DirectoryException {
        Object[] contribs = extension.getContributions();
        DirectoryServiceImpl dirService = LDAPDirectoryFactory.getDirectoryService();
        for (Object contrib : contribs) {
            LDAPDirectoryDescriptor descriptor = (LDAPDirectoryDescriptor)contrib;
            this.proxies.removeContribution(descriptor);
            dirService.unregisterDirectory(descriptor.getName(), (DirectoryFactory)this);
        }
    }

    public void shutdown() throws DirectoryException {
        for (Directory directory : this.proxies.getDirectories()) {
            directory.shutdown();
        }
    }
}

