/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.filter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class ProxyHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    public static final String FORWARDED_HOST_HEADER = "X-Forwarded-Host";
    public static final String FORWARDED_PROTO_HEADER = "X-Forwarded-Proto";
    public static final String HTTPS_SCHEME = "https";
    public static final String HTTP_SCHEME = "http";
    private String scheme;
    private String serverName;
    private int serverPort;

    public ProxyHttpServletRequestWrapper(HttpServletRequest request) {
        super(request);
        this.scheme = request.getHeader(FORWARDED_PROTO_HEADER);
        if (!HTTP_SCHEME.equalsIgnoreCase(this.scheme) && !HTTPS_SCHEME.equalsIgnoreCase(this.scheme)) {
            this.scheme = request.getScheme();
        }
        this.serverName = request.getServerName();
        this.serverPort = request.getServerPort();
        String host = request.getHeader(FORWARDED_HOST_HEADER);
        if (host != null && host.length() > 0) {
            int index = host.indexOf(58);
            if (index < 0) {
                this.serverName = host;
                this.serverPort = this.getDefaultPort(this.scheme);
            } else {
                this.serverName = host.substring(0, index);
                try {
                    this.serverPort = Integer.parseInt(host.substring(index + 1));
                }
                catch (NumberFormatException e) {
                    this.serverPort = this.getDefaultPort(this.scheme);
                }
            }
        }
    }

    private int getDefaultPort(String scheme) {
        if (HTTPS_SCHEME.equalsIgnoreCase(scheme)) {
            return 443;
        }
        return 80;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }
}

