/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp.states;

import com.hp.hpl.jena.rdf.arp.impl.ANode;
import com.hp.hpl.jena.rdf.arp.impl.ARPResource;
import com.hp.hpl.jena.rdf.arp.impl.AbsXMLContext;
import com.hp.hpl.jena.rdf.arp.impl.AttributeLexer;
import com.hp.hpl.jena.rdf.arp.impl.ElementLexer;
import com.hp.hpl.jena.rdf.arp.impl.TaintImpl;
import com.hp.hpl.jena.rdf.arp.impl.URIReference;
import com.hp.hpl.jena.rdf.arp.states.DAMLCollection;
import com.hp.hpl.jena.rdf.arp.states.Frame;
import com.hp.hpl.jena.rdf.arp.states.FrameI;
import com.hp.hpl.jena.rdf.arp.states.HasSubjectFrameI;
import com.hp.hpl.jena.rdf.arp.states.OuterXMLLiteral;
import com.hp.hpl.jena.rdf.arp.states.RDFCollection;
import com.hp.hpl.jena.rdf.arp.states.WantEmpty;
import com.hp.hpl.jena.rdf.arp.states.WantLiteralValueOrDescription;
import com.hp.hpl.jena.rdf.arp.states.WantTopLevelDescription;
import com.hp.hpl.jena.rdf.arp.states.WantTypedLiteral;
import com.hp.hpl.jena.rdf.arp.states.WantsObjectFrameI;
import java.util.ArrayList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;

public class WantPropertyElement
extends Frame
implements WantsObjectFrameI,
HasSubjectFrameI {
    int liCounter = 1;
    ANode predicate;
    ANode object;
    ANode reify;
    boolean objectIsBlank = false;
    private static final int TYPEDLITERAL = 1;
    private static final int EMPTYWITHOBJ = 2;
    private static final int PARSETYPE = 4;
    private static URIReference[] _rdf_n = new URIReference[0];

    public WantPropertyElement(HasSubjectFrameI s, AbsXMLContext x) {
        super((FrameI)s, x);
    }

    public FrameI startElement(String uri, String localName, String rawName, Attributes atts) throws SAXParseException {
        int cnt;
        AttributeLexer ap;
        this.clearObject();
        if (this.nonWhiteMsgGiven) {
            this.taint.isTainted();
        }
        this.nonWhiteMsgGiven = false;
        if (uri == null || uri.equals("")) {
            this.warning(104, "Unqualified property elements are not allowed. Treated as a relative URI.");
        }
        ElementLexer el = new ElementLexer(this.taint, this, uri, localName, rawName, 2048, 30200, false);
        ANode aNode = this.predicate = el.goodMatch ? WantPropertyElement.rdf_n(this.liCounter++) : URIReference.fromQName(this, uri, localName);
        if (this.taint.isTainted()) {
            this.predicate.taint();
        }
        this.taint = new TaintImpl();
        int nextStateCode = (ap.datatype == null ? 0 : 1) | (ap.parseType == null ? 0 : 4) | (this.mustBeEmpty(ap = new AttributeLexer(this, 1007, 32248), atts, cnt = ap.processSpecials(this.taint, atts)) ? 2 : 0);
        if (this.badStateCode(nextStateCode)) {
            this.warning(this.errorNumber(nextStateCode), this.descriptionOfCases(ap, nextStateCode, this.propertyAttributeDescription(atts, ap, cnt)));
        }
        AbsXMLContext x = ap.xml(this.xml);
        ANode aNode2 = this.reify = ap.id == null ? null : URIReference.fromID(this, x, ap.id);
        if (this.taint.isTainted()) {
            this.predicate.taint();
        }
        if (this.mustBeEmpty(ap, atts, cnt)) {
            if (ap.nodeID != null) {
                this.object = new ARPResource(this.arp, ap.nodeID);
                this.checkXMLName(this.object, ap.nodeID);
                this.objectIsBlank = true;
            }
            if (ap.resource != null) {
                if (this.object != null) {
                    if (!this.badStateCode(nextStateCode)) {
                        this.warning(201, "On a property element, only one of the attributes rdf:nodeID or rdf:resource is permitted.");
                    }
                } else {
                    this.object = URIReference.resolve(this, x, ap.resource);
                }
            }
            if (this.object == null) {
                this.object = new ARPResource(this.arp);
                this.objectIsBlank = true;
            }
            if (this.taint.isTainted()) {
                this.object.taint();
            }
            this.processPropertyAttributes(ap, atts, x);
        }
        FrameI nextFrame = this.nextFrame(atts, ap, cnt, nextStateCode, x);
        if (this.object != null) {
            if (this.taint.isTainted()) {
                this.object.taint();
            }
            this.theObject(this.object);
        }
        if (this.taint.isTainted()) {
            this.predicate.taint();
        }
        return nextFrame;
    }

    private boolean mustBeEmpty(AttributeLexer ap, Attributes atts, int cnt) {
        return cnt < atts.getLength() || ap.type != null || ap.nodeID != null || ap.resource != null;
    }

    private FrameI nextFrame(Attributes atts, AttributeLexer ap, int cnt, int nextStateCode, AbsXMLContext x) throws SAXParseException {
        switch (nextStateCode) {
            case 0: {
                return new WantLiteralValueOrDescription(this, x);
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return this.withParsetype(ap.parseType, x);
            }
            case 1: 
            case 3: {
                return new WantTypedLiteral(this, ap.datatype, x);
            }
            case 2: {
                return new WantEmpty((FrameI)this, x);
            }
        }
        throw new IllegalStateException("impossible");
    }

    private FrameI withParsetype(String pt, AbsXMLContext x) throws SAXParseException {
        if (pt.equals("Collection")) {
            return new RDFCollection(this, x);
        }
        if (pt.equals("daml:collection") && !this.arp.isError(125)) {
            this.warning(4, "'daml:collection' is not really a legal value for rdf:parseType");
            return new DAMLCollection(this, x);
        }
        if (pt.equals("Resource")) {
            if (this.object == null) {
                this.object = new ARPResource(this.arp);
                this.objectIsBlank = true;
            }
            return new WantPropertyElement(this, x);
        }
        if (!pt.equals("Literal")) {
            this.warning(106, "Unknown rdf:parseType: '" + pt + "' (treated as 'Literal'.");
        }
        return new OuterXMLLiteral(this, x, pt);
    }

    String suggestParsetypeLiteral() {
        return this.getParent() instanceof WantTopLevelDescription ? "" : super.suggestParsetypeLiteral();
    }

    public void aPredAndObj(ANode p, ANode o) {
        this.triple(this.object, p, o);
    }

    public void makeSubjectReificationWith(ANode r) {
        this.triple(r, RDF_SUBJECT, this.object);
    }

    public void theObject(ANode o) {
        HasSubjectFrameI p = (HasSubjectFrameI)this.getParent();
        p.aPredAndObj(this.predicate, o);
        if (this.reify != null) {
            this.triple(this.reify, RDF_TYPE, RDF_STATEMENT);
            this.triple(this.reify, RDF_OBJECT, o);
            this.triple(this.reify, RDF_PREDICATE, this.predicate);
            p.makeSubjectReificationWith(this.reify);
        }
    }

    public void endElement() {
        this.clearObject();
    }

    public void abort() {
        this.clearObject();
    }

    private void clearObject() {
        if (this.objectIsBlank) {
            this.arp.endLocalScope(this.object);
        }
        this.objectIsBlank = false;
        this.object = null;
    }

    private static URIReference rdf_n(int i) {
        if (i >= _rdf_n.length) {
            int newLength = (i + 10) * 3 / 2;
            URIReference[] new_rdf_n = new URIReference[newLength];
            System.arraycopy(_rdf_n, 0, new_rdf_n, 0, _rdf_n.length);
            for (int j = _rdf_n.length; j < newLength; ++j) {
                new_rdf_n[j] = URIReference.createNoChecks(rdfns + "_" + j);
            }
            _rdf_n = new_rdf_n;
        }
        return _rdf_n[i];
    }

    private boolean badStateCode(int nextStateCode) {
        switch (nextStateCode) {
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                return false;
            }
        }
        throw new IllegalStateException("impossible");
    }

    private int errorNumber(int nextStateCode) {
        return 201;
    }

    private String descriptionOfCases(AttributeLexer ap, int nextStateCode, String propAttrs) {
        return propAttrs == null && ap.type == null || ap.nodeID == null && ap.resource == null && ap.type == null || ap.nodeID == null && ap.resource == null && propAttrs == null ? this.pairwiseIncompatibleErrorMessage(nextStateCode, ap, propAttrs) : this.complicatedErrorMessage(nextStateCode, ap, propAttrs);
    }

    private String pairwiseIncompatibleErrorMessage(int nextStateCode, AttributeLexer ap, String propAttrs) {
        ArrayList<String> cases = new ArrayList<String>();
        if ((nextStateCode & 4) != 0) {
            cases.add("rdf:parseType");
        }
        if ((nextStateCode & 1) != 0) {
            cases.add("rdf:datatype");
        }
        if (ap.nodeID != null) {
            cases.add("rdf:nodeID");
        }
        if (ap.resource != null) {
            cases.add("rdf:resource");
        }
        if (ap.type != null) {
            cases.add("rdf:type");
        }
        if (cases.size() == 1) {
            if (propAttrs == null) {
                throw new IllegalStateException("Shouldn't happen.");
            }
            return "The attribute " + (String)cases.get(0) + " is not permitted with " + propAttrs + " on a property element.";
        }
        String rslt = "On a property element, only one of the ";
        if (propAttrs == null) {
            rslt = rslt + "attributes ";
        }
        block4: for (int i = 0; i < cases.size(); ++i) {
            rslt = rslt + (String)cases.get(i);
            switch (cases.size() - i) {
                case 1: {
                    continue block4;
                }
                case 2: {
                    rslt = rslt + " or ";
                    continue block4;
                }
                default: {
                    rslt = rslt + ", ";
                }
            }
        }
        if (propAttrs != null) {
            rslt = rslt + " attributes or " + propAttrs;
        }
        rslt = rslt + " is permitted.";
        return rslt;
    }

    private String complicatedErrorMessage(int nextStateCode, AttributeLexer ap, String propAttrs) {
        String otherAtts;
        int otherAttCount;
        String subjectIs;
        if (ap.nodeID == null && ap.resource == null && (ap.type == null || propAttrs == null)) {
            throw new IllegalStateException("precondition failed.");
        }
        switch (nextStateCode & 5) {
            case 5: {
                subjectIs = "the mutually incompatible attributes rdf:datatype and rdf:parseType are";
                break;
            }
            case 1: {
                subjectIs = "the attribute rdf:datatype is";
                break;
            }
            case 4: {
                subjectIs = "the attribute rdf:parseType is";
                break;
            }
            default: {
                throw new IllegalStateException("precondition failed");
            }
        }
        String nodeIDResource = null;
        if (ap.nodeID != null && ap.resource != null) {
            nodeIDResource = "the mutually incompatible attributes rdf:nodeID and rdf:resource";
        } else if (ap.nodeID != null) {
            nodeIDResource = "the attribute rdf:nodeID";
        } else if (ap.resource != null) {
            nodeIDResource = "the attribute rdf:resource";
        }
        int n = otherAttCount = nodeIDResource == null ? 0 : 1;
        if (ap.type != null) {
            ++otherAttCount;
        }
        if (propAttrs != null) {
            ++otherAttCount;
        }
        if (otherAttCount < 2) {
            throw new IllegalStateException("logic error");
        }
        String string = otherAtts = otherAttCount == 2 ? "both " : "each of ";
        otherAtts = ap.type != null && propAttrs != null ? (nodeIDResource == null ? otherAtts + "the attribute rdf:type and the " + propAttrs : otherAtts + "the attribute rdf:type, the " + propAttrs) : (ap.type != null ? otherAtts + "the attribute rdf:type" : "the " + propAttrs);
        if (nodeIDResource != null) {
            otherAtts = otherAtts + " and " + nodeIDResource;
        }
        return "On a property element, " + subjectIs + " incompatible with " + otherAtts + ".";
    }

    private String propertyAttributeDescription(Attributes atts, AttributeLexer ap, int cnt) {
        String propAttrs = "";
        int propAttrCount = atts.getLength() - cnt;
        int found = 0;
        if (propAttrCount == 0) {
            return null;
        }
        switch (propAttrCount) {
            case 0: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                block12: for (int i = 0; i < atts.getLength(); ++i) {
                    if (ap.done(i)) continue;
                    propAttrs = propAttrs + atts.getQName(i);
                    switch (propAttrCount - ++found) {
                        case 0: {
                            continue block12;
                        }
                        case 1: {
                            propAttrs = propAttrs + " and ";
                            continue block12;
                        }
                        default: {
                            propAttrs = propAttrs + ", ";
                        }
                    }
                }
                break;
            }
            default: {
                if (propAttrCount < 0) {
                    throw new IllegalStateException("Shouldn't happen.");
                }
                block13: for (int i = 0; i < atts.getLength(); ++i) {
                    if (ap.done(i)) continue;
                    switch (++found) {
                        case 1: {
                            propAttrs = propAttrs + atts.getQName(i) + ", ";
                            continue block13;
                        }
                        case 2: {
                            propAttrs = propAttrs + atts.getQName(i) + ", ...";
                            continue block13;
                        }
                    }
                }
            }
        }
        return "property attributes (" + propAttrs + ")";
    }
}

