/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.web;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.convert.Converter;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.web.RequestParameter;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Events;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.common.collections.ScopedMap;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.platform.routing.api.DocumentRoute;
import org.nuxeo.ecm.platform.routing.api.DocumentRouteElement;
import org.nuxeo.ecm.platform.routing.api.DocumentRouteTableElement;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingConstants;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.ecm.platform.routing.api.LockableDocumentRoute;
import org.nuxeo.ecm.platform.routing.api.exception.DocumentRouteAlredayLockedException;
import org.nuxeo.ecm.platform.routing.api.exception.DocumentRouteNotLockedException;
import org.nuxeo.ecm.platform.routing.core.api.DocumentRoutingEngineService;
import org.nuxeo.ecm.platform.routing.core.impl.GraphRoute;
import org.nuxeo.ecm.platform.routing.web.DocumentModelConvertor;
import org.nuxeo.ecm.platform.routing.web.RelatedRouteActionBean;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.task.TaskService;
import org.nuxeo.ecm.platform.types.Type;
import org.nuxeo.ecm.platform.types.TypeManager;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.api.WebActions;
import org.nuxeo.ecm.platform.ui.web.model.SelectDataModel;
import org.nuxeo.ecm.platform.ui.web.model.impl.SelectDataModelImpl;
import org.nuxeo.ecm.webapp.action.TypesTool;
import org.nuxeo.ecm.webapp.documentsLists.DocumentsListsManager;
import org.nuxeo.ecm.webapp.edit.lock.LockActions;
import org.nuxeo.ecm.webapp.helpers.EventManager;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;
import org.nuxeo.runtime.api.Framework;

@Scope(value=ScopeType.CONVERSATION)
@Name(value="routingActions")
@Install(precedence=10)
public class DocumentRoutingActionsBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(DocumentRoutingActionsBean.class);
    public static final String SOURCE_DOC_NAME = "source_doc_name";
    public static final String ROUTE_DOCUMENT_REF = "route_doc_ref";
    @In(required=true, create=true)
    protected NavigationContext navigationContext;
    @In(create=true, required=false)
    protected CoreSession documentManager;
    @In(create=true, required=false)
    protected FacesMessages facesMessages;
    @In(create=true)
    protected WebActions webActions;
    @In(create=true)
    protected LockActions lockActions;
    @In(create=true, required=false)
    protected TypesTool typesTool;
    @In(create=true)
    protected ResourcesAccessor resourcesAccessor;
    @In(create=true)
    protected TypeManager typeManager;
    @In(create=true)
    protected EventManager eventManager;
    @In(required=true, create=true)
    protected NuxeoPrincipal currentUser;
    @In(create=true)
    protected List<DocumentModel> relatedRoutes;
    @In(create=true)
    protected RelatedRouteActionBean relatedRouteAction;
    @In(create=true)
    protected DocumentsListsManager documentsListsManager;
    @RequestParameter(value="stepId")
    protected String stepId;
    protected String relatedRouteModelDocumentId;
    protected String docWithAttachedRouteId;
    protected String hiddenSourceDocId;
    protected String hiddenDocOrder;

    public DocumentRoutingService getDocumentRoutingService() {
        try {
            return (DocumentRoutingService)Framework.getService(DocumentRoutingService.class);
        }
        catch (Exception e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Observer(value={"documentChanged", "documentSelectionChanged"})
    public void resetRelatedRouteDocumentId() {
        this.relatedRouteModelDocumentId = null;
    }

    public boolean isRoutable() {
        return this.getDocumentRoutingService().isRoutable(this.navigationContext.getCurrentDocument());
    }

    public String startRoute() throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        DocumentRoute currentRoute = (DocumentRoute)currentDocument.getAdapter(DocumentRoute.class);
        this.getDocumentRoutingService().createNewInstance(currentDocument.getId(), currentRoute.getAttachedDocuments(), this.documentManager, true);
        Events.instance().raiseEvent("documentChildrenChanged", new Object[]{currentDocument});
        Events.instance().raiseEvent("workflowNewProcessStarted", new Object[0]);
        this.webActions.resetTabList();
        return null;
    }

    public DocumentRoute getRelatedRoute() {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        if (currentDocument.hasFacet("DocumentRoute")) {
            this.docWithAttachedRouteId = null;
            return (DocumentRoute)currentDocument.getAdapter(DocumentRoute.class);
        }
        DocumentRouteElement relatedRouteElement = (DocumentRouteElement)currentDocument.getAdapter(DocumentRouteElement.class);
        if (relatedRouteElement != null) {
            this.docWithAttachedRouteId = null;
            return relatedRouteElement.getDocumentRoute(this.documentManager);
        }
        try {
            this.relatedRoutes = this.relatedRouteAction.findRelatedRoute();
            if (this.relatedRoutes.size() <= 0) {
                return null;
            }
            this.docWithAttachedRouteId = currentDocument.getId();
            DocumentModel docRoute = this.relatedRoutes.get(0);
            return (DocumentRoute)docRoute.getAdapter(DocumentRoute.class);
        }
        catch (ClientException e) {
            return null;
        }
    }

    public String cancelRoute() throws ClientException {
        DocumentModel doc = this.relatedRoutes.get(0);
        DocumentRoute route = (DocumentRoute)doc.getAdapter(DocumentRoute.class);
        ((DocumentRoutingEngineService)Framework.getLocalService(DocumentRoutingEngineService.class)).cancel(route, this.documentManager);
        this.webActions.resetTabList();
        Events.instance().raiseEvent("workflowProcessCanceled", new Object[0]);
        Contexts.removeFromAllContexts((String)"relatedRoutes");
        this.documentManager.save();
        return this.navigationContext.navigateToDocument(this.navigationContext.getCurrentDocument());
    }

    public void saveRouteAsNewInstance() {
        this.getDocumentRoutingService().saveRouteAsNewModel(this.getRelatedRoute(), this.documentManager);
        Events.instance().raiseEvent("documentChildrenChanged", new Object[0]);
        this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("feedback.casemanagement.document.route.route_duplicated"), new Object[0]);
    }

    public void saveSelectedRouteAsNewInstance() {
        List docs = this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
        if (!docs.isEmpty()) {
            for (DocumentModel doc : docs) {
                DocumentRoute route = (DocumentRoute)doc.getAdapter(DocumentRoute.class);
                if (route == null) continue;
                this.getDocumentRoutingService().saveRouteAsNewModel(route, this.documentManager);
            }
        }
        Events.instance().raiseEvent("documentChildrenChanged", new Object[0]);
        this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("feedback.casemanagement.document.route.selected_route_duplicated"), new Object[0]);
    }

    public boolean getCanDuplicateRouteInstance() {
        List docs = this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
        if (docs.isEmpty()) {
            return false;
        }
        for (DocumentModel doc : docs) {
            if (doc.hasFacet("DocumentRoute")) continue;
            return false;
        }
        return true;
    }

    public String validateRouteModel() throws ClientException {
        DocumentRoute currentRouteModel = this.getRelatedRoute();
        try {
            this.getDocumentRoutingService().validateRouteModel(currentRouteModel, this.documentManager);
        }
        catch (DocumentRouteNotLockedException e) {
            this.facesMessages.add(StatusMessage.Severity.WARN, (String)this.resourcesAccessor.getMessages().get("feedback.casemanagement.document.route.not.locked"), new Object[0]);
            return null;
        }
        Events.instance().raiseEvent("documentChildrenChanged", new Object[]{currentRouteModel.getDocument()});
        this.getDocumentRoutingService().unlockDocumentRouteUnrestrictedSession(currentRouteModel, this.documentManager);
        return null;
    }

    protected List<DocumentRouteTableElement> computeRouteElements() throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        DocumentRoute currentRoute = (DocumentRoute)currentDocument.getAdapter(DocumentRoute.class);
        return this.getElements(currentRoute);
    }

    protected List<DocumentRouteTableElement> computeRelatedRouteElements() throws ClientException {
        if (this.relatedRoutes.isEmpty()) {
            return new ArrayList<DocumentRouteTableElement>();
        }
        DocumentModel relatedRouteDocumentModel = this.documentManager.getDocument((DocumentRef)new IdRef(this.relatedRoutes.get(0).getId()));
        DocumentRoute currentRoute = (DocumentRoute)relatedRouteDocumentModel.getAdapter(DocumentRoute.class);
        return this.getElements(currentRoute);
    }

    protected List<DocumentRouteTableElement> getElements(DocumentRoute currentRoute) {
        return this.getDocumentRoutingService().getRouteElements(currentRoute, this.documentManager);
    }

    @Factory(value="routeElementsSelectModel", scope=ScopeType.EVENT)
    public SelectDataModel computeSelectDataModelRouteElements() throws ClientException {
        return new SelectDataModelImpl("dm_route_elements", this.computeRouteElements(), null);
    }

    @Factory(value="relatedRouteElementsSelectModel", scope=ScopeType.EVENT)
    public SelectDataModel computeSelectDataModelRelatedRouteElements() throws ClientException {
        return new SelectDataModelImpl("related_route_elements", this.computeRelatedRouteElements(), null);
    }

    public SelectDataModel computeSelectDataModelRouteElements(DocumentModel relatedRouteDocumentModel) throws ClientException {
        DocumentRoute currentRoute = (DocumentRoute)relatedRouteDocumentModel.getAdapter(DocumentRoute.class);
        return new SelectDataModelImpl("related_route_elements", this.getElements(currentRoute), null);
    }

    public boolean hasRelatedRoute() throws ClientException {
        if (this.relatedRoutes == null) {
            this.relatedRoutes = this.relatedRouteAction.findRelatedRoute();
        }
        return !this.relatedRoutes.isEmpty();
    }

    public String startRouteRelatedToCurrentDocument() throws ClientException {
        DocumentRoute route = this.getRelatedRoute();
        if (!StringUtils.isEmpty((String)this.relatedRouteModelDocumentId)) {
            DocumentModel model = this.documentManager.getDocument((DocumentRef)new IdRef(this.relatedRouteModelDocumentId));
            route = (DocumentRoute)model.getAdapter(DocumentRoute.class);
        }
        if (route == null) {
            this.facesMessages.add(StatusMessage.Severity.WARN, (String)this.resourcesAccessor.getMessages().get("feedback.casemanagement.document.route.no.valid.route"), new Object[0]);
            return null;
        }
        ArrayList<String> documentIds = new ArrayList<String>();
        documentIds.add(this.navigationContext.getCurrentDocument().getId());
        route.setAttachedDocuments(documentIds);
        this.getDocumentRoutingService().createNewInstance(route.getDocument().getName(), documentIds, this.documentManager, true);
        Events.instance().raiseEvent("workflowNewProcessStarted", new Object[0]);
        this.webActions.resetTabList();
        return null;
    }

    public boolean routeRelatedToCurrentDocumentIsRunning() throws ClientException {
        DocumentRoute route = this.getRelatedRoute();
        if (route == null) {
            return false;
        }
        return route.isRunning();
    }

    public String getTypeDescription(DocumentRouteTableElement localizable) {
        return this.depthFormatter(localizable.getDepth(), localizable.getElement().getDocument().getType());
    }

    private String depthFormatter(int depth, String type) {
        StringBuilder depthFormatter = new StringBuilder();
        for (int i = 0; i < depth - 1; ++i) {
            depthFormatter.append("__");
        }
        depthFormatter.append(type);
        return depthFormatter.toString();
    }

    public Converter getDocumentModelConverter() {
        return new DocumentModelConvertor(this.documentManager);
    }

    public boolean isStep(DocumentModel doc) {
        return doc.hasFacet("RouteStep");
    }

    public boolean currentRouteModelIsDraft() {
        DocumentModel relatedRouteModel = this.navigationContext.getCurrentDocument();
        DocumentRoute routeModel = (DocumentRoute)relatedRouteModel.getAdapter(DocumentRoute.class);
        if (routeModel == null) {
            return false;
        }
        return routeModel.isDraft();
    }

    public String removeStep() throws ClientException {
        boolean alreadyLockedByCurrentUser = false;
        DocumentRoute routeModel = this.getRelatedRoute();
        if (this.getDocumentRoutingService().isLockedByCurrentUser(routeModel, this.documentManager)) {
            alreadyLockedByCurrentUser = true;
        } else if (this.lockRoute(routeModel) == null) {
            return null;
        }
        if (StringUtils.isEmpty((String)this.stepId)) {
            return null;
        }
        IdRef docRef = new IdRef(this.stepId);
        DocumentModel stepToDelete = this.documentManager.getDocument((DocumentRef)docRef);
        try {
            this.getDocumentRoutingService().removeRouteElement((DocumentRouteElement)stepToDelete.getAdapter(DocumentRouteElement.class), this.documentManager);
        }
        catch (DocumentRouteNotLockedException e) {
            this.facesMessages.add(StatusMessage.Severity.WARN, (String)this.resourcesAccessor.getMessages().get("feedback.casemanagement.document.route.not.locked"), new Object[0]);
            return null;
        }
        Contexts.removeFromAllContexts((String)"relatedRoutes");
        Events.instance().raiseEvent("documentChildrenChanged", new Object[]{routeModel.getDocument()});
        if (!alreadyLockedByCurrentUser) {
            this.getDocumentRoutingService().unlockDocumentRoute(routeModel, this.documentManager);
        }
        return null;
    }

    public boolean isEditableStep(DocumentModel stepDoc) throws ClientException {
        DocumentRouteElement stepElement = (DocumentRouteElement)stepDoc.getAdapter(DocumentRouteElement.class);
        if (stepDoc.hasFacet("Folderish")) {
            return false;
        }
        return stepElement.isModifiable();
    }

    public boolean isEditableRouteElement(DocumentModel stepDoc) throws ClientException {
        DocumentRouteElement stepElement = (DocumentRouteElement)stepDoc.getAdapter(DocumentRouteElement.class);
        return stepElement.isModifiable();
    }

    @Factory(value="currentRouteLockedByCurrentUser", scope=ScopeType.EVENT)
    public boolean isCurrentRouteLockedByCurrentUser() throws ClientException {
        return this.getDocumentRoutingService().isLockedByCurrentUser(this.getRelatedRoute(), this.documentManager);
    }

    public boolean isCurrentRouteLocked() throws ClientException {
        LockableDocumentRoute lockableRoute = (LockableDocumentRoute)this.getRelatedRoute().getDocument().getAdapter(LockableDocumentRoute.class);
        return lockableRoute.isLocked(this.documentManager);
    }

    public boolean canUnlockRoute() throws ClientException {
        return Boolean.TRUE.equals(this.lockActions.getCanUnlockDoc(this.getRelatedRoute().getDocument()));
    }

    public boolean canLockRoute() throws ClientException {
        return Boolean.TRUE.equals(this.lockActions.getCanLockDoc(this.getRelatedRoute().getDocument()));
    }

    public Map<String, Serializable> getCurrentRouteLockDetails() throws ClientException {
        return this.lockActions.getLockDetails(this.getRelatedRoute().getDocument());
    }

    public String lockCurrentRoute() throws ClientException {
        DocumentRoute docRouteElement = this.getRelatedRoute();
        return this.lockRoute(docRouteElement);
    }

    protected String lockRoute(DocumentRoute docRouteElement) throws ClientException {
        try {
            this.getDocumentRoutingService().lockDocumentRoute(docRouteElement.getDocumentRoute(this.documentManager), this.documentManager);
        }
        catch (DocumentRouteAlredayLockedException e) {
            this.facesMessages.add(StatusMessage.Severity.WARN, (String)this.resourcesAccessor.getMessages().get("feedback.casemanagement.document.route.already.locked"), new Object[0]);
            return null;
        }
        return null;
    }

    public String unlockCurrentRoute() throws ClientException {
        DocumentRoute route = this.getRelatedRoute();
        this.getDocumentRoutingService().unlockDocumentRoute(route, this.documentManager);
        return null;
    }

    public boolean isEmptyFork(DocumentModel forkDoc) throws ClientException {
        return forkDoc.hasFacet("Folderish") && !this.documentManager.hasChildren(forkDoc.getRef());
    }

    public String editStep() throws ClientException {
        if (StringUtils.isEmpty((String)this.stepId)) {
            return null;
        }
        IdRef stepRef = new IdRef(this.stepId);
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        if (currentDoc.getAdapter(DocumentRoute.class) == null) {
            this.setDocWithAttachedRouteId(currentDoc.getId());
        }
        return this.navigationContext.navigateToDocument(this.documentManager.getDocument((DocumentRef)stepRef), "edit");
    }

    public String updateRouteElement() throws ClientException {
        boolean alreadyLockedByCurrentUser = false;
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        DocumentRouteElement docRouteElement = (DocumentRouteElement)currentDocument.getAdapter(DocumentRouteElement.class);
        DocumentRoute route = docRouteElement.getDocumentRoute(this.documentManager);
        if (this.getDocumentRoutingService().isLockedByCurrentUser(route, this.documentManager)) {
            alreadyLockedByCurrentUser = true;
        } else if (this.lockRoute(route) == null) {
            return null;
        }
        try {
            this.getDocumentRoutingService().updateRouteElement(docRouteElement, this.documentManager);
        }
        catch (DocumentRouteNotLockedException e) {
            this.facesMessages.add(StatusMessage.Severity.WARN, (String)this.resourcesAccessor.getMessages().get("feedback.casemanagement.document.route.already.locked"), new Object[0]);
            return null;
        }
        this.navigationContext.invalidateCurrentDocument();
        this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("document_modified"), new Object[]{this.resourcesAccessor.getMessages().get(currentDocument.getType())});
        EventManager.raiseEventsOnDocumentChange((DocumentModel)currentDocument);
        if (!alreadyLockedByCurrentUser) {
            this.getDocumentRoutingService().unlockDocumentRoute(route, this.documentManager);
        }
        if (this.docWithAttachedRouteId == null) {
            return this.webActions.setCurrentTabAndNavigate(docRouteElement.getDocumentRoute(this.documentManager).getDocument(), "TAB_DOCUMENT_ROUTE_ELEMENTS");
        }
        this.setRelatedRouteWhenNavigateBackToCase();
        return this.webActions.setCurrentTabAndNavigate(this.documentManager.getDocument((DocumentRef)new IdRef(this.docWithAttachedRouteId)), "TAB_CASE_MANAGEMENT_VIEW_RELATED_ROUTE");
    }

    public String goBackToRoute() throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        DocumentRouteElement docRouteElement = (DocumentRouteElement)currentDocument.getAdapter(DocumentRouteElement.class);
        return this.webActions.setCurrentTabAndNavigate(docRouteElement.getDocumentRoute(this.documentManager).getDocument(), "TAB_DOCUMENT_ROUTE_ELEMENTS");
    }

    public String createRouteElement(String typeName) throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        DocumentRef routeRef = currentDocument.getRef();
        IdRef sourceDocRef = new IdRef(this.hiddenSourceDocId);
        DocumentModel sourceDoc = this.documentManager.getDocument((DocumentRef)sourceDocRef);
        Object sourceDocName = null;
        String parentPath = null;
        if (StepOrder.in.toString().equals(this.hiddenDocOrder)) {
            parentPath = sourceDoc.getPathAsString();
        } else {
            DocumentModelList orderedChilds;
            int selectedDocumentIndex;
            int nextIndex;
            DocumentModel parentDoc = this.documentManager.getParentDocument((DocumentRef)sourceDocRef);
            parentPath = parentDoc.getPathAsString();
            sourceDocName = StepOrder.before.toString().equals(this.hiddenDocOrder) ? sourceDoc.getName() : ((nextIndex = (selectedDocumentIndex = (orderedChilds = this.getDocumentRoutingService().getOrderedRouteElement(parentDoc.getId(), this.documentManager)).indexOf((Object)sourceDoc)) + 1) >= orderedChilds.size() ? null : ((DocumentModel)orderedChilds.get(nextIndex)).getName());
        }
        Type docType = this.typeManager.getType(typeName);
        this.typesTool.setSelectedType(docType);
        try {
            DocumentModel changeableDocument = this.documentManager.createDocumentModel(typeName);
            ScopedMap context = changeableDocument.getContextData();
            context.put((Object)"parentPath", (Object)parentPath);
            context.put((Object)SOURCE_DOC_NAME, sourceDocName);
            context.put((Object)ROUTE_DOCUMENT_REF, (Object)routeRef);
            this.navigationContext.setChangeableDocument(changeableDocument);
            return "create_route_element";
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    public String moveRouteElement(String direction) throws ClientException {
        if (StringUtils.isEmpty((String)this.stepId)) {
            return null;
        }
        DocumentModel routeElementDocToMove = this.documentManager.getDocument((DocumentRef)new IdRef(this.stepId));
        DocumentModel parentDoc = this.documentManager.getDocument(routeElementDocToMove.getParentRef());
        DocumentRoutingConstants.ExecutionTypeValues executionType = DocumentRoutingConstants.ExecutionTypeValues.valueOf((String)((String)((Object)parentDoc.getPropertyValue("stepf:execution"))));
        if (!DocumentRoutingConstants.ExecutionTypeValues.serial.equals((Object)executionType)) {
            this.facesMessages.add(StatusMessage.Severity.WARN, (String)this.resourcesAccessor.getMessages().get("feedback.casemanagement.document.route.cant.move.steps.in.parallel.container"), new Object[0]);
            return null;
        }
        DocumentModelList orderedChilds = this.getDocumentRoutingService().getOrderedRouteElement(parentDoc.getId(), this.documentManager);
        int selectedDocumentIndex = orderedChilds.indexOf((Object)routeElementDocToMove);
        if ("up".equals(direction)) {
            if (selectedDocumentIndex == 0) {
                this.facesMessages.add(StatusMessage.Severity.WARN, (String)this.resourcesAccessor.getMessages().get("feedback.casemanagement.document.route.already.first.step.in.container"), new Object[0]);
                return null;
            }
            routeElementDocToMove.getAdapter(DocumentRouteElement.class);
            DocumentModel stepMoveBefore = (DocumentModel)orderedChilds.get(selectedDocumentIndex - 1);
            DocumentRouteElement stepElementMoveBefore = (DocumentRouteElement)stepMoveBefore.getAdapter(DocumentRouteElement.class);
            if (stepElementMoveBefore.isRunning()) {
                this.facesMessages.add(StatusMessage.Severity.WARN, (String)this.resourcesAccessor.getMessages().get("feedback.casemanagement.document.route.cant.move.step.before.already.running.step"), new Object[0]);
                return null;
            }
            if (!stepElementMoveBefore.isModifiable()) {
                this.facesMessages.add(StatusMessage.Severity.WARN, (String)this.resourcesAccessor.getMessages().get("feedback.casemanagement.document.route.cant.move.step.after.no.modifiable.step"), new Object[0]);
                return null;
            }
            this.documentManager.orderBefore(parentDoc.getRef(), routeElementDocToMove.getName(), stepMoveBefore.getName());
        }
        if ("down".equals(direction)) {
            if (selectedDocumentIndex == orderedChilds.size() - 1) {
                this.facesMessages.add(StatusMessage.Severity.WARN, (String)this.resourcesAccessor.getMessages().get("feedback.casemanagement.document.already.last.step.in.container"), new Object[0]);
                return null;
            }
            routeElementDocToMove.getAdapter(DocumentRouteElement.class);
            DocumentModel stepMoveAfter = (DocumentModel)orderedChilds.get(selectedDocumentIndex + 1);
            DocumentRouteElement stepElementMoveAfter = (DocumentRouteElement)stepMoveAfter.getAdapter(DocumentRouteElement.class);
            if (stepElementMoveAfter.isRunning()) {
                this.facesMessages.add(StatusMessage.Severity.WARN, (String)this.resourcesAccessor.getMessages().get("feedback.casemanagement.document.route.cant.move.step.after.already.running.step"), new Object[0]);
                return null;
            }
            this.documentManager.orderBefore(parentDoc.getRef(), ((DocumentModel)orderedChilds.get(selectedDocumentIndex + 1)).getName(), routeElementDocToMove.getName());
        }
        if (this.docWithAttachedRouteId == null) {
            return this.webActions.setCurrentTabAndNavigate(this.getRelatedRoute().getDocument(), "TAB_DOCUMENT_ROUTE_ELEMENTS");
        }
        this.setRelatedRouteWhenNavigateBackToCase();
        return this.webActions.setCurrentTabAndNavigate(this.documentManager.getDocument((DocumentRef)new IdRef(this.docWithAttachedRouteId)), "TAB_CASE_MANAGEMENT_VIEW_RELATED_ROUTE");
    }

    public String saveRouteElement() throws ClientException {
        boolean alreadyLockedByCurrentUser = false;
        DocumentRoute routeModel = this.getRelatedRoute();
        if (this.getDocumentRoutingService().isLockedByCurrentUser(routeModel, this.documentManager)) {
            alreadyLockedByCurrentUser = true;
        } else {
            this.lockRoute(routeModel);
        }
        DocumentModel newDocument = this.navigationContext.getChangeableDocument();
        if (newDocument.getId() != null) {
            log.debug((Object)("Document " + newDocument.getName() + " already created"));
            return this.navigationContext.navigateToDocument(newDocument, "after-create");
        }
        try {
            String parentDocumentPath = (String)newDocument.getContextData().get((Object)"parentPath");
            String sourceDocumentName = (String)newDocument.getContextData().get((Object)SOURCE_DOC_NAME);
            DocumentRef routeDocRef = (DocumentRef)newDocument.getContextData().get((Object)ROUTE_DOCUMENT_REF);
            try {
                this.getDocumentRoutingService().addRouteElementToRoute((DocumentRef)new PathRef(parentDocumentPath), sourceDocumentName, (DocumentRouteElement)newDocument.getAdapter(DocumentRouteElement.class), this.documentManager);
            }
            catch (DocumentRouteNotLockedException e) {
                this.facesMessages.add(StatusMessage.Severity.WARN, (String)this.resourcesAccessor.getMessages().get("feedback.casemanagement.document.route.not.locked"), new Object[0]);
                return null;
            }
            DocumentModel routeDocument = this.documentManager.getDocument(routeDocRef);
            this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("document_saved"), new Object[]{this.resourcesAccessor.getMessages().get(newDocument.getType())});
            Events.instance().raiseEvent("documentChildrenChanged", new Object[]{routeDocument});
            if (!alreadyLockedByCurrentUser) {
                this.getDocumentRoutingService().unlockDocumentRoute(routeModel, this.documentManager);
            }
            return this.navigationContext.navigateToDocument(routeDocument);
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    public List<DocumentModel> getOrderedChildren(String docRouteElementId, String type) throws ClientException {
        DocumentModelList orderedChildren = this.getDocumentRoutingService().getOrderedRouteElement(docRouteElementId, this.documentManager);
        ArrayList<DocumentModel> filteredChildren = new ArrayList<DocumentModel>();
        for (DocumentModel documentModel : orderedChildren) {
            if (!type.equals(documentModel.getType())) continue;
            filteredChildren.add(documentModel);
        }
        return filteredChildren;
    }

    public DocumentModel getChildWithPosition(DocumentModel docRouteElement, String pos) throws ClientException {
        DocumentModelList orderedChildren = this.getDocumentRoutingService().getOrderedRouteElement(docRouteElement.getId(), this.documentManager);
        return (DocumentModel)orderedChildren.get(Integer.parseInt(pos));
    }

    public String getPositionForChild(DocumentModel docRouteElement, DocumentModel docChild) throws ClientException {
        DocumentModelList orderedChildren = this.getDocumentRoutingService().getOrderedRouteElement(docRouteElement.getId(), this.documentManager);
        return String.valueOf(orderedChildren.indexOf((Object)docChild));
    }

    public String getHiddenSourceDocId() {
        return this.hiddenSourceDocId;
    }

    public void setHiddenSourceDocId(String hiddenSourceDocId) {
        this.hiddenSourceDocId = hiddenSourceDocId;
    }

    public String getHiddenDocOrder() {
        return this.hiddenDocOrder;
    }

    public void setHiddenDocOrder(String hiddenDocOrder) {
        this.hiddenDocOrder = hiddenDocOrder;
    }

    public String getRelatedRouteModelDocumentId() {
        return this.relatedRouteModelDocumentId;
    }

    public void setRelatedRouteModelDocumentId(String relatedRouteModelDocumentId) {
        this.relatedRouteModelDocumentId = relatedRouteModelDocumentId;
    }

    public String getDocWithAttachedRouteId() {
        return this.docWithAttachedRouteId;
    }

    public void setDocWithAttachedRouteId(String docWithAttachedRouteId) {
        this.docWithAttachedRouteId = docWithAttachedRouteId;
    }

    private void setRelatedRouteWhenNavigateBackToCase() throws ClientException {
        this.webActions.resetTabList();
        this.navigationContext.setCurrentDocument(this.documentManager.getDocument((DocumentRef)new IdRef(this.docWithAttachedRouteId)));
        this.relatedRoutes = this.relatedRouteAction.findRelatedRoute();
    }

    @Observer(value={"workflowProcessEnded", "workflowTaskCompleted", "workflowProcessCanceled", "workflowTaskRejected"}, create=false)
    public void resetCache() {
        this.webActions.resetTabList();
    }

    public DocumentModel getRouteModel(String routeId) throws ClientException {
        return this.documentManager.getDocument((DocumentRef)new IdRef(routeId));
    }

    public DocumentModel getRouteInstanceFor(Task task) throws ClientException {
        final String routeDocId = task.getVariable("routeInstanceDocId");
        if (routeDocId == null) {
            return null;
        }
        final DocumentModel[] res = new DocumentModel[1];
        new UnrestrictedSessionRunner(this.documentManager){

            public void run() throws ClientException {
                DocumentModel doc = this.session.getDocument((DocumentRef)new IdRef(routeDocId));
                doc.detach(true);
                res[0] = doc;
            }
        }.runUnrestricted();
        return res[0];
    }

    public List<DocumentModel> getFilteredRouteModels() throws ClientException {
        DocumentRoutingService documentRoutingService = (DocumentRoutingService)Framework.getLocalService(DocumentRoutingService.class);
        List routeModels = documentRoutingService.searchRouteModels(this.documentManager, "");
        Iterator it = routeModels.iterator();
        while (it.hasNext()) {
            DocumentModel route = (DocumentModel)it.next();
            Object graphRouteObj = route.getAdapter(GraphRoute.class);
            if (graphRouteObj instanceof GraphRoute) {
                String filter = ((GraphRoute)graphRouteObj).getAvailabilityFilter();
                if (StringUtils.isBlank((String)filter) || this.webActions.checkFilter(filter)) continue;
                it.remove();
                continue;
            }
            it.remove();
        }
        return routeModels;
    }

    public List<Task> getCurrentRouteAllTasks() throws ClientException {
        TaskService taskService = (TaskService)Framework.getLocalService(TaskService.class);
        DocumentRoute currentRoute = this.getRelatedRoute();
        if (currentRoute != null) {
            return taskService.getAllTaskInstances(currentRoute.getDocument().getId(), this.documentManager);
        }
        return null;
    }

    public List<Task> getCurrentRouteCurrentUserTasks() throws ClientException {
        TaskService taskService = (TaskService)Framework.getLocalService(TaskService.class);
        DocumentRoute currentRoute = this.getRelatedRoute();
        if (currentRoute != null) {
            return taskService.getAllTaskInstances(currentRoute.getDocument().getId(), (NuxeoPrincipal)this.documentManager.getPrincipal(), this.documentManager);
        }
        return null;
    }

    public String getCurrentWorkflowInitiator() throws ClientException {
        DocumentRoute currentRoute = this.getRelatedRoute();
        if (currentRoute != null) {
            return (String)((Object)currentRoute.getDocument().getPropertyValue("docri:initiator"));
        }
        return "";
    }

    public boolean isCurrentRouteGraph() throws ClientException {
        DocumentRoute currentRoute = this.getRelatedRoute();
        if (currentRoute != null) {
            return DocumentRoutingConstants.ExecutionTypeValues.graph.toString().equals((String)((Object)currentRoute.getDocument().getPropertyValue("stepf:execution")));
        }
        return false;
    }

    static enum StepOrder {
        before,
        in,
        after;

    }
}

