/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.contentview.seam;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.faces.context.FacesContext;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.platform.contentview.jsf.ContentView;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewCache;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewService;
import org.nuxeo.ecm.platform.contentview.seam.ContentViewRestActions;

@Name(value="contentViewActions")
@Scope(value=ScopeType.CONVERSATION)
public class ContentViewActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    @In(create=true)
    protected ContentViewRestActions contentViewRestActions;
    @In(create=true)
    protected ContentViewService contentViewService;
    protected final ContentViewCache cache = new ContentViewCache();
    protected Long globalPageSize;
    @In(create=true, required=false)
    protected FacesContext facesContext;
    protected ContentView currentContentView;

    public ContentView getCurrentContentView() {
        return this.currentContentView;
    }

    public void setCurrentContentView(ContentView cv) {
        this.currentContentView = cv;
    }

    public Long getCurrentGlobalPageSize() {
        if (this.globalPageSize == null && this.currentContentView != null) {
            return this.currentContentView.getCurrentPageSize();
        }
        return this.globalPageSize;
    }

    public void setCurrentGlobalPageSize(Long pageSize) {
        this.globalPageSize = pageSize;
    }

    public Long getGlobalPageSize() {
        return this.globalPageSize;
    }

    public void setGlobalPageSize(Long pageSize) {
        this.globalPageSize = pageSize;
    }

    public ContentView getContentView(String name) throws ClientException {
        return this.getContentView(name, null);
    }

    public ContentView getContentView(String name, DocumentModel searchDocumentModel) throws ClientException {
        ContentView cView = this.cache.get(name);
        if (cView == null && (cView = this.contentViewService.getContentView(name)) != null) {
            this.cache.add(cView);
        }
        if (cView != null) {
            if (searchDocumentModel != null) {
                cView.setSearchDocumentModel(searchDocumentModel);
            }
            this.setCurrentContentView(cView);
        }
        return cView;
    }

    public ContentView getContentViewWithProvider(String name) throws ClientException {
        return this.getContentViewWithProvider(name, null, null, null, null);
    }

    public ContentView getContentViewWithProvider(String name, DocumentModel searchDocumentModel) throws ClientException {
        return this.getContentViewWithProvider(name, searchDocumentModel, null, null, null);
    }

    public ContentView getContentViewWithProvider(String name, DocumentModel searchDocumentModel, List<SortInfo> sortInfos, Long pageSize, Long currentPage) throws ClientException {
        return this.getContentViewWithProvider(name, searchDocumentModel, sortInfos, pageSize, currentPage, (Object[])null);
    }

    public ContentView getContentViewWithProvider(String name, DocumentModel searchDocumentModel, List<SortInfo> sortInfos, Long defaultPageSize, Long pageSize, Long currentPage) throws ClientException {
        return this.getContentViewWithProvider(name, searchDocumentModel, sortInfos, defaultPageSize, pageSize, currentPage, (Object[])null);
    }

    public ContentView getContentViewWithProvider(String name, DocumentModel searchDocumentModel, List<SortInfo> sortInfos, Long pageSize, Long currentPage, Object ... params) throws ClientException {
        return this.getContentViewWithProvider(name, searchDocumentModel, sortInfos, (Long)-1L, pageSize, currentPage, params);
    }

    protected ContentView getContentViewWithProvider(String name, DocumentModel searchDocumentModel, List<SortInfo> sortInfos, Long defaultPageSize, Long pageSize, Long currentPage, Object ... params) throws ClientException {
        ContentView cView = this.getContentView(name, searchDocumentModel);
        if (cView != null) {
            if (cView.getUseGlobalPageSize()) {
                cView.setCurrentPageSize(this.globalPageSize);
            }
            if (cView.getCurrentPageSize() == null && defaultPageSize != null && defaultPageSize >= 0L) {
                cView.setCurrentPageSize(defaultPageSize);
            }
            cView.getPageProvider(searchDocumentModel, sortInfos, pageSize, currentPage, params);
        }
        return cView;
    }

    public ContentView restoreContentView(String contentViewName, Long currentPage, Long pageSize, List<SortInfo> sortInfos, String jsonContentViewState) throws UnsupportedEncodingException, ClientException {
        ContentView cv = this.contentViewRestActions.restoreContentView(contentViewName, currentPage, pageSize, sortInfos, jsonContentViewState);
        this.cache.add(cv);
        return cv;
    }

    public void refreshOnSeamEvent(String seamEventName) {
        this.cache.refreshOnEvent(seamEventName);
    }

    public void resetPageProviderOnSeamEvent(String seamEventName) {
        this.cache.resetPageProviderOnEvent(seamEventName);
    }

    public void refresh(String contentViewName) {
        this.cache.refresh(contentViewName, false);
    }

    public void refreshAndRewind(String contentViewName) {
        this.cache.refresh(contentViewName, true);
    }

    public void resetPageProvider(String contentViewName) {
        this.cache.resetPageProvider(contentViewName);
    }

    public void reset(String contentViewName) {
        this.cache.reset(contentViewName);
    }

    public void resetAllContent() {
        this.cache.resetAllContent();
    }

    public void resetAll() {
        this.cache.resetAll();
    }

    public void refreshAll() {
        this.cache.refreshAll();
    }

    public void refreshAndRewindAll() {
        this.cache.refreshAndRewindAll();
    }
}

