/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.standalone;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.nuxeo.common.Environment;
import org.nuxeo.common.utils.ZipUtils;
import org.nuxeo.connect.update.AlreadyExistsPackageException;
import org.nuxeo.connect.update.LocalPackage;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.PackageState;
import org.nuxeo.connect.update.PackageType;
import org.nuxeo.connect.update.PackageUpdateService;
import org.nuxeo.connect.update.standalone.LocalPackageImpl;
import org.nuxeo.connect.update.task.Task;

public class PackagePersistence {
    private static final String FEATURES_DIR = "packages";
    protected final File root;
    protected final File store;
    protected final File temp;
    protected final Random random = new Random();
    protected Map<String, PackageState> states;
    private PackageUpdateService service;

    public PackagePersistence(PackageUpdateService pus) throws IOException {
        String dataDir = System.getProperty("org.nuxeo.connect.update.dataDir");
        this.root = dataDir != null ? new File(new File(dataDir), FEATURES_DIR) : new File(Environment.getDefault().getData(), FEATURES_DIR);
        this.root.mkdirs();
        this.store = new File(this.root, "store");
        this.store.mkdirs();
        this.temp = new File(this.root, "tmp");
        this.temp.mkdirs();
        this.service = pus;
        this.states = this.loadStates();
    }

    public File getRoot() {
        return this.root;
    }

    public synchronized Map<String, PackageState> getStates() {
        return new HashMap<String, PackageState>(this.states);
    }

    protected Map<String, PackageState> loadStates() throws IOException {
        HashMap<String, PackageState> result = new HashMap<String, PackageState>();
        File file = new File(this.root, ".packages");
        if (file.isFile()) {
            List lines = org.nuxeo.common.utils.FileUtils.readLines((File)file);
            for (String line : lines) {
                if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
                int i = line.indexOf(61);
                String pkgId = line.substring(0, i).trim();
                String value = line.substring(i + 1).trim();
                PackageState state = null;
                state = PackageState.getByLabel((String)value);
                if (state == PackageState.UNKNOWN) {
                    try {
                        state = PackageState.getByValue((String)value);
                    }
                    catch (NumberFormatException e) {
                        state = PackageState.REMOTE;
                    }
                }
                result.put(pkgId, state);
            }
        }
        return result;
    }

    protected void writeStates() throws IOException {
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<String, PackageState> entry : this.states.entrySet()) {
            buf.append(entry.getKey()).append('=').append(entry.getValue()).append("\n");
        }
        File file = new File(this.root, ".packages");
        org.nuxeo.common.utils.FileUtils.writeFile((File)file, (String)buf.toString());
    }

    public LocalPackage getPackage(String id) throws PackageException {
        File file = new File(this.store, id);
        if (file.isDirectory()) {
            return new LocalPackageImpl(file, this.getState(id), this.service);
        }
        return null;
    }

    public synchronized LocalPackage addPackage(File file) throws PackageException {
        if (file.isDirectory()) {
            return this.addPackageFromDir(file);
        }
        if (file.isFile()) {
            File tmp = this.newTempDir(file.getName());
            try {
                ZipUtils.unzip((File)file, (File)tmp);
                LocalPackage localPackage = this.addPackageFromDir(tmp);
                return localPackage;
            }
            catch (IOException e) {
                throw new PackageException("Failed to unzip package: " + file.getName());
            }
            finally {
                FileUtils.deleteQuietly((File)tmp);
            }
        }
        throw new PackageException("Not found: " + file);
    }

    protected LocalPackage addPackageFromDir(File file) throws PackageException {
        LocalPackageImpl pkg = new LocalPackageImpl(file, PackageState.DOWNLOADED, this.service);
        File dir = new File(this.store, pkg.getId());
        if (dir.exists()) {
            if (PackageType.STUDIO.equals((Object)pkg.getType()) && pkg.getId().endsWith("-0.0.0-SNAPSHOT")) {
                LocalPackage oldpkg = this.getPackage(pkg.getId());
                if (oldpkg.getState() >= PackageState.INSTALLED.getValue()) {
                    Task utask = oldpkg.getUninstallTask();
                    try {
                        utask.run(new HashMap());
                    }
                    catch (Throwable t) {
                        utask.rollback();
                        throw new PackageException("Failed to uninstall snapshot. Abort reloading: " + pkg.getId(), t);
                    }
                }
                FileUtils.deleteQuietly((File)dir);
            } else {
                throw new AlreadyExistsPackageException("Package " + pkg.getId() + " already exists");
            }
        }
        try {
            FileUtils.moveDirectory((File)file, (File)dir);
        }
        catch (IOException e) {
            throw new PackageException(String.format("Failed to move %s to %s", file, dir), (Throwable)e);
        }
        pkg.data.setRoot(dir);
        this.updateState(pkg.getId(), pkg.getState());
        return pkg;
    }

    public synchronized int getState(String featureId) {
        PackageState state = this.states.get(featureId);
        if (state == null) {
            return 0;
        }
        return state.getValue();
    }

    public LocalPackage getActivePackage(String name) throws PackageException {
        String pkgId = this.getActivePackageId(name);
        if (pkgId == null) {
            return null;
        }
        return this.getPackage(pkgId);
    }

    public synchronized String getActivePackageId(String name) {
        name = name + '-';
        for (Map.Entry<String, PackageState> entry : this.states.entrySet()) {
            if (!entry.getKey().startsWith(name) || !entry.getValue().isInstalled()) continue;
            return entry.getKey();
        }
        return null;
    }

    public synchronized List<LocalPackage> getPackages() throws PackageException {
        File[] list = this.store.listFiles();
        if (list != null) {
            ArrayList<LocalPackage> pkgs = new ArrayList<LocalPackage>(list.length);
            for (File file : list) {
                pkgs.add(new LocalPackageImpl(file, this.getState(file.getName()), this.service));
            }
            return pkgs;
        }
        return new ArrayList<LocalPackage>();
    }

    public synchronized void removePackage(String id) throws PackageException {
        this.states.remove(id);
        try {
            this.writeStates();
        }
        catch (IOException e) {
            throw new PackageException("Failed to write package states", (Throwable)e);
        }
        File file = new File(this.store, id);
        FileUtils.deleteQuietly((File)file);
    }

    @Deprecated
    public synchronized void updateState(String id, int state) throws PackageException {
        this.states.put(id, PackageState.getByValue((int)state));
        try {
            this.writeStates();
        }
        catch (IOException e) {
            throw new PackageException("Failed to write package states", (Throwable)e);
        }
    }

    public synchronized void updateState(String id, PackageState state) throws PackageException {
        this.states.put(id, state);
        try {
            this.writeStates();
        }
        catch (IOException e) {
            throw new PackageException("Failed to write package states", (Throwable)e);
        }
    }

    public synchronized void reset() throws PackageException {
        String[] keys;
        for (String key : keys = this.states.keySet().toArray(new String[this.states.size()])) {
            this.states.put(key, PackageState.DOWNLOADED);
        }
        try {
            this.writeStates();
        }
        catch (IOException e) {
            throw new PackageException("Failed to write package states", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File newTempDir(String id) {
        File tmp;
        File file = this.temp;
        synchronized (file) {
            while ((tmp = new File(this.temp, id + "-" + this.random.nextInt())).exists()) {
            }
            tmp.mkdirs();
        }
        return tmp;
    }
}

