/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.jaxrs.io;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.nuxeo.ecm.automation.server.jaxrs.ExecutionRequest;
import org.nuxeo.ecm.automation.server.jaxrs.io.InputResolver;
import org.nuxeo.ecm.automation.server.jaxrs.io.JsonWriter;
import org.nuxeo.ecm.automation.server.jaxrs.io.ObjectCodecService;
import org.nuxeo.ecm.automation.server.jaxrs.io.resolvers.DocumentInputResolver;
import org.nuxeo.ecm.automation.server.jaxrs.io.resolvers.DocumentsInputResolver;
import org.nuxeo.runtime.api.Framework;

@Provider
@Consumes(value={"application/json+nxrequest"})
public class JsonRequestReader
implements MessageBodyReader<ExecutionRequest> {
    public static final MediaType targetMediaType = new MediaType("application", "json+nxrequest");
    protected static final HashMap<String, InputResolver<?>> inputResolvers = new HashMap();

    public static void addInputResolver(InputResolver<?> resolver) {
        inputResolvers.put(resolver.getType(), resolver);
    }

    public static Object resolveInput(String input) throws Exception {
        int p = input.indexOf(58);
        if (p <= 0) {
            return input;
        }
        String type = input.substring(0, p);
        String ref = input.substring(p + 1);
        InputResolver<?> ir = inputResolvers.get(type);
        if (ir != null) {
            return ir.getInput(ref);
        }
        return input;
    }

    public boolean isReadable(Class<?> arg0, Type arg1, Annotation[] arg2, MediaType arg3) {
        return targetMediaType.isCompatible(arg3) && ExecutionRequest.class.isAssignableFrom(arg0);
    }

    public ExecutionRequest readFrom(Class<ExecutionRequest> arg0, Type arg1, Annotation[] arg2, MediaType arg3, MultivaluedMap<String, String> headers, InputStream in) throws IOException, WebApplicationException {
        return JsonRequestReader.readRequest(in, headers);
    }

    public static ExecutionRequest readRequest(InputStream in, MultivaluedMap<String, String> headers) throws IOException, WebApplicationException {
        String content = IOUtils.toString((InputStream)in, (String)"UTF-8");
        if (content.isEmpty()) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        return JsonRequestReader.readRequest(content, headers);
    }

    public static ExecutionRequest readRequest(String content, MultivaluedMap<String, String> headers) throws WebApplicationException {
        try {
            return JsonRequestReader.readRequest0(content, headers);
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    public static ExecutionRequest readRequest0(String content, MultivaluedMap<String, String> headers) throws Exception {
        ExecutionRequest req = new ExecutionRequest();
        ObjectCodecService codecService = (ObjectCodecService)Framework.getLocalService(ObjectCodecService.class);
        JsonParser jp = JsonWriter.getFactory().createJsonParser(content);
        jp.nextToken();
        JsonToken tok = jp.nextToken();
        while (tok != JsonToken.END_OBJECT) {
            String documentProperties;
            String key = jp.getCurrentName();
            jp.nextToken();
            if ("input".equals(key)) {
                JsonNode inputNode = jp.readValueAsTree();
                if (inputNode.isTextual()) {
                    req.setInput(JsonRequestReader.resolveInput(inputNode.getTextValue()));
                } else {
                    req.setInput(codecService.readNode(inputNode));
                }
            } else if ("params".equals(key)) {
                JsonRequestReader.readParams(jp, req);
            } else if ("context".equals(key)) {
                JsonRequestReader.readContext(jp, req);
            } else if ("documentProperties".equals(key) && (documentProperties = jp.getText()) != null) {
                headers.putSingle((Object)"X-NXDocumentProperties", (Object)documentProperties);
            }
            tok = jp.nextToken();
        }
        return req;
    }

    private static void readParams(JsonParser jp, ExecutionRequest req) throws Exception {
        ObjectCodecService codecService = (ObjectCodecService)Framework.getLocalService(ObjectCodecService.class);
        JsonToken tok = jp.nextToken();
        while (tok != JsonToken.END_OBJECT) {
            String key = jp.getCurrentName();
            tok = jp.nextToken();
            req.setParam(key, codecService.readNode(jp.readValueAsTree()));
            tok = jp.nextToken();
        }
    }

    private static void readContext(JsonParser jp, ExecutionRequest req) throws Exception {
        ObjectCodecService codecService = (ObjectCodecService)Framework.getLocalService(ObjectCodecService.class);
        JsonToken tok = jp.nextToken();
        while (tok != JsonToken.END_OBJECT) {
            String key = jp.getCurrentName();
            tok = jp.nextToken();
            req.setContextParam(key, codecService.readNode(jp.readValueAsTree()));
            tok = jp.nextToken();
        }
    }

    static {
        JsonRequestReader.addInputResolver(new DocumentInputResolver());
        JsonRequestReader.addInputResolver(new DocumentsInputResolver());
    }
}

