/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.jaxrs.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.ObjectMapper;
import org.nuxeo.ecm.automation.server.jaxrs.io.JsonWriter;
import org.nuxeo.ecm.automation.server.jaxrs.io.ObjectCodec;
import org.nuxeo.ecm.core.schema.utils.DateParser;

public class ObjectCodecService {
    protected Map<Class<?>, ObjectCodec<?>> codecs = new HashMap();
    protected Map<String, ObjectCodec<?>> codecsByName = new HashMap();
    protected Map<Class<?>, ObjectCodec<?>> _codecs;
    protected Map<String, ObjectCodec<?>> _codecsByName;

    public ObjectCodecService() {
        this.init();
    }

    protected void init() {
        new StringCodec().register(this);
        new DateCodec().register(this);
        new CalendarCodec().register(this);
        new BooleanCodec().register(this);
        new NumberCodec().register(this);
    }

    public Collection<ObjectCodec<?>> getCodecs() {
        return this.codecs().values();
    }

    public synchronized void addCodec(ObjectCodec<?> codec) {
        this.codecs.put(codec.getJavaType(), codec);
        this.codecsByName.put(codec.getType(), codec);
        this._codecs = null;
        this._codecsByName = null;
    }

    public synchronized void removeCodec(String name) {
        ObjectCodec<?> codec = this.codecsByName.remove(name);
        if (codec != null) {
            this.codecs.remove(codec.getJavaType());
            this._codecs = null;
            this._codecsByName = null;
        }
    }

    public synchronized void removeCodec(Class<?> objectType) {
        ObjectCodec<?> codec = this.codecs.remove(objectType);
        if (codec != null) {
            this.codecsByName.remove(codec.getType());
            this._codecs = null;
            this._codecsByName = null;
        }
    }

    public ObjectCodec<?> getCodec(Class<?> objectType) {
        return this.codecs().get(objectType);
    }

    public ObjectCodec<?> getCodec(String name) {
        return this.codecsByName().get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Class<?>, ObjectCodec<?>> codecs() {
        Map<Class<?>, ObjectCodec<?>> cache = this._codecs;
        if (cache == null) {
            ObjectCodecService objectCodecService = this;
            synchronized (objectCodecService) {
                cache = this._codecs = new HashMap(this.codecs);
            }
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ObjectCodec<?>> codecsByName() {
        Map<String, ObjectCodec<?>> cache = this._codecsByName;
        if (cache == null) {
            ObjectCodecService objectCodecService = this;
            synchronized (objectCodecService) {
                cache = this._codecsByName = new HashMap(this.codecsByName);
            }
        }
        return cache;
    }

    public String toString(Object object) throws IOException {
        return this.toString(object, false);
    }

    public String toString(Object object, boolean preetyPrint) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.write(baos, object, preetyPrint);
        return baos.toString("UTF-8");
    }

    public void write(OutputStream out, Object object) throws IOException {
        this.write(out, object, false);
    }

    public void write(OutputStream out, Object object, boolean prettyPint) throws IOException {
        JsonGenerator jg = JsonWriter.createGenerator(out);
        if (prettyPint) {
            jg.useDefaultPrettyPrinter();
        }
        this.write(jg, object);
    }

    public void write(JsonGenerator jg, Object object) throws IOException {
        if (object == null) {
            jg.writeStringField("entity-type", "null");
            jg.writeFieldName("value");
            jg.writeNull();
        } else {
            Class<?> clazz = object.getClass();
            ObjectCodec<?> codec = this.getCodec(clazz);
            if (codec == null) {
                this.writeGenericObject(jg, clazz, object);
            } else {
                jg.writeStartObject();
                jg.writeStringField("entity-type", codec.getType());
                jg.writeFieldName("value");
                codec.write(jg, object);
                jg.writeEndObject();
            }
        }
        jg.flush();
    }

    public Object read(String json) throws IOException, ClassNotFoundException {
        return this.read(json, null);
    }

    public Object read(String json, ClassLoader cl) throws IOException, ClassNotFoundException {
        ByteArrayInputStream in = new ByteArrayInputStream(json.getBytes());
        return this.read(in, cl);
    }

    public Object read(InputStream in) throws IOException, ClassNotFoundException {
        return this.read(in, null);
    }

    public Object read(InputStream in, ClassLoader cl) throws IOException, ClassNotFoundException {
        return this.read(JsonWriter.getFactory().createJsonParser(in), cl);
    }

    public Object read(JsonParser jp, ClassLoader cl) throws IOException, ClassNotFoundException {
        JsonToken tok = jp.getCurrentToken();
        if (tok == null) {
            tok = jp.nextToken();
        }
        if (tok == JsonToken.START_OBJECT) {
            tok = jp.nextToken();
        } else if (tok != JsonToken.FIELD_NAME) {
            throw new IllegalStateException("Invalid parser state. Current token must be either start_object or field_name");
        }
        String key = jp.getCurrentName();
        if (!"entity-type".equals(key)) {
            throw new IllegalStateException("Invalid parser state. Current field must be 'entity-type'");
        }
        jp.nextToken();
        String name = jp.getText();
        if (name == null) {
            throw new IllegalStateException("Invalid stream. Entity-Type is null");
        }
        jp.nextValue();
        ObjectCodec<?> codec = this.codecs.get(name);
        if (codec == null) {
            return this.readGenericObject(jp, name, cl);
        }
        return codec.read(jp);
    }

    public Object readNode(JsonNode node, ClassLoader cl) throws IOException, ClassNotFoundException {
        if (node.isNumber()) {
            return node.getNumberValue();
        }
        if (node.isBoolean()) {
            return node.getBooleanValue();
        }
        if (node.isTextual()) {
            return node.getTextValue();
        }
        JsonNode entityTypeNode = node.get("entity-type");
        JsonNode valueNode = node.get("value");
        if (entityTypeNode != null && entityTypeNode.isTextual()) {
            if (valueNode == null) {
                return null;
            }
            String type = entityTypeNode.getTextValue();
            ObjectCodec<?> codec = this.codecsByName.get(type);
            JsonParser valueParser = valueNode.traverse();
            if (valueParser.getCurrentToken() == null) {
                valueParser.nextToken();
            }
            if (codec == null) {
                return this.readGenericObject(valueParser, type, cl);
            }
            return codec.read(valueParser);
        }
        return node;
    }

    public Object readNode(JsonNode node) throws IOException, ClassNotFoundException {
        return this.readNode(node, null);
    }

    protected final void writeGenericObject(JsonGenerator jg, Class<?> clazz, Object object) throws IOException {
        jg.writeStartObject();
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                jg.writeStringField("entity-type", "boolean");
                jg.writeBooleanField("value", ((Boolean)object).booleanValue());
            } else if (clazz == Double.TYPE || clazz == Float.TYPE) {
                jg.writeStringField("entity-type", "number");
                jg.writeNumberField("value", ((Number)object).doubleValue());
            } else if (clazz == Integer.TYPE || clazz == Long.TYPE || clazz == Short.TYPE || clazz == Byte.TYPE) {
                jg.writeStringField("entity-type", "number");
                jg.writeNumberField("value", ((Number)object).longValue());
            } else if (clazz == Character.TYPE) {
                jg.writeStringField("entity-type", "string");
                jg.writeStringField("value", object.toString());
            }
            return;
        }
        if (jg.getCodec() == null) {
            jg.setCodec((org.codehaus.jackson.ObjectCodec)new ObjectMapper());
        }
        if (object instanceof Iterable && clazz.getName().startsWith("java.")) {
            jg.writeStringField("entity-type", "list");
        } else if (object instanceof Map && clazz.getName().startsWith("java.")) {
            if (object instanceof LinkedHashMap) {
                jg.writeStringField("entity-type", "orderedMap");
            } else {
                jg.writeStringField("entity-type", "map");
            }
        } else {
            jg.writeStringField("entity-type", clazz.getName());
        }
        jg.writeObjectField("value", object);
        jg.writeEndObject();
    }

    protected final Object readGenericObject(JsonParser jp, String name, ClassLoader cl) throws IOException, ClassNotFoundException {
        if (jp.getCodec() == null) {
            jp.setCodec((org.codehaus.jackson.ObjectCodec)new ObjectMapper());
        }
        if ("list".equals(name)) {
            return jp.readValueAs(ArrayList.class);
        }
        if ("map".equals(name)) {
            return jp.readValueAs(HashMap.class);
        }
        if ("orderedMap".equals(name)) {
            return jp.readValueAs(LinkedHashMap.class);
        }
        if (cl == null && (cl = Thread.currentThread().getContextClassLoader()) == null) {
            cl = ObjectCodecService.class.getClassLoader();
        }
        Class<?> clazz = cl.loadClass(name);
        return jp.readValueAs(clazz);
    }

    public static void main(String[] args) throws Exception {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        ArrayList<Object> list = new ArrayList<Object>();
        list.add("v1");
        list.add(2);
        list.add(new Date());
        map.put("list", list);
        map.put("k", "v");
        map.put("k2", "v");
        map.put("k1", "v");
        ObjectCodecService s = new ObjectCodecService();
        String json = s.toString(map, true);
        System.out.println(json);
        System.out.println("================");
        System.out.println(s.toString(s.read(json), true));
    }

    public static class NumberCodec
    extends ObjectCodec<Number> {
        public NumberCodec() {
            super(Number.class);
        }

        @Override
        public String getType() {
            return "number";
        }

        @Override
        public void write(JsonGenerator jg, Number value) throws IOException {
            Class<?> cl = value.getClass();
            if (cl == Double.class || cl == Float.class) {
                jg.writeNumber(value.doubleValue());
            } else {
                jg.writeNumber(value.longValue());
            }
        }

        @Override
        public Number read(JsonParser jp) throws IOException {
            if (jp.getCurrentToken() == JsonToken.VALUE_NUMBER_FLOAT) {
                return jp.getDoubleValue();
            }
            return jp.getLongValue();
        }

        @Override
        public boolean isBuiltin() {
            return true;
        }

        public void register(ObjectCodecService service) {
            service.codecs.put(Integer.class, this);
            service.codecs.put(Integer.TYPE, this);
            service.codecs.put(Long.class, this);
            service.codecs.put(Long.TYPE, this);
            service.codecs.put(Double.class, this);
            service.codecs.put(Double.TYPE, this);
            service.codecs.put(Float.class, this);
            service.codecs.put(Float.TYPE, this);
            service.codecs.put(Short.class, this);
            service.codecs.put(Short.TYPE, this);
            service.codecs.put(Byte.class, this);
            service.codecs.put(Byte.TYPE, this);
            service.codecsByName.put(this.getType(), this);
        }
    }

    public static class BooleanCodec
    extends ObjectCodec<Boolean> {
        public BooleanCodec() {
            super(Boolean.class);
        }

        @Override
        public String getType() {
            return "boolean";
        }

        @Override
        public void write(JsonGenerator jg, Boolean value) throws IOException {
            jg.writeBoolean(value.booleanValue());
        }

        @Override
        public Boolean read(JsonParser jp) throws IOException {
            return jp.getBooleanValue();
        }

        @Override
        public boolean isBuiltin() {
            return true;
        }

        public void register(ObjectCodecService service) {
            service.codecs.put(Boolean.class, this);
            service.codecs.put(Boolean.TYPE, this);
            service.codecsByName.put(this.getType(), this);
        }
    }

    public static class CalendarCodec
    extends ObjectCodec<Calendar> {
        public CalendarCodec() {
            super(Calendar.class);
        }

        @Override
        public String getType() {
            return "date";
        }

        @Override
        public void write(JsonGenerator jg, Calendar value) throws IOException {
            jg.writeString(DateParser.formatW3CDateTime((Date)value.getTime()));
        }

        @Override
        public Calendar read(JsonParser jp) throws IOException {
            Calendar c = Calendar.getInstance();
            c.setTime(DateParser.parseW3CDateTime((String)jp.getText()));
            return c;
        }

        @Override
        public boolean isBuiltin() {
            return true;
        }

        public void register(ObjectCodecService service) {
            service.codecs.put(Calendar.class, this);
        }
    }

    public static class DateCodec
    extends ObjectCodec<Date> {
        public DateCodec() {
            super(Date.class);
        }

        @Override
        public String getType() {
            return "date";
        }

        @Override
        public void write(JsonGenerator jg, Date value) throws IOException {
            jg.writeString(DateParser.formatW3CDateTime((Date)value));
        }

        @Override
        public Date read(JsonParser jp) throws IOException {
            return DateParser.parseW3CDateTime((String)jp.getText());
        }

        @Override
        public boolean isBuiltin() {
            return true;
        }

        public void register(ObjectCodecService service) {
            service.codecs.put(Date.class, this);
            service.codecsByName.put(this.getType(), this);
        }
    }

    public static class StringCodec
    extends ObjectCodec<String> {
        public StringCodec() {
            super(String.class);
        }

        @Override
        public String getType() {
            return "string";
        }

        @Override
        public void write(JsonGenerator jg, String value) throws IOException {
            jg.writeString(value);
        }

        @Override
        public String read(JsonParser jp) throws IOException {
            return jp.getText();
        }

        @Override
        public boolean isBuiltin() {
            return true;
        }

        public void register(ObjectCodecService service) {
            service.codecs.put(String.class, this);
            service.codecsByName.put(this.getType(), this);
        }
    }
}

