/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.replay;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.kerberos.shared.messages.value.KerberosTime;
import org.apache.directory.server.kerberos.shared.replay.ReplayCache;

public class InMemoryReplayCache
implements ReplayCache {
    private List<ReplayCacheEntry> list = new ArrayList<ReplayCacheEntry>();
    private long clockSkew = 300000L;

    public void setClockSkew(long clockSkew) {
        this.clockSkew = clockSkew;
    }

    public synchronized boolean isReplay(KerberosPrincipal serverPrincipal, KerberosPrincipal clientPrincipal, KerberosTime clientTime, int clientMicroSeconds) {
        ReplayCacheEntry testEntry = new ReplayCacheEntry(serverPrincipal, clientPrincipal, clientTime, clientMicroSeconds);
        Iterator<ReplayCacheEntry> it = this.list.iterator();
        while (it.hasNext()) {
            ReplayCacheEntry entry = it.next();
            if (entry.equals(testEntry)) {
                return true;
            }
            if (!entry.isOutsideClockSkew(this.clockSkew)) continue;
            it.remove();
        }
        return false;
    }

    public synchronized void save(KerberosPrincipal serverPrincipal, KerberosPrincipal clientPrincipal, KerberosTime clientTime, int clientMicroSeconds) {
        this.list.add(new ReplayCacheEntry(serverPrincipal, clientPrincipal, clientTime, clientMicroSeconds));
    }

    private class ReplayCacheEntry {
        private KerberosPrincipal serverPrincipal;
        private KerberosPrincipal clientPrincipal;
        private KerberosTime clientTime;
        private int clientMicroSeconds;

        public ReplayCacheEntry(KerberosPrincipal serverPrincipal, KerberosPrincipal clientPrincipal, KerberosTime clientTime, int clientMicroSeconds) {
            this.serverPrincipal = serverPrincipal;
            this.clientPrincipal = clientPrincipal;
            this.clientTime = clientTime;
            this.clientMicroSeconds = clientMicroSeconds;
        }

        public boolean equals(ReplayCacheEntry that) {
            return this.serverPrincipal.equals(that.serverPrincipal) && this.clientPrincipal.equals(that.clientPrincipal) && this.clientTime.equals(that.clientTime) && this.clientMicroSeconds == that.clientMicroSeconds;
        }

        public boolean isOutsideClockSkew(long clockSkew) {
            return !this.clientTime.isInClockSkew(clockSkew);
        }
    }
}

