/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.convert.plugins.text.extractors;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class Xml2TextHandler
extends DefaultHandler {
    protected static final SAXParserFactory factory = SAXParserFactory.newInstance();
    protected SAXParser parser = factory.newSAXParser();
    protected StringBuffer buf;
    protected boolean trim = false;

    public Xml2TextHandler() throws SAXException, ParserConfigurationException {
        XMLReader reader = this.parser.getXMLReader();
        reader.setFeature("http://xml.org/sax/features/validation", false);
        reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
    }

    public SAXParser getParser() {
        return this.parser;
    }

    public String parse(File file) throws SAXException, IOException {
        this.parser.parse(file, (DefaultHandler)this);
        String text = this.buf.toString();
        this.buf = null;
        return text;
    }

    public String parse(InputStream in) throws SAXException, IOException {
        this.parser.parse(in, (DefaultHandler)this);
        String text = this.buf.toString();
        this.buf = null;
        return text;
    }

    public String parse(InputSource is) throws SAXException, IOException {
        this.parser.parse(is, (DefaultHandler)this);
        String text = this.buf.toString();
        this.buf = null;
        return text;
    }

    public String getText() {
        return this.buf.toString();
    }

    @Override
    public void startDocument() throws SAXException {
        this.trim = false;
        this.buf = new StringBuffer();
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        this.trim = true;
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        this.trim = true;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.trim) {
            int i;
            int end = start + length;
            for (i = start; i < end && Character.isWhitespace(ch[i]); ++i) {
            }
            this.buf.append(" ").append(ch, i, length - i + start);
            this.trim = false;
        } else {
            this.buf.append(ch, start, length);
        }
    }

    static {
        factory.setValidating(false);
        factory.setNamespaceAware(false);
    }
}

