/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.normalization;

import java.util.Iterator;
import java.util.List;
import javax.naming.NamingException;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.shared.ldap.filter.AssertionEnum;
import org.apache.directory.shared.ldap.filter.BranchNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.ExtensibleNode;
import org.apache.directory.shared.ldap.filter.FilterVisitor;
import org.apache.directory.shared.ldap.filter.LeafNode;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.filter.SimpleNode;
import org.apache.directory.shared.ldap.filter.SubstringNode;
import org.apache.directory.shared.ldap.schema.AttributeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpandingVisitor
implements FilterVisitor {
    private final AttributeTypeRegistry attrRegistry;

    public ExpandingVisitor(AttributeTypeRegistry attrRegistry) {
        this.attrRegistry = attrRegistry;
    }

    public boolean canVisit(ExprNode node) {
        return node instanceof BranchNode;
    }

    public List<ExprNode> getOrder(BranchNode node, List<ExprNode> children) {
        return children;
    }

    public boolean isPrefix() {
        return false;
    }

    public void visit(ExprNode node) {
        BranchNode bnode = (BranchNode)node;
        List children = bnode.getChildren();
        int limit = children.size();
        for (int ii = 0; ii < limit; ++ii) {
            ExprNode child = (ExprNode)children.get(ii);
            if (child instanceof LeafNode) {
                LeafNode leaf = (LeafNode)child;
                try {
                    if (!this.attrRegistry.hasDescendants(leaf.getAttribute())) continue;
                    BranchNode orNode = new BranchNode(AssertionEnum.OR);
                    orNode.getChildren().add(leaf);
                    children.set(ii, orNode);
                    Iterator descendants = this.attrRegistry.descendants(leaf.getAttribute());
                    while (descendants.hasNext()) {
                        PresenceNode newLeaf = null;
                        AttributeType descendant = (AttributeType)descendants.next();
                        switch (leaf.getAssertionType()) {
                            case EXTENSIBLE: {
                                ExtensibleNode extensibleNode = (ExtensibleNode)leaf;
                                newLeaf = new ExtensibleNode(descendant.getOid(), extensibleNode.getValue(), extensibleNode.getMatchingRuleId(), extensibleNode.dnAttributes());
                                break;
                            }
                            case PRESENCE: {
                                newLeaf = new PresenceNode(descendant.getOid());
                                break;
                            }
                            case SUBSTRING: {
                                SubstringNode substringNode = (SubstringNode)leaf;
                                newLeaf = new SubstringNode(descendant.getOid(), substringNode.getInitial(), substringNode.getFinal());
                                break;
                            }
                            case APPROXIMATE: 
                            case EQUALITY: 
                            case GREATEREQ: 
                            case LESSEQ: {
                                SimpleNode simpleNode = (SimpleNode)leaf;
                                if (simpleNode.getValue() instanceof String) {
                                    newLeaf = new SimpleNode(descendant.getOid(), (String)simpleNode.getValue(), simpleNode.getAssertionType());
                                    break;
                                }
                                if (simpleNode.getValue() instanceof byte[]) {
                                    newLeaf = new SimpleNode(descendant.getOid(), (byte[])simpleNode.getValue(), simpleNode.getAssertionType());
                                    break;
                                }
                                newLeaf = new SimpleNode(descendant.getOid(), simpleNode.getValue().toString(), simpleNode.getAssertionType());
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unknown assertion type: " + leaf.getAssertionType());
                            }
                        }
                        orNode.addNode((ExprNode)newLeaf);
                    }
                    continue;
                }
                catch (NamingException e) {
                    e.printStackTrace();
                    throw new RuntimeException("Failed to expand node");
                }
            }
            this.visit(child);
        }
    }
}

