/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.core.TimerContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.resource.ResourceException;
import javax.resource.cci.ConnectionMetaData;
import javax.resource.cci.Interaction;
import javax.resource.cci.LocalTransaction;
import javax.resource.cci.ResultSetInfo;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.impl.EventContextImpl;
import org.nuxeo.ecm.core.event.impl.EventImpl;
import org.nuxeo.ecm.core.query.QueryFilter;
import org.nuxeo.ecm.core.storage.Credentials;
import org.nuxeo.ecm.core.storage.PartialList;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.ACLRow;
import org.nuxeo.ecm.core.storage.sql.Binary;
import org.nuxeo.ecm.core.storage.sql.BinaryGarbageCollector;
import org.nuxeo.ecm.core.storage.sql.BinaryManager;
import org.nuxeo.ecm.core.storage.sql.BinaryManagerStreamSupport;
import org.nuxeo.ecm.core.storage.sql.CachingMapper;
import org.nuxeo.ecm.core.storage.sql.Fragment;
import org.nuxeo.ecm.core.storage.sql.FragmentGroup;
import org.nuxeo.ecm.core.storage.sql.FragmentsMap;
import org.nuxeo.ecm.core.storage.sql.FulltextExtractorWork;
import org.nuxeo.ecm.core.storage.sql.FulltextParser;
import org.nuxeo.ecm.core.storage.sql.FulltextUpdaterWork;
import org.nuxeo.ecm.core.storage.sql.Invalidations;
import org.nuxeo.ecm.core.storage.sql.Mapper;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.Node;
import org.nuxeo.ecm.core.storage.sql.PersistenceContext;
import org.nuxeo.ecm.core.storage.sql.RepositoryImpl;
import org.nuxeo.ecm.core.storage.sql.Row;
import org.nuxeo.ecm.core.storage.sql.RowId;
import org.nuxeo.ecm.core.storage.sql.RowMapper;
import org.nuxeo.ecm.core.storage.sql.Session;
import org.nuxeo.ecm.core.storage.sql.SimpleFragment;
import org.nuxeo.ecm.core.storage.sql.SimpleProperty;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.streaming.FileSource;

public class SessionImpl
implements Session,
XAResource {
    private static final Log log = LogFactory.getLog(SessionImpl.class);
    public static final String COMPAT_REPOSITORY_NAME_KEY = "org.nuxeo.vcs.repository.name.default.compat";
    private static final boolean COMPAT_REPOSITORY_NAME = Boolean.parseBoolean(Framework.getProperty((String)"org.nuxeo.vcs.repository.name.default.compat", (String)"true"));
    private final RepositoryImpl repository;
    private final Mapper mapper;
    private final Model model;
    protected final FulltextParser fulltextParser;
    public final PersistenceContext context;
    private boolean live;
    private boolean inTransaction;
    private Node rootNode;
    private long threadId;
    private boolean readAclsChanged;
    private String threadName;
    private final Counter sessionCount = Metrics.defaultRegistry().newCounter(this.getClass(), "session");
    private final Timer saveTimer = Metrics.defaultRegistry().newTimer(this.getClass(), "save", TimeUnit.MICROSECONDS, TimeUnit.SECONDS);
    private final Timer queryTimer = Metrics.defaultRegistry().newTimer(this.getClass(), "query", TimeUnit.MICROSECONDS, TimeUnit.SECONDS);
    private final Timer aclrUpdateTimer = Metrics.defaultRegistry().newTimer(this.getClass(), "aclr-update", TimeUnit.MICROSECONDS, TimeUnit.SECONDS);

    public SessionImpl(RepositoryImpl repository, Model model, Mapper mapper, Credentials credentials) throws StorageException {
        this.repository = repository;
        this.mapper = mapper;
        if (mapper instanceof CachingMapper) {
            ((CachingMapper)mapper).setSession(this);
        }
        this.model = model;
        this.context = new PersistenceContext(model, mapper, this);
        this.live = true;
        this.readAclsChanged = false;
        try {
            this.fulltextParser = repository.fulltextParserClass.newInstance();
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
        this.sessionCount.inc();
        this.computeRootNode();
    }

    private void checkLive() {
        if (!this.live) {
            throw new IllegalStateException("Session is not live");
        }
    }

    @Override
    public Mapper getMapper() {
        return this.mapper;
    }

    public XAResource getXAResource() {
        return this;
    }

    protected int clearCaches() {
        if (this.inTransaction) {
            return 0;
        }
        this.checkThreadEnd();
        return this.context.clearCaches();
    }

    protected void rollback() {
        this.context.clearCaches();
    }

    protected void checkThread() {
        if (this.threadId == 0L) {
            return;
        }
        long currentThreadId = Thread.currentThread().getId();
        if (this.threadId == currentThreadId) {
            return;
        }
        String currentThreadName = Thread.currentThread().getName();
        String msg = String.format("Concurrency Error: Session was started in thread %s (%s) but is being used in thread %s (%s)", this.threadId, this.threadName, currentThreadId, currentThreadName);
        log.debug((Object)msg, (Throwable)new Exception(msg));
    }

    protected void checkThreadStart() {
        this.threadId = Thread.currentThread().getId();
        this.threadName = Thread.currentThread().getName();
    }

    protected void checkThreadEnd() {
        this.threadId = 0L;
    }

    protected Serializable generateNewId(Serializable id) throws StorageException {
        return this.context.generateNewId(id);
    }

    protected boolean isIdNew(Serializable id) {
        return this.context.isIdNew(id);
    }

    public void close() throws ResourceException {
        try {
            this.closeSession();
        }
        catch (StorageException e) {
            throw new ResourceException((Throwable)((Object)e));
        }
        this.repository.closeSession(this);
    }

    protected void closeSession() throws StorageException {
        this.live = false;
        this.mapper.close();
        this.sessionCount.dec();
    }

    public Interaction createInteraction() throws ResourceException {
        throw new UnsupportedOperationException();
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        throw new UnsupportedOperationException();
    }

    public ConnectionMetaData getMetaData() throws ResourceException {
        throw new UnsupportedOperationException();
    }

    public ResultSetInfo getResultSetInfo() throws ResourceException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isLive() {
        return this.live;
    }

    @Override
    public String getRepositoryName() {
        return this.repository.getName();
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public Node getRootNode() {
        this.checkThread();
        this.checkLive();
        return this.rootNode;
    }

    @Override
    public Binary getBinary(FileSource source) throws StorageException {
        BinaryManager mgr = this.repository.getBinaryManager();
        try {
            if (mgr instanceof BinaryManagerStreamSupport) {
                return ((BinaryManagerStreamSupport)((Object)mgr)).getBinary(source);
            }
            return mgr.getBinary(source.getStream());
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public Binary getBinary(InputStream in) throws StorageException {
        BinaryManager mgr = this.repository.getBinaryManager();
        try {
            return mgr.getBinary(in);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() throws StorageException {
        TimerContext timerContext = this.saveTimer.time();
        try {
            this.checkLive();
            this.flush();
            if (!this.inTransaction) {
                this.sendInvalidationsToOthers();
                this.processReceivedInvalidations();
            }
        }
        finally {
            timerContext.stop();
        }
    }

    protected void flush() throws StorageException {
        this.checkThread();
        List<Object> works = !this.repository.getRepositoryDescriptor().fulltextDisabled ? this.getFulltextWork() : Collections.emptyList();
        this.doFlush();
        this.scheduleWork(works);
        this.checkInvalidationsConflict();
    }

    protected void scheduleWork(List<Work> works) {
        RepositoryManager repositoryManager = (RepositoryManager)Framework.getLocalService(RepositoryManager.class);
        if (repositoryManager != null && !works.isEmpty()) {
            WorkManager workManager = (WorkManager)Framework.getLocalService(WorkManager.class);
            for (Work work : works) {
                workManager.schedule(work, true);
            }
        }
    }

    protected void doFlush() throws StorageException {
        RowMapper.RowBatch batch = this.context.getSaveBatch();
        if (!batch.isEmpty() || this.readAclsChanged) {
            log.debug((Object)"Saving session");
            if (!batch.isEmpty()) {
                this.mapper.write(batch);
            }
            if (this.readAclsChanged) {
                this.updateReadAcls();
            }
            log.debug((Object)"End of save");
        }
    }

    protected Serializable getContainingDocument(Serializable id) throws StorageException {
        return this.context.getContainingDocument(id);
    }

    protected List<Work> getFulltextWork() throws StorageException {
        HashSet<Serializable> dirtyStrings = new HashSet<Serializable>();
        HashSet<Serializable> dirtyBinaries = new HashSet<Serializable>();
        this.context.findDirtyDocuments(dirtyStrings, dirtyBinaries);
        if (dirtyStrings.isEmpty() && dirtyBinaries.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<Work> works = new LinkedList<Work>();
        Work work = this.getFulltextSimpleWork(dirtyStrings);
        if (work != null) {
            works.add(work);
        }
        if ((work = this.getFulltextBinariesWork(dirtyBinaries)) != null) {
            works.add(work);
        }
        return works;
    }

    protected Work getFulltextSimpleWork(Set<Serializable> dirtyStrings) throws StorageException {
        ArrayList<FulltextUpdaterWork.FulltextUpdaterInfo> infos = new ArrayList<FulltextUpdaterWork.FulltextUpdaterInfo>();
        for (Serializable docId : dirtyStrings) {
            if (docId == null) {
                log.error((Object)"Got null doc id in fulltext update, cannot happen");
                continue;
            }
            Node document = this.getNodeById(docId);
            if (document == null || document.isProxy()) continue;
            String documentType = document.getPrimaryType();
            String[] mixinTypes = document.getMixinTypes();
            if (!this.model.getFulltextInfo().isFulltextIndexable(documentType)) continue;
            document.getSimpleProperty("ecm:fulltextJobId").setValue((Serializable)((Object)this.model.idToString(document.getId())));
            this.fulltextParser.setDocument(document, this);
            for (String indexName : this.model.getFulltextInfo().indexNames) {
                Set<String> paths = this.model.getFulltextInfo().indexesAllSimple.contains(indexName) ? this.model.getSimpleTextPropertyPaths(documentType, mixinTypes) : this.model.getFulltextInfo().propPathsByIndexSimple.get(indexName);
                String text = this.fulltextParser.findFulltext(indexName, paths);
                FulltextUpdaterWork.FulltextUpdaterInfo info = new FulltextUpdaterWork.FulltextUpdaterInfo();
                info.docId = this.model.idToString(docId);
                info.indexName = indexName;
                info.text = text;
                infos.add(info);
            }
        }
        if (infos.isEmpty()) {
            return null;
        }
        FulltextUpdaterWork work = new FulltextUpdaterWork(true, this.repository.getName(), infos);
        return work;
    }

    protected Work getFulltextBinariesWork(Set<Serializable> dirtyBinaries) throws StorageException {
        if (dirtyBinaries.isEmpty()) {
            return null;
        }
        for (Node node : this.getNodesByIds(new ArrayList<Serializable>(dirtyBinaries))) {
            if (!this.model.getFulltextInfo().isFulltextIndexable(node.getPrimaryType())) continue;
            node.getSimpleProperty("ecm:fulltextJobId").setValue((Serializable)((Object)this.model.idToString(node.getId())));
        }
        HashSet<String> set = new HashSet<String>();
        for (Serializable id : dirtyBinaries) {
            set.add(this.model.idToString(id));
        }
        FulltextExtractorWork work = new FulltextExtractorWork(this.repository.getName(), set);
        return work;
    }

    protected void sendInvalidationsToOthers() throws StorageException {
        this.context.sendInvalidationsToOthers();
    }

    protected void processReceivedInvalidations() throws StorageException {
        this.context.processReceivedInvalidations();
    }

    protected void checkInvalidationsConflict() throws StorageException {
        this.context.checkInvalidationsConflict();
    }

    protected void collectModified(Invalidations invalidations, Set<String> docs, Set<String> parents) {
        if (invalidations == null || invalidations.modified == null) {
            return;
        }
        for (RowId rowId : invalidations.modified) {
            Serializable docId;
            Serializable id = rowId.id;
            try {
                docId = this.getContainingDocument(id);
            }
            catch (StorageException e) {
                log.error((Object)("Cannot get containing document for: " + id), (Throwable)((Object)e));
                docId = null;
            }
            if (docId == null) continue;
            if ("__PARENT__".equals(rowId.tableName)) {
                if (docId.equals(id)) {
                    parents.add(this.model.idToString(docId));
                    continue;
                }
                docs.add(this.model.idToString(docId));
                continue;
            }
            docs.add(this.model.idToString(docId));
        }
    }

    protected void sendInvalidationEvent(Invalidations invalidations, boolean local) {
        this.sendInvalidationEvent(new Invalidations.InvalidationsPair(invalidations, null));
    }

    protected void sendInvalidationEvent(Invalidations.InvalidationsPair pair) {
        if (!this.repository.repositoryDescriptor.sendInvalidationEvents) {
            return;
        }
        HashSet<String> modifiedDocIds = new HashSet<String>();
        HashSet<String> modifiedParentIds = new HashSet<String>();
        this.collectModified(pair.cacheInvalidations, modifiedDocIds, modifiedParentIds);
        this.collectModified(pair.eventInvalidations, modifiedDocIds, modifiedParentIds);
        if (modifiedDocIds.isEmpty() && modifiedParentIds.isEmpty()) {
            return;
        }
        EventContextImpl ctx = new EventContextImpl(null, null);
        ctx.setRepositoryName(this.repository.getName());
        ctx.setProperty("modifiedDocIds", modifiedDocIds);
        ctx.setProperty("modifiedParentIds", modifiedParentIds);
        EventImpl event = new EventImpl("vcsInvalidations", (EventContext)ctx);
        try {
            this.repository.eventService.fireEvent((Event)event);
        }
        catch (ClientException e) {
            log.error((Object)("Failed to send invalidation event: " + (Object)((Object)e)), (Throwable)e);
        }
    }

    protected Node getNodeById(Serializable id, boolean prefetch) throws StorageException {
        List<Node> nodes = this.getNodesByIds(Collections.singletonList(id), prefetch);
        Node node = nodes.get(0);
        return node;
    }

    @Override
    public Node getNodeById(Serializable id) throws StorageException {
        this.checkThread();
        this.checkLive();
        if (id == null) {
            throw new IllegalArgumentException("Illegal null id");
        }
        return this.getNodeById(id, true);
    }

    public List<Node> getNodesByIds(List<Serializable> ids, boolean prefetch) throws StorageException {
        Serializable id;
        ArrayList<RowId> hierRowIds = new ArrayList<RowId>(ids.size());
        for (Serializable id2 : ids) {
            hierRowIds.add(new RowId("hierarchy", id2));
        }
        List<Fragment> hierFragments = this.context.getMulti(hierRowIds, false);
        HashMap<Serializable, String> paths = new HashMap<Serializable, String>();
        HashSet<Serializable> parentIds = new HashSet<Serializable>();
        for (Fragment fragment : hierFragments) {
            id = fragment.getId();
            PersistenceContext.PathAndId pathOrId = this.context.getPathOrMissingParentId((SimpleFragment)fragment, false);
            if (pathOrId.path != null) {
                paths.put(id, pathOrId.path);
                continue;
            }
            parentIds.add(pathOrId.id);
        }
        if (!parentIds.isEmpty()) {
            this.getHierarchyAndAncestors(parentIds);
            for (Fragment fragment : hierFragments) {
                id = fragment.getId();
                if (paths.containsKey(id)) continue;
                String path = this.context.getPath((SimpleFragment)fragment);
                paths.put(id, path);
            }
        }
        HashMap<Serializable, FragmentGroup> fragmentGroups = new HashMap<Serializable, FragmentGroup>(ids.size());
        for (Fragment fragment : hierFragments) {
            Serializable id3 = fragment.row.id;
            fragmentGroups.put(id3, new FragmentGroup((SimpleFragment)fragment, new FragmentsMap()));
        }
        if (prefetch) {
            ArrayList<RowId> bulkRowIds = new ArrayList<RowId>();
            HashSet<Serializable> proxyIds = new HashSet<Serializable>();
            for (Fragment fragment : hierFragments) {
                this.findPrefetchedFragments((SimpleFragment)fragment, bulkRowIds, proxyIds);
            }
            ArrayList<RowId> proxiesRowIds = new ArrayList<RowId>(proxyIds.size());
            for (Serializable id4 : proxyIds) {
                proxiesRowIds.add(new RowId("proxies", id4));
            }
            List<Fragment> proxiesFragments = this.context.getMulti(proxiesRowIds, true);
            HashSet<Serializable> targetIds = new HashSet<Serializable>();
            for (Fragment fragment : proxiesFragments) {
                Serializable targetId = ((SimpleFragment)fragment).get("targetid");
                targetIds.add(targetId);
            }
            targetIds.removeAll(ids);
            hierRowIds = new ArrayList(targetIds.size());
            for (Serializable id5 : targetIds) {
                hierRowIds.add(new RowId("hierarchy", id5));
            }
            hierFragments = this.context.getMulti(hierRowIds, true);
            for (Fragment fragment : hierFragments) {
                this.findPrefetchedFragments((SimpleFragment)fragment, bulkRowIds, null);
            }
            List<Fragment> fragments = this.context.getMulti(bulkRowIds, true);
            for (Fragment fragment : fragments) {
                FragmentGroup fragmentGroup = (FragmentGroup)fragmentGroups.get(fragment.row.id);
                if (fragmentGroup == null) continue;
                fragmentGroup.fragments.put(fragment.row.tableName, fragment);
            }
        }
        ArrayList<Node> nodes = new ArrayList<Node>(ids.size());
        for (Serializable id3 : ids) {
            FragmentGroup fragmentGroup = (FragmentGroup)fragmentGroups.get(id3);
            Node node = fragmentGroup == null ? null : new Node(this.context, fragmentGroup, (String)paths.get(id3));
            nodes.add(node);
        }
        return nodes;
    }

    protected void findPrefetchedFragments(SimpleFragment hierFragment, List<RowId> bulkRowIds, Set<Serializable> proxyIds) throws StorageException {
        Serializable id = hierFragment.row.id;
        String typeName = (String)((Object)hierFragment.get("primarytype"));
        if ("ecm:proxy".equals(typeName)) {
            if (proxyIds != null) {
                proxyIds.add(id);
            }
            return;
        }
        Set<String> tableNames = this.model.getTypePrefetchedFragments(typeName);
        if (tableNames == null) {
            return;
        }
        Serializable parentId = hierFragment.get("parentid");
        for (String tableName : tableNames) {
            if ("hierarchy".equals(tableName)) continue;
            if (parentId != null) {
                if ("versions".equals(tableName)) continue;
            }
            bulkRowIds.add(new RowId(tableName, id));
        }
    }

    @Override
    public List<Node> getNodesByIds(List<Serializable> ids) throws StorageException {
        this.checkThread();
        this.checkLive();
        return this.getNodesByIds(ids, true);
    }

    @Override
    public Node getParentNode(Node node) throws StorageException {
        this.checkLive();
        if (node == null) {
            throw new IllegalArgumentException("Illegal null node");
        }
        Serializable id = node.getHierFragment().get("parentid");
        return id == null ? null : this.getNodeById(id);
    }

    @Override
    public String getPath(Node node) throws StorageException {
        this.checkLive();
        String path = node.getPath();
        if (path == null) {
            path = this.context.getPath(node.getHierFragment());
        }
        return path;
    }

    @Override
    public Node getNodeByPath(String path, Node node) throws StorageException {
        int i;
        this.checkLive();
        if (path == null) {
            throw new IllegalArgumentException("Illegal null path");
        }
        if ((path = Normalizer.normalize(path, Normalizer.Form.NFKC)).startsWith("/")) {
            node = this.getRootNode();
            if (path.equals("/")) {
                return node;
            }
            i = 1;
        } else {
            if (node == null) {
                throw new IllegalArgumentException("Illegal relative path with null node: " + path);
            }
            i = 0;
        }
        String[] names = path.split("/", -1);
        while (i < names.length) {
            String name = names[i];
            if (name.length() == 0) {
                throw new IllegalArgumentException("Illegal path with empty component: " + path);
            }
            if ((node = this.getChildNode(node, name, false)) == null) {
                return null;
            }
            ++i;
        }
        return node;
    }

    @Override
    public Node addChildNode(Node parent, String name, Long pos, String typeName, boolean complexProp) throws StorageException {
        if (pos == null && !complexProp && parent != null) {
            pos = this.context.getNextPos(parent.getId(), complexProp);
        }
        return this.addChildNode(null, parent, name, pos, typeName, complexProp);
    }

    @Override
    public Node addChildNode(Serializable id, Node parent, String name, Long pos, String typeName, boolean complexProp) throws StorageException {
        this.checkLive();
        if (name == null) {
            throw new IllegalArgumentException("Illegal null name");
        }
        if ((name = Normalizer.normalize(name, Normalizer.Form.NFKC)).contains("/") || name.equals(".") || name.equals("..")) {
            throw new IllegalArgumentException("Illegal name: " + name);
        }
        if (!this.model.isType(typeName)) {
            throw new IllegalArgumentException("Unknown type: " + typeName);
        }
        id = this.generateNewId(id);
        Serializable parentId = parent == null ? null : parent.hierFragment.getId();
        return this.addNode(id, parentId, name, pos, typeName, complexProp);
    }

    protected Node addNode(Serializable id, Serializable parentId, String name, Long pos, String typeName, boolean complexProp) throws StorageException {
        this.requireReadAclsUpdate();
        Row hierRow = new Row("hierarchy", id);
        hierRow.putNew("parentid", parentId);
        hierRow.putNew("name", (Serializable)((Object)name));
        hierRow.putNew("pos", pos);
        hierRow.putNew("primarytype", (Serializable)((Object)typeName));
        hierRow.putNew("isproperty", Boolean.valueOf(complexProp));
        SimpleFragment hierFragment = this.context.createHierarchyFragment(hierRow);
        FragmentGroup fragmentGroup = new FragmentGroup(hierFragment, new FragmentsMap());
        return new Node(this.context, fragmentGroup, this.context.getPath(hierFragment));
    }

    @Override
    public Node addProxy(Serializable targetId, Serializable versionableId, Node parent, String name, Long pos) throws StorageException {
        if (!this.repository.getRepositoryDescriptor().proxiesEnabled) {
            throw new StorageException("Proxies are disabled by configuration");
        }
        Node proxy = this.addChildNode(parent, name, pos, "ecm:proxy", false);
        proxy.setSimpleProperty("ecm:proxyTargetId", targetId);
        proxy.setSimpleProperty("ecm:proxyVersionableId", versionableId);
        SimpleFragment proxyFragment = (SimpleFragment)proxy.fragments.get("proxies");
        this.context.createdProxyFragment(proxyFragment);
        return proxy;
    }

    @Override
    public void setProxyTarget(Node proxy, Serializable targetId) throws StorageException {
        if (!this.repository.getRepositoryDescriptor().proxiesEnabled) {
            throw new StorageException("Proxies are disabled by configuration");
        }
        SimpleProperty prop = proxy.getSimpleProperty("ecm:proxyTargetId");
        Serializable oldTargetId = prop.getValue();
        if (!oldTargetId.equals(targetId)) {
            SimpleFragment proxyFragment = (SimpleFragment)proxy.fragments.get("proxies");
            this.context.removedProxyTarget(proxyFragment);
            proxy.setSimpleProperty("ecm:proxyTargetId", targetId);
            this.context.addedProxyTarget(proxyFragment);
        }
    }

    @Override
    public boolean hasChildNode(Node parent, String name, boolean complexProp) throws StorageException {
        this.checkLive();
        SimpleFragment fragment = this.context.getChildHierByName(parent.getId(), name, complexProp);
        return fragment != null;
    }

    @Override
    public Node getChildNode(Node parent, String name, boolean complexProp) throws StorageException {
        this.checkLive();
        if (name == null || name.contains("/") || name.equals(".") || name.equals("..")) {
            throw new IllegalArgumentException("Illegal name: " + name);
        }
        SimpleFragment fragment = this.context.getChildHierByName(parent.getId(), name, complexProp);
        return fragment == null ? null : this.getNodeById(fragment.getId());
    }

    @Override
    public boolean hasChildren(Node parent, boolean complexProp) throws StorageException {
        this.checkLive();
        List<SimpleFragment> children = this.context.getChildren(parent.getId(), null, complexProp);
        return children.size() > 0;
    }

    @Override
    public List<Node> getChildren(Node parent, String name, boolean complexProp) throws StorageException {
        this.checkLive();
        List<SimpleFragment> fragments = this.context.getChildren(parent.getId(), name, complexProp);
        ArrayList<Node> nodes = new ArrayList<Node>(fragments.size());
        for (SimpleFragment fragment : fragments) {
            Node node = this.getNodeById(fragment.getId());
            if (node == null) {
                log.error((Object)("Child node cannot be created: " + fragment.getId()));
                continue;
            }
            nodes.add(node);
        }
        return nodes;
    }

    @Override
    public void orderBefore(Node parent, Node source, Node dest) throws StorageException {
        this.checkLive();
        this.context.orderBefore(parent.getId(), source.getId(), dest == null ? null : dest.getId());
    }

    @Override
    public Node move(Node source, Node parent, String name) throws StorageException {
        this.checkLive();
        if (!parent.getId().equals(source.getParentId())) {
            this.flush();
        }
        this.context.move(source, parent.getId(), name);
        this.requireReadAclsUpdate();
        return source;
    }

    @Override
    public Node copy(Node source, Node parent, String name) throws StorageException {
        this.checkLive();
        this.flush();
        Serializable id = this.context.copy(source, parent.getId(), name);
        this.requireReadAclsUpdate();
        return this.getNodeById(id);
    }

    @Override
    public void removeNode(Node node) throws StorageException {
        this.checkLive();
        this.flush();
        this.context.removeNode(node.getHierFragment());
    }

    @Override
    public void removePropertyNode(Node node) throws StorageException {
        this.checkLive();
        this.context.removePropertyNode(node.getHierFragment());
    }

    @Override
    public Node checkIn(Node node, String label, String checkinComment) throws StorageException {
        this.checkLive();
        this.flush();
        Serializable id = this.context.checkIn(node, label, checkinComment);
        this.requireReadAclsUpdate();
        this.flush();
        return this.getNodeById(id);
    }

    @Override
    public void checkOut(Node node) throws StorageException {
        this.checkLive();
        this.context.checkOut(node);
        this.requireReadAclsUpdate();
    }

    @Override
    public void restore(Node node, Node version) throws StorageException {
        this.checkLive();
        this.context.restoreVersion(node, version);
        this.requireReadAclsUpdate();
    }

    @Override
    public Node getVersionByLabel(Serializable versionSeriesId, String label) throws StorageException {
        if (label == null) {
            return null;
        }
        List<Node> versions = this.getVersions(versionSeriesId);
        for (Node node : versions) {
            String l = (String)((Object)node.getSimpleProperty("ecm:versionLabel").getValue());
            if (!label.equals(l)) continue;
            return node;
        }
        return null;
    }

    @Override
    public Node getLastVersion(Serializable versionSeriesId) throws StorageException {
        this.checkLive();
        List<Serializable> ids = this.context.getVersionIds(versionSeriesId);
        return ids.isEmpty() ? null : this.getNodeById(ids.get(ids.size() - 1));
    }

    @Override
    public List<Node> getVersions(Serializable versionSeriesId) throws StorageException {
        this.checkLive();
        List<Serializable> ids = this.context.getVersionIds(versionSeriesId);
        ArrayList<Node> nodes = new ArrayList<Node>(ids.size());
        for (Serializable id : ids) {
            nodes.add(this.getNodeById(id));
        }
        return nodes;
    }

    @Override
    public List<Node> getProxies(Node document, Node parent) throws StorageException {
        Node node;
        List<Serializable> ids;
        this.checkLive();
        if (!this.repository.getRepositoryDescriptor().proxiesEnabled) {
            return Collections.emptyList();
        }
        if (document.isVersion()) {
            ids = this.context.getTargetProxyIds(document.getId());
        } else {
            Serializable versionSeriesId = document.isProxy() ? document.getSimpleProperty("ecm:proxyVersionableId").getValue() : document.getId();
            ids = this.context.getSeriesProxyIds(versionSeriesId);
        }
        LinkedList<Node> nodes = new LinkedList<Node>();
        for (Serializable id : ids) {
            node = this.getNodeById(id);
            if (node == null && !Boolean.TRUE.booleanValue()) continue;
            nodes.add(node);
        }
        if (parent != null) {
            Serializable parentId = parent.getId();
            Iterator it = nodes.iterator();
            while (it.hasNext()) {
                node = (Node)it.next();
                if (parentId.equals(node.getParentId())) continue;
                it.remove();
            }
        }
        return nodes;
    }

    protected List<Fragment> getHierarchyAndAncestors(Collection<Serializable> ids) throws StorageException {
        Set<Serializable> allIds = this.mapper.getAncestorsIds(ids);
        allIds.addAll(ids);
        ArrayList<RowId> rowIds = new ArrayList<RowId>(allIds.size());
        for (Serializable id : allIds) {
            rowIds.add(new RowId("hierarchy", id));
        }
        return this.context.getMulti(rowIds, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PartialList<Serializable> query(String query, QueryFilter queryFilter, boolean countTotal) throws StorageException {
        TimerContext timerContext = this.queryTimer.time();
        try {
            PartialList<Serializable> partialList = this.mapper.query(query, "NXQL", queryFilter, countTotal);
            return partialList;
        }
        finally {
            timerContext.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PartialList<Serializable> query(String query, String queryType, QueryFilter queryFilter, boolean countTotal) throws StorageException {
        TimerContext timerContext = this.queryTimer.time();
        try {
            PartialList<Serializable> partialList = this.mapper.query(query, queryType, queryFilter, countTotal);
            return partialList;
        }
        finally {
            timerContext.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PartialList<Serializable> query(String query, String queryType, QueryFilter queryFilter, long countUpTo) throws StorageException {
        TimerContext timerContext = this.queryTimer.time();
        try {
            PartialList<Serializable> partialList = this.mapper.query(query, queryType, queryFilter, countUpTo);
            return partialList;
        }
        finally {
            timerContext.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IterableQueryResult queryAndFetch(String query, String queryType, QueryFilter queryFilter, Object ... params) throws StorageException {
        TimerContext timerContext = this.queryTimer.time();
        try {
            IterableQueryResult iterableQueryResult = this.mapper.queryAndFetch(query, queryType, queryFilter, params);
            return iterableQueryResult;
        }
        finally {
            timerContext.stop();
        }
    }

    @Override
    public Lock getLock(Serializable id) throws StorageException {
        return this.repository.getLockManager().getLock(id);
    }

    @Override
    public Lock setLock(Serializable id, Lock lock) throws StorageException {
        if (lock == null) {
            throw new NullPointerException("Attempt to use null lock on: " + id);
        }
        return this.repository.getLockManager().setLock(id, lock);
    }

    @Override
    public Lock removeLock(Serializable id, String owner, boolean force) throws StorageException {
        return this.repository.getLockManager().removeLock(id, owner);
    }

    @Override
    public void requireReadAclsUpdate() {
        this.readAclsChanged = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateReadAcls() throws StorageException {
        TimerContext timerContext = this.aclrUpdateTimer.time();
        try {
            this.mapper.updateReadAcls();
            this.readAclsChanged = false;
        }
        finally {
            timerContext.stop();
        }
    }

    @Override
    public void rebuildReadAcls() throws StorageException {
        this.mapper.rebuildReadAcls();
        this.readAclsChanged = false;
    }

    private void computeRootNode() throws StorageException {
        String repositoryId = this.repository.getName();
        Serializable rootId = this.mapper.getRootId(repositoryId);
        if (rootId == null && COMPAT_REPOSITORY_NAME) {
            rootId = this.mapper.getRootId("default");
        }
        if (rootId == null) {
            log.debug((Object)"Creating root");
            this.rootNode = this.addRootNode();
            this.addRootACP();
            this.save();
            this.mapper.setRootId((Serializable)((Object)repositoryId), this.rootNode.getId());
        } else {
            this.rootNode = this.getNodeById(rootId, false);
        }
    }

    private Node addRootNode() throws StorageException {
        Serializable id = this.generateNewId(null);
        return this.addNode(id, null, "", null, "Root", false);
    }

    private void addRootACP() throws StorageException {
        Serializable[] aclrows = new ACLRow[]{new ACLRow(0, "local", true, "Everything", "administrators", null), new ACLRow(1, "local", true, "Everything", "Administrator", null), new ACLRow(2, "local", true, "Read", "members", null)};
        this.rootNode.setCollectionProperty("ecm:acl", aclrows);
        this.requireReadAclsUpdate();
    }

    public void checkPermission(String absPath, String actions) throws StorageException {
        this.checkLive();
        throw new RuntimeException("Not implemented");
    }

    public boolean hasPendingChanges() throws StorageException {
        this.checkLive();
        throw new RuntimeException("Not implemented");
    }

    public void markReferencedBinaries(BinaryGarbageCollector gc) {
        this.checkLive();
        try {
            this.mapper.markReferencedBinaries(gc);
        }
        catch (StorageException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    public int cleanupDeletedDocuments(int max, Calendar beforeTime) {
        this.checkLive();
        if (!this.repository.getRepositoryDescriptor().softDeleteEnabled) {
            return 0;
        }
        try {
            return this.mapper.cleanupDeletedRows(max, beforeTime);
        }
        catch (StorageException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    @Override
    public boolean isSameRM(XAResource xaresource) {
        return xaresource == this;
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        if (flags == 0) {
            try {
                this.processReceivedInvalidations();
            }
            catch (Exception e) {
                log.error((Object)"Could not start transaction", (Throwable)e);
                throw (XAException)new XAException(-3).initCause(e);
            }
        }
        this.mapper.start(xid, flags);
        this.inTransaction = true;
        this.checkThreadStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end(Xid xid, int flags) throws XAException {
        boolean failed = true;
        try {
            if (flags != 0x20000000) {
                try {
                    this.flush();
                }
                catch (Exception e) {
                    String msg = "Could not end transaction";
                    if (e instanceof ConcurrentModificationException) {
                        log.debug((Object)msg, (Throwable)e);
                    } else {
                        log.error((Object)msg, (Throwable)e);
                    }
                    throw (XAException)new XAException(-3).initCause(e);
                }
            }
            failed = false;
            this.mapper.end(xid, flags);
        }
        finally {
            if (failed) {
                try {
                    this.mapper.end(xid, 0x20000000);
                }
                finally {
                    this.rollback(xid);
                }
            }
        }
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        int res = this.mapper.prepare(xid);
        if (res == 3) {
            this.commitDone();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            this.mapper.commit(xid, onePhase);
        }
        finally {
            this.commitDone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commitDone() throws XAException {
        this.inTransaction = false;
        try {
            try {
                this.sendInvalidationsToOthers();
            }
            finally {
                this.checkThreadEnd();
            }
        }
        catch (Exception e) {
            log.error((Object)"Could not send invalidations", (Throwable)e);
            throw (XAException)new XAException(-3).initCause(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Xid xid) throws XAException {
        try {
            try {
                this.mapper.rollback(xid);
            }
            finally {
                this.rollback();
            }
        }
        finally {
            this.inTransaction = false;
            this.checkThreadEnd();
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        this.mapper.forget(xid);
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        return this.mapper.recover(flag);
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        return this.mapper.setTransactionTimeout(seconds);
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.mapper.getTransactionTimeout();
    }
}

