/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc;

import java.io.Serializable;
import java.security.MessageDigest;
import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.sql.XADataSource;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.query.QueryFilter;
import org.nuxeo.ecm.core.storage.ConnectionResetException;
import org.nuxeo.ecm.core.storage.PartialList;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.BinaryGarbageCollector;
import org.nuxeo.ecm.core.storage.sql.ColumnType;
import org.nuxeo.ecm.core.storage.sql.Invalidations;
import org.nuxeo.ecm.core.storage.sql.LockManager;
import org.nuxeo.ecm.core.storage.sql.Mapper;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.RepositoryImpl;
import org.nuxeo.ecm.core.storage.sql.Row;
import org.nuxeo.ecm.core.storage.sql.RowId;
import org.nuxeo.ecm.core.storage.sql.Session;
import org.nuxeo.ecm.core.storage.sql.jdbc.ClusterNodeHandler;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCConnectionPropagator;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCRowMapper;
import org.nuxeo.ecm.core.storage.sql.jdbc.QueryMaker;
import org.nuxeo.ecm.core.storage.sql.jdbc.QueryMakerService;
import org.nuxeo.ecm.core.storage.sql.jdbc.ResultSetQueryResult;
import org.nuxeo.ecm.core.storage.sql.jdbc.SQLInfo;
import org.nuxeo.ecm.core.storage.sql.jdbc.TableUpgrader;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Database;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Table;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.Dialect;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.DialectOracle;
import org.nuxeo.runtime.api.Framework;

public class JDBCMapper
extends JDBCRowMapper
implements Mapper {
    private static final Log log = LogFactory.getLog(JDBCMapper.class);
    public static Map<String, Serializable> testProps = new HashMap<String, Serializable>();
    public static final String TEST_UPGRADE = "testUpgrade";
    public static final String TEST_UPGRADE_VERSIONS = "testUpgradeVersions";
    public static final String TEST_UPGRADE_LAST_CONTRIBUTOR = "testUpgradeLastContributor";
    public static final String TEST_UPGRADE_LOCKS = "testUpgradeLocks";
    public static final String TEST_UPGRADE_FULLTEXT = "testUpgradeFulltext";
    protected TableUpgrader tableUpgrader;
    private final QueryMakerService queryMakerService;
    private final Session.PathResolver pathResolver;
    private final RepositoryImpl repository;
    private boolean limitedResults;
    private long maxResults;

    public JDBCMapper(Model model, Session.PathResolver pathResolver, SQLInfo sqlInfo, XADataSource xadatasource, ClusterNodeHandler clusterNodeHandler, JDBCConnectionPropagator connectionPropagator, boolean noSharing, RepositoryImpl repository) throws StorageException {
        super(model, sqlInfo, xadatasource, clusterNodeHandler, connectionPropagator, noSharing);
        this.pathResolver = pathResolver;
        this.repository = repository;
        try {
            this.queryMakerService = (QueryMakerService)Framework.getService(QueryMakerService.class);
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
        this.tableUpgrader = new TableUpgrader(this);
        this.tableUpgrader.add("versions", "islatest", "upgradeVersions", TEST_UPGRADE_VERSIONS);
        this.tableUpgrader.add("dublincore", "lastContributor", "upgradeLastContributor", TEST_UPGRADE_LAST_CONTRIBUTOR);
        this.tableUpgrader.add("locks", "owner", "upgradeLocks", TEST_UPGRADE_LOCKS);
    }

    @Override
    public int getTableSize(String tableName) {
        return this.sqlInfo.getDatabase().getTable(tableName).getColumns().size();
    }

    @Override
    public void createDatabase() throws StorageException {
        try {
            this.createTables();
        }
        catch (Exception e) {
            this.checkConnectionReset(e);
            throw new StorageException(e);
        }
    }

    protected String getTableName(String origName) {
        if (this.dialect instanceof DialectOracle && origName.length() > 30) {
            StringBuilder sb = new StringBuilder(origName.length());
            try {
                MessageDigest digest = MessageDigest.getInstance("MD5");
                sb.append(origName.substring(0, 15));
                sb.append('_');
                digest.update(origName.getBytes());
                sb.append(Dialect.toHexString(digest.digest()).substring(0, 12));
                return sb.toString();
            }
            catch (Exception e) {
                throw new RuntimeException("Error", e);
            }
        }
        return origName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createTables() throws SQLException {
        this.sqlInfo.executeSQLStatements(null, this);
        this.sqlInfo.executeSQLStatements("first", this);
        this.sqlInfo.executeSQLStatements("beforeTableCreation", this);
        if (testProps.containsKey(TEST_UPGRADE)) {
            this.sqlInfo.executeSQLStatements(TEST_UPGRADE, this);
        }
        String schemaName = this.dialect.getConnectionSchema(this.connection);
        DatabaseMetaData metadata = this.connection.getMetaData();
        Set<String> tableNames = JDBCMapper.findTableNames(metadata, schemaName);
        Database database = this.sqlInfo.getDatabase();
        HashMap added = new HashMap();
        Statement st = null;
        try {
            st = this.connection.createStatement();
            for (Table table : database.getTables()) {
                String tableName = this.getTableName(table.getPhysicalName());
                if (tableNames.contains(tableName.toUpperCase())) {
                    this.dialect.existingTableDetected(this.connection, table, this.model, this.sqlInfo.database);
                } else {
                    boolean create = this.dialect.preCreateTable(this.connection, table, this.model, this.sqlInfo.database);
                    if (!create) {
                        log.warn((Object)("Creation skipped for table: " + tableName));
                        continue;
                    }
                    String sql = table.getCreateSql();
                    this.logger.log(sql);
                    try {
                        st.execute(sql);
                        this.countExecute();
                    }
                    catch (SQLException e) {
                        throw new SQLException("Error creating table: " + sql + " : " + e.getMessage(), e);
                    }
                    for (String s : table.getPostCreateSqls(this.model)) {
                        this.logger.log(s);
                        try {
                            st.execute(s);
                            this.countExecute();
                        }
                        catch (SQLException e) {
                            throw new SQLException("Error post creating table: " + s + " : " + e.getMessage(), e);
                        }
                    }
                    for (String s : this.dialect.getPostCreateTableSqls(table, this.model, this.sqlInfo.database)) {
                        this.logger.log(s);
                        try {
                            st.execute(s);
                            this.countExecute();
                        }
                        catch (SQLException e) {
                            throw new SQLException("Error post creating table: " + s + " : " + e.getMessage(), e);
                        }
                    }
                    added.put(table.getKey(), null);
                }
                ResultSet rs = metadata.getColumns(null, schemaName, tableName, "%");
                HashMap<String, Integer> columnTypes = new HashMap<String, Integer>();
                HashMap<String, String> columnTypeNames = new HashMap<String, String>();
                HashMap<String, Integer> columnTypeSizes = new HashMap<String, Integer>();
                while (rs.next()) {
                    String schema = rs.getString("TABLE_SCHEM");
                    if (schema != null && "INFORMATION_SCHEMA".equals(schema.toUpperCase())) continue;
                    String columnName = rs.getString("COLUMN_NAME").toUpperCase();
                    columnTypes.put(columnName, rs.getInt("DATA_TYPE"));
                    columnTypeNames.put(columnName, rs.getString("TYPE_NAME"));
                    columnTypeSizes.put(columnName, rs.getInt("COLUMN_SIZE"));
                }
                LinkedList<Column> addedColumns = new LinkedList<Column>();
                for (Column column : table.getColumns()) {
                    Integer actualSize;
                    String actualName;
                    String upperName = column.getPhysicalName().toUpperCase();
                    Integer type = (Integer)columnTypes.remove(upperName);
                    if (type == null) {
                        log.warn((Object)("Adding missing column in database: " + column.getFullQuotedName()));
                        String sql = table.getAddColumnSql(column);
                        this.logger.log(sql);
                        try {
                            st.execute(sql);
                            this.countExecute();
                        }
                        catch (SQLException e) {
                            throw new SQLException("Error adding column: " + sql + " : " + e.getMessage(), e);
                        }
                        for (String s : table.getPostAddSqls(column, this.model)) {
                            this.logger.log(s);
                            try {
                                st.execute(s);
                                this.countExecute();
                            }
                            catch (SQLException e) {
                                throw new SQLException("Error post adding column: " + s + " : " + e.getMessage(), e);
                            }
                        }
                        addedColumns.add(column);
                        continue;
                    }
                    int expected = column.getJdbcType();
                    int actual = type;
                    if (column.setJdbcType(actual, actualName = (String)columnTypeNames.get(upperName), actualSize = (Integer)columnTypeSizes.get(upperName))) continue;
                    log.error((Object)String.format("SQL type mismatch for %s: expected %s, database has %s / %s (%s)", column.getFullQuotedName(), expected, type, actualName, actualSize));
                }
                for (String col : this.dialect.getIgnoredColumns(table)) {
                    columnTypes.remove(col.toUpperCase());
                }
                if (!columnTypes.isEmpty()) {
                    log.warn((Object)("Database contains additional unused columns for table " + table.getQuotedName() + ": " + StringUtils.join(new ArrayList(columnTypes.keySet()), (String)", ")));
                }
                if (addedColumns.isEmpty()) continue;
                if (added.containsKey(table.getKey())) {
                    throw new AssertionError();
                }
                added.put(table.getKey(), addedColumns);
            }
        }
        finally {
            if (st != null) {
                try {
                    this.closeStatement(st);
                }
                catch (SQLException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        if (testProps.containsKey(TEST_UPGRADE)) {
            this.sqlInfo.executeSQLStatements("testUpgradeOldTables", this);
        }
        for (Map.Entry entry : added.entrySet()) {
            List addedColumns = (List)entry.getValue();
            String tableKey = (String)entry.getKey();
            this.upgradeTable(tableKey, addedColumns);
        }
        this.sqlInfo.executeSQLStatements("afterTableCreation", this);
        this.sqlInfo.executeSQLStatements("last", this);
        this.dialect.performAdditionalStatements(this.connection);
    }

    protected void upgradeTable(String tableKey, List<Column> addedColumns) throws SQLException {
        this.tableUpgrader.upgrade(tableKey, addedColumns);
    }

    protected static Set<String> findTableNames(DatabaseMetaData metadata, String schemaName) throws SQLException {
        HashSet<String> tableNames = new HashSet<String>();
        ResultSet rs = metadata.getTables(null, schemaName, "%", new String[]{"TABLE"});
        while (rs.next()) {
            String tableName = rs.getString("TABLE_NAME");
            tableNames.add(tableName.toUpperCase());
        }
        return tableNames;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String createClusterNode() throws StorageException {
        String string;
        Statement st = null;
        try {
            String nodeId;
            String sql = this.dialect.getClusterNodeIdSql();
            if (sql == null) {
                nodeId = null;
            } else {
                ResultSet rs;
                st = this.connection.createStatement();
                if (this.logger.isLogEnabled()) {
                    this.logger.log(sql);
                }
                if (!(rs = st.executeQuery(sql)).next()) {
                    throw new StorageException("Cannot get cluster node id");
                }
                nodeId = rs.getString(1);
                if (this.logger.isLogEnabled()) {
                    this.logger.log("  -> cluster node id: " + nodeId);
                }
            }
            this.sqlInfo.executeSQLStatements("addClusterNode", this);
            string = nodeId;
            if (st == null) return string;
        }
        catch (Exception e) {
            try {
                this.checkConnectionReset(e);
                throw new StorageException(e);
            }
            catch (Throwable throwable) {
                if (st == null) throw throwable;
                try {
                    this.closeStatement(st);
                    throw throwable;
                }
                catch (SQLException e2) {
                    log.error((Object)e2.getMessage(), (Throwable)e2);
                }
                throw throwable;
            }
        }
        try {
            this.closeStatement(st);
            return string;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return string;
    }

    @Override
    public void removeClusterNode() throws StorageException {
        try {
            this.sqlInfo.executeSQLStatements("removeClusterNode", this);
        }
        catch (Exception e) {
            this.checkConnectionReset(e);
            throw new StorageException(e);
        }
    }

    @Override
    public void insertClusterInvalidations(Invalidations invalidations, String nodeId) throws StorageException {
        String sql = this.dialect.getClusterInsertInvalidations();
        if (nodeId != null) {
            sql = String.format(sql, nodeId);
        }
        List<Column> columns = this.sqlInfo.getClusterInvalidationsColumns();
        PreparedStatement ps = null;
        try {
            ps = this.connection.prepareStatement(sql);
            int kind = 1;
            while (true) {
                Set<RowId> rowIds = invalidations.getKindSet(kind);
                HashMap<Serializable, HashSet<String>> res = new HashMap<Serializable, HashSet<String>>();
                for (RowId rowId : rowIds) {
                    HashSet<String> tableNames = (HashSet<String>)res.get(rowId.id);
                    if (tableNames == null) {
                        tableNames = new HashSet<String>();
                        res.put(rowId.id, tableNames);
                    }
                    tableNames.add(rowId.tableName);
                }
                for (Map.Entry entry : res.entrySet()) {
                    Serializable id = (Serializable)entry.getKey();
                    String[] fragments = JDBCMapper.join((Collection)entry.getValue(), ' ');
                    if (this.logger.isLogEnabled()) {
                        this.logger.logSQL(sql, Arrays.asList(id, fragments, Long.valueOf(kind)));
                    }
                    String[] frags = this.dialect.supportsArrays() && columns.get(1).getJdbcType() == 2003 ? fragments.split(" ") : fragments;
                    columns.get(0).setToPreparedStatement(ps, 1, id);
                    columns.get(1).setToPreparedStatement(ps, 2, (Serializable)frags);
                    columns.get(2).setToPreparedStatement(ps, 3, Long.valueOf(kind));
                    ps.execute();
                    this.countExecute();
                }
                if (kind == 1) {
                    kind = 2;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            this.checkConnectionReset(e);
            throw new StorageException("Could not invalidate", e);
        }
        finally {
            if (ps != null) {
                try {
                    this.closeStatement(ps);
                }
                catch (SQLException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    protected static final String join(Collection<String> strings, char sep) {
        if (strings.isEmpty()) {
            throw new RuntimeException();
        }
        if (strings.size() == 1) {
            return strings.iterator().next();
        }
        int size = 0;
        for (String word : strings) {
            size += word.length() + 1;
        }
        StringBuilder buf = new StringBuilder(size);
        for (String word : strings) {
            buf.append(word);
            buf.append(sep);
        }
        buf.setLength(size - 1);
        return buf.toString();
    }

    @Override
    public Invalidations getClusterInvalidations(String nodeId) throws StorageException {
        Invalidations invalidations = new Invalidations();
        String sql = this.dialect.getClusterGetInvalidations();
        String sqldel = this.dialect.getClusterDeleteInvalidations();
        if (nodeId != null) {
            sql = String.format(sql, nodeId);
            sqldel = String.format(sqldel, nodeId);
        }
        List<Column> columns = this.sqlInfo.getClusterInvalidationsColumns();
        Statement st = null;
        try {
            st = this.connection.createStatement();
            if (this.logger.isLogEnabled()) {
                this.logger.log(sql);
            }
            ResultSet rs = st.executeQuery(sql);
            this.countExecute();
            int n = 0;
            while (rs.next()) {
                ++n;
                Serializable id = columns.get(0).getFromResultSet(rs, 1);
                Serializable frags = columns.get(1).getFromResultSet(rs, 2);
                int kind = ((Long)columns.get(2).getFromResultSet(rs, 3)).intValue();
                String[] fragments = this.dialect.supportsArrays() && frags instanceof String[] ? (String[])frags : ((String)((Object)frags)).split(" ");
                invalidations.add(id, fragments, kind);
            }
            if (this.logger.isLogEnabled()) {
                this.logger.log("  -> " + invalidations);
            }
            if (this.dialect.isClusteringDeleteNeeded()) {
                if (this.logger.isLogEnabled()) {
                    this.logger.log(sqldel);
                }
                n = st.executeUpdate(sqldel);
                this.countExecute();
                if (this.logger.isLogEnabled()) {
                    this.logger.logCount(n);
                }
            }
            Invalidations invalidations2 = invalidations;
            return invalidations2;
        }
        catch (Exception e) {
            this.checkConnectionReset(e, true);
            throw new StorageException("Could not invalidate", e);
        }
        finally {
            if (st != null) {
                try {
                    this.closeStatement(st);
                }
                catch (SQLException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Serializable getRootId(String repositoryId) throws StorageException {
        String sql = this.sqlInfo.getSelectRootIdSql();
        try {
            if (this.logger.isLogEnabled()) {
                this.logger.logSQL(sql, Collections.singletonList(repositoryId));
            }
            PreparedStatement ps = this.connection.prepareStatement(sql);
            try {
                ps.setString(1, repositoryId);
                ResultSet rs = ps.executeQuery();
                this.countExecute();
                if (!rs.next()) {
                    if (this.logger.isLogEnabled()) {
                        this.logger.log("  -> (none)");
                    }
                    Serializable serializable = null;
                    return serializable;
                }
                Column column = this.sqlInfo.getSelectRootIdWhatColumn();
                Serializable id = column.getFromResultSet(rs, 1);
                if (this.logger.isLogEnabled()) {
                    this.logger.log("  -> " + "id" + '=' + id);
                }
                if (rs.next()) {
                    throw new StorageException("Row query for " + repositoryId + " returned several rows: " + sql);
                }
                Serializable serializable = id;
                return serializable;
            }
            finally {
                this.closeStatement(ps);
            }
        }
        catch (Exception e) {
            this.checkConnectionReset(e);
            throw new StorageException("Could not select: " + sql, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRootId(Serializable repositoryId, Serializable id) throws StorageException {
        String sql = this.sqlInfo.getInsertRootIdSql();
        try {
            PreparedStatement ps = this.connection.prepareStatement(sql);
            try {
                List<Column> columns = this.sqlInfo.getInsertRootIdColumns();
                ArrayList<Serializable> debugValues = null;
                if (this.logger.isLogEnabled()) {
                    debugValues = new ArrayList<Serializable>(2);
                }
                int i = 0;
                for (Column column : columns) {
                    Serializable v;
                    ++i;
                    String key = column.getKey();
                    if (key.equals("id")) {
                        v = id;
                    } else if (key.equals("name")) {
                        v = repositoryId;
                    } else {
                        throw new RuntimeException(key);
                    }
                    column.setToPreparedStatement(ps, i, v);
                    if (debugValues == null) continue;
                    debugValues.add(v);
                }
                if (debugValues != null) {
                    this.logger.logSQL(sql, debugValues);
                    debugValues.clear();
                }
                ps.execute();
                this.countExecute();
            }
            finally {
                this.closeStatement(ps);
            }
        }
        catch (Exception e) {
            this.checkConnectionReset(e);
            throw new StorageException("Could not insert: " + sql, e);
        }
    }

    protected QueryMaker findQueryMaker(String queryType) throws StorageException {
        for (Class<? extends QueryMaker> klass : this.queryMakerService.getQueryMakers()) {
            QueryMaker queryMaker;
            try {
                queryMaker = klass.newInstance();
            }
            catch (Exception e) {
                throw new StorageException(e);
            }
            if (!queryMaker.accepts(queryType)) continue;
            return queryMaker;
        }
        return null;
    }

    protected void prepareUserReadAcls(QueryFilter queryFilter) throws StorageException {
        String sql = this.dialect.getPrepareUserReadAclsSql();
        String principals = StringUtils.join((Object[])queryFilter.getPrincipals(), (String)"|");
        if (sql == null || principals == null) {
            return;
        }
        CallableStatement cs = null;
        try {
            cs = this.connection.prepareCall(sql);
            if (this.logger.isLogEnabled()) {
                this.logger.log(sql + " " + principals);
            }
            cs.setString(1, principals);
            cs.executeUpdate();
            this.countExecute();
        }
        catch (Exception e) {
            this.checkConnectionReset(e);
            throw new StorageException("Failed to prepare user read acl cache", e);
        }
        finally {
            if (cs != null) {
                try {
                    this.closeStatement(cs);
                }
                catch (SQLException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    @Override
    public PartialList<Serializable> query(String query, String queryType, QueryFilter queryFilter, boolean countTotal) throws StorageException {
        return this.query(query, queryType, queryFilter, countTotal ? -1L : 0L);
    }

    @Override
    public PartialList<Serializable> query(String query, String queryType, QueryFilter queryFilter, long countUpTo) throws StorageException {
        String sql;
        QueryMaker queryMaker;
        if (this.dialect.needsPrepareUserReadAcls()) {
            this.prepareUserReadAcls(queryFilter);
        }
        if ((queryMaker = this.findQueryMaker(queryType)) == null) {
            throw new StorageException("No QueryMaker accepts query: " + queryType + ": " + query);
        }
        QueryMaker.Query q = queryMaker.buildQuery(this.sqlInfo, this.model, this.pathResolver, query, queryFilter, new Object[0]);
        if (q == null) {
            this.logger.log("Query cannot return anything due to conflicting clauses");
            return new PartialList<Serializable>(Collections.emptyList(), 0L);
        }
        long limit = queryFilter.getLimit();
        long offset = queryFilter.getOffset();
        if (this.logger.isLogEnabled()) {
            sql = q.selectInfo.sql;
            if (limit != 0L) {
                sql = sql + " -- LIMIT " + limit + " OFFSET " + offset;
            }
            if (countUpTo != 0L) {
                sql = sql + " -- COUNT TOTAL UP TO " + countUpTo;
            }
            this.logger.logSQL(sql, q.selectParams);
        }
        sql = q.selectInfo.sql;
        if (countUpTo == 0L && limit > 0L && this.dialect.supportsPaging()) {
            sql = this.dialect.addPagingClause(sql, limit, offset);
            limit = 0L;
            offset = 0L;
        } else if (countUpTo > 0L && this.dialect.supportsPaging()) {
            sql = this.dialect.addPagingClause(sql, Math.max(countUpTo + 1L, limit + offset), 0L);
        }
        PreparedStatement ps = null;
        try {
            boolean available;
            ps = this.connection.prepareStatement(sql, 1004, 1007);
            int i = 1;
            for (Serializable object : q.selectParams) {
                this.setToPreparedStatement(ps, i++, object);
            }
            ResultSet rs = ps.executeQuery();
            this.countExecute();
            long totalSize = -1L;
            if (limit == 0L || offset == 0L) {
                available = rs.first();
                if (!available) {
                    totalSize = 0L;
                }
                if (limit == 0L) {
                    limit = -1L;
                }
            } else {
                available = rs.absolute((int)offset + 1);
            }
            Column column = q.selectInfo.whatColumns.get(0);
            LinkedList<Serializable> ids = new LinkedList<Serializable>();
            int rowNum = 0;
            while (available && limit != 0L) {
                Serializable id = column.getFromResultSet(rs, 1);
                ids.add(id);
                rowNum = rs.getRow();
                available = rs.next();
                --limit;
            }
            if (countUpTo != 0L && totalSize == -1L) {
                if (!available && rowNum != 0) {
                    totalSize = rowNum;
                } else {
                    rs.last();
                    totalSize = rs.getRow();
                }
                if (countUpTo > 0L && totalSize > countUpTo) {
                    totalSize = -2L;
                }
            }
            if (this.logger.isLogEnabled()) {
                this.logger.logIds(ids, countUpTo != 0L, totalSize);
            }
            PartialList<Serializable> partialList = new PartialList<Serializable>(ids, totalSize);
            return partialList;
        }
        catch (Exception e) {
            this.checkConnectionReset(e);
            throw new StorageException("Invalid query: " + query, e);
        }
        finally {
            if (ps != null) {
                try {
                    this.closeStatement(ps);
                }
                catch (SQLException e) {
                    log.error((Object)"Cannot close connection", (Throwable)e);
                }
            }
        }
    }

    protected int setToPreparedStatement(PreparedStatement ps, int i, Serializable object) throws SQLException {
        if (object instanceof Calendar) {
            Calendar cal = (Calendar)object;
            Timestamp ts = new Timestamp(cal.getTimeInMillis());
            ps.setTimestamp(i, ts, cal);
        } else if (object instanceof Date) {
            ps.setDate(i, (Date)object);
        } else if (object instanceof String[]) {
            Array array = this.dialect.createArrayOf(12, (Object[])object, this.connection);
            ps.setArray(i, array);
        } else if (object instanceof Long) {
            ps.setLong(i, (Long)object);
        } else if (object instanceof ColumnType.WrappedId) {
            this.dialect.setId(ps, i, (Serializable)((Object)object.toString()));
        } else {
            ps.setObject(i, object);
        }
        return i;
    }

    @Override
    public IterableQueryResult queryAndFetch(String query, String queryType, QueryFilter queryFilter, Object ... params) throws StorageException {
        QueryMaker queryMaker;
        if (this.dialect.needsPrepareUserReadAcls()) {
            this.prepareUserReadAcls(queryFilter);
        }
        if ((queryMaker = this.findQueryMaker(queryType)) == null) {
            throw new StorageException("No QueryMaker accepts query: " + queryType + ": " + query);
        }
        try {
            return new ResultSetQueryResult(queryMaker, query, queryFilter, this.pathResolver, this, params);
        }
        catch (Exception e) {
            this.checkConnectionReset(e);
            throw new StorageException("Invalid query: " + queryType + ": " + query, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Set<Serializable> getAncestorsIds(Collection<Serializable> ids) throws StorageException {
        HashSet<Serializable> hashSet;
        SQLInfo.SQLInfoSelect select = this.sqlInfo.getSelectAncestorsIds();
        if (select == null) {
            return this.getAncestorsIdsIterative(ids);
        }
        Serializable whereIds = this.newIdArray(ids);
        HashSet<Serializable> res = new HashSet<Serializable>();
        PreparedStatement ps = null;
        try {
            if (this.logger.isLogEnabled()) {
                this.logger.logSQL(select.sql, Collections.singleton(whereIds));
            }
            Column what = select.whatColumns.get(0);
            ps = this.connection.prepareStatement(select.sql);
            this.setToPreparedStatementIdArray(ps, 1, whereIds);
            ResultSet rs = ps.executeQuery();
            this.countExecute();
            LinkedList<Serializable> debugIds = null;
            if (this.logger.isLogEnabled()) {
                debugIds = new LinkedList<Serializable>();
            }
            while (rs.next()) {
                if (this.dialect.supportsArraysReturnInsteadOfRows()) {
                    String[] resultIds;
                    for (String id : resultIds = (String[])rs.getArray(1).getArray()) {
                        if (id == null) continue;
                        res.add((Serializable)((Object)id));
                        if (!this.logger.isLogEnabled()) continue;
                        debugIds.add((Serializable)((Object)id));
                    }
                    break;
                }
                Serializable id = what.getFromResultSet(rs, 1);
                if (id == null) continue;
                res.add(id);
                if (!this.logger.isLogEnabled()) continue;
                debugIds.add(id);
            }
            if (this.logger.isLogEnabled()) {
                this.logger.logIds(debugIds, false, 0L);
            }
            hashSet = res;
            if (ps == null) return hashSet;
        }
        catch (Exception e) {
            try {
                this.checkConnectionReset(e);
                throw new StorageException("Failed to get ancestors ids", e);
            }
            catch (Throwable throwable) {
                if (ps == null) throw throwable;
                try {
                    this.closeStatement(ps);
                    throw throwable;
                }
                catch (SQLException e2) {
                    log.error((Object)e2.getMessage(), (Throwable)e2);
                }
                throw throwable;
            }
        }
        try {
            this.closeStatement(ps);
            return hashSet;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return hashSet;
    }

    protected Set<Serializable> getAncestorsIdsIterative(Collection<Serializable> ids) throws StorageException {
        PreparedStatement ps = null;
        try {
            LinkedList<Serializable> todo = new LinkedList<Serializable>(ids);
            HashSet<Serializable> done = new HashSet<Serializable>();
            HashSet<Serializable> res = new HashSet<Serializable>();
            while (!todo.isEmpty()) {
                done.addAll(todo);
                SQLInfo.SQLInfoSelect select = this.sqlInfo.getSelectParentIds(todo.size());
                if (this.logger.isLogEnabled()) {
                    this.logger.logSQL(select.sql, todo);
                }
                Column what = select.whatColumns.get(0);
                Column where = select.whereColumns.get(0);
                ps = this.connection.prepareStatement(select.sql);
                int i = 1;
                for (Serializable id : todo) {
                    where.setToPreparedStatement(ps, i++, id);
                }
                ResultSet rs = ps.executeQuery();
                this.countExecute();
                todo = new LinkedList();
                LinkedList<Serializable> debugIds = null;
                if (this.logger.isLogEnabled()) {
                    debugIds = new LinkedList<Serializable>();
                }
                while (rs.next()) {
                    Serializable id = what.getFromResultSet(rs, 1);
                    if (id == null) continue;
                    res.add(id);
                    if (!done.contains(id)) {
                        todo.add(id);
                    }
                    if (!this.logger.isLogEnabled()) continue;
                    debugIds.add(id);
                }
                if (this.logger.isLogEnabled()) {
                    this.logger.logIds(debugIds, false, 0L);
                }
                ps.close();
                ps = null;
            }
            HashSet<Serializable> hashSet = res;
            return hashSet;
        }
        catch (Exception e) {
            this.checkConnectionReset(e);
            throw new StorageException("Failed to get ancestors ids", e);
        }
        finally {
            if (ps != null) {
                try {
                    this.closeStatement(ps);
                }
                catch (SQLException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateReadAcls() throws StorageException {
        if (!this.dialect.supportsReadAcl()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("updateReadAcls: updating (concurrent=%b) ...", this.dialect.supportsConcurrentUpdateReadAcls()));
        }
        Statement st = null;
        try {
            st = this.connection.createStatement();
            String sql = this.dialect.getUpdateReadAclsSql();
            if (this.logger.isLogEnabled()) {
                this.logger.log(sql);
            }
            if (this.dialect.supportsConcurrentUpdateReadAcls()) {
                st.execute(sql);
            } else if (this.repository.updateReadAclsLock.tryLock(2L, TimeUnit.SECONDS)) {
                try {
                    st.execute(sql);
                }
                finally {
                    this.repository.updateReadAclsLock.unlock();
                }
            } else {
                log.warn((Object)"Skipping updateReadAcls after 2s due to lock");
            }
            this.countExecute();
        }
        catch (Exception e) {
            this.checkConnectionReset(e);
            throw new StorageException("Failed to update read acls", e);
        }
        finally {
            if (st != null) {
                try {
                    this.closeStatement(st);
                }
                catch (SQLException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"updateReadAcls: done.");
        }
    }

    @Override
    public void rebuildReadAcls() throws StorageException {
        if (!this.dialect.supportsReadAcl()) {
            return;
        }
        log.debug((Object)"rebuildReadAcls: rebuilding ...");
        Statement st = null;
        try {
            st = this.connection.createStatement();
            String sql = this.dialect.getRebuildReadAclsSql();
            this.logger.log(sql);
            st.execute(sql);
            this.countExecute();
        }
        catch (Exception e) {
            this.checkConnectionReset(e);
            throw new StorageException("Failed to rebuild read acls", e);
        }
        finally {
            if (st != null) {
                try {
                    this.closeStatement(st);
                }
                catch (SQLException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        log.debug((Object)"rebuildReadAcls: done.");
    }

    @Override
    public Lock getLock(Serializable id) throws StorageException {
        Row row;
        this.checkConnectionValid();
        RowId rowId = new RowId("locks", id);
        try {
            row = this.readSimpleRow(rowId);
        }
        catch (ConnectionResetException e) {
            row = this.readSimpleRow(rowId);
        }
        return row == null ? null : new Lock((String)((Object)row.get("owner")), (Calendar)row.get("created"));
    }

    @Override
    public Lock setLock(Serializable id, Lock lock) throws StorageException {
        Lock oldLock = this.getLock(id);
        if (oldLock == null) {
            Row row = new Row("locks", id);
            row.put("owner", (Serializable)((Object)lock.getOwner()));
            row.put("created", lock.getCreated());
            this.insertSimpleRows("locks", Collections.singletonList(row));
        }
        return oldLock;
    }

    @Override
    public Lock removeLock(Serializable id, String owner, boolean force) throws StorageException {
        Lock oldLock;
        Lock lock = oldLock = force ? null : this.getLock(id);
        if (!force && owner != null) {
            if (oldLock == null) {
                return null;
            }
            if (!LockManager.canLockBeRemoved(oldLock, owner)) {
                return new Lock(oldLock, true);
            }
        }
        if (force || oldLock != null) {
            this.deleteRows("locks", Collections.singleton(id));
        }
        return oldLock;
    }

    @Override
    public void markReferencedBinaries(BinaryGarbageCollector gc) throws StorageException {
        log.debug((Object)"Starting binaries GC mark");
        Statement st = null;
        try {
            st = this.connection.createStatement();
            int i = -1;
            for (String sql : this.sqlInfo.getBinariesSql) {
                Column col = this.sqlInfo.getBinariesColumns.get(++i);
                if (this.logger.isLogEnabled()) {
                    this.logger.log(sql);
                }
                ResultSet rs = st.executeQuery(sql);
                this.countExecute();
                int n = 0;
                while (rs.next()) {
                    ++n;
                    String digest = (String)((Object)col.getFromResultSet(rs, 1));
                    if (digest == null) continue;
                    gc.mark(digest);
                }
                if (!this.logger.isLogEnabled()) continue;
                this.logger.logCount(n);
            }
        }
        catch (Exception e) {
            this.checkConnectionReset(e);
            throw new RuntimeException("Failed to mark binaries for gC", e);
        }
        finally {
            if (st != null) {
                try {
                    this.closeStatement(st);
                }
                catch (SQLException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        log.debug((Object)"End of binaries GC mark");
    }

    protected static String systemToString(Object o) {
        return o.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(o));
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        try {
            this.checkConnectionValid();
            this.xaresource.start(xid, flags);
            if (this.logger.isLogEnabled()) {
                this.logger.log("XA start on " + JDBCMapper.systemToString(xid));
            }
        }
        catch (StorageException e) {
            throw (XAException)new XAException(-3).initCause((Throwable)((Object)e));
        }
        catch (XAException e) {
            this.checkConnectionReset(e);
            this.logger.error("XA start error on " + JDBCMapper.systemToString(xid), e);
            throw e;
        }
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        try {
            this.xaresource.end(xid, flags);
            if (this.logger.isLogEnabled()) {
                this.logger.log("XA end on " + JDBCMapper.systemToString(xid));
            }
        }
        catch (NullPointerException e) {
            this.logger.error("XA end error on " + JDBCMapper.systemToString(xid), e);
            throw (XAException)new XAException(-3).initCause(e);
        }
        catch (XAException e) {
            this.logger.error("XA end error on " + JDBCMapper.systemToString(xid), e);
            throw e;
        }
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        try {
            return this.xaresource.prepare(xid);
        }
        catch (XAException e) {
            this.logger.error("XA prepare error on  " + JDBCMapper.systemToString(xid), e);
            throw e;
        }
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            this.xaresource.commit(xid, onePhase);
        }
        catch (XAException e) {
            this.logger.error("XA commit error on  " + JDBCMapper.systemToString(xid), e);
            throw e;
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        this.xaresource.forget(xid);
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        return this.xaresource.recover(flag);
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        return this.xaresource.setTransactionTimeout(seconds);
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.xaresource.getTransactionTimeout();
    }

    @Override
    public boolean isSameRM(XAResource xares) throws XAException {
        throw new UnsupportedOperationException();
    }
}

